/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Contributor;
import org.openrewrite.Maintainer;
import org.openrewrite.NlsRewrite;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.DataTableDescriptor;
import org.openrewrite.config.Environment;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.internal.lang.NonNull;

public final class RecipeDescriptor {
    private final String name;
    private final @NlsRewrite.DisplayName String displayName;
    private final @NlsRewrite.DisplayName String instanceName;
    private final @NlsRewrite.Description String description;
    private final Set<String> tags;
    private final @Nullable Duration estimatedEffortPerOccurrence;
    private final List<OptionDescriptor> options;
    private final List<RecipeDescriptor> recipeList;
    private final List<DataTableDescriptor> dataTables;
    private final List<Maintainer> maintainers;
    @Deprecated
    private final List<Contributor> contributors;
    private final List<RecipeExample> examples;
    @Deprecated
    private final URI source;

    public List<String> inferCategoriesFromName(Environment env) {
        int lastDot = this.displayName.lastIndexOf(46);
        if (lastDot == -1) {
            return Collections.emptyList();
        }
        String packageName = this.displayName.substring(0, lastDot);
        String[] parts = packageName.split("\\.");
        ArrayList<String> categories = new ArrayList<String>(parts.length);
        block0: for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            String partialPackage = String.join((CharSequence)".", Arrays.copyOfRange(parts, 0, i + 1));
            for (CategoryDescriptor categoryDescriptor : env.listCategoryDescriptors()) {
                String categoryPackageName = categoryDescriptor.getPackageName();
                if (!categoryPackageName.equals(partialPackage)) continue;
                if (categoryDescriptor.isRoot()) continue block0;
                categories.add(categoryDescriptor.getDisplayName());
                continue block0;
            }
            if (part.isEmpty()) continue;
            String capitalized = Character.toUpperCase(part.charAt(0)) + part.substring(1);
            categories.add(capitalized);
        }
        return categories;
    }

    @Generated
    public RecipeDescriptor(String name, String displayName, String instanceName, String description, Set<String> tags, @Nullable Duration estimatedEffortPerOccurrence, List<OptionDescriptor> options, List<RecipeDescriptor> recipeList, List<DataTableDescriptor> dataTables, List<Maintainer> maintainers, List<Contributor> contributors, List<RecipeExample> examples, URI source) {
        this.name = name;
        this.displayName = displayName;
        this.instanceName = instanceName;
        this.description = description;
        this.tags = tags;
        this.estimatedEffortPerOccurrence = estimatedEffortPerOccurrence;
        this.options = options;
        this.recipeList = recipeList;
        this.dataTables = dataTables;
        this.maintainers = maintainers;
        this.contributors = contributors;
        this.examples = examples;
        this.source = source;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getInstanceName() {
        return this.instanceName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public @Nullable Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public List<OptionDescriptor> getOptions() {
        return this.options;
    }

    @Generated
    public List<RecipeDescriptor> getRecipeList() {
        return this.recipeList;
    }

    @Generated
    public List<DataTableDescriptor> getDataTables() {
        return this.dataTables;
    }

    @Generated
    public List<Maintainer> getMaintainers() {
        return this.maintainers;
    }

    @Deprecated
    @Generated
    public List<Contributor> getContributors() {
        return this.contributors;
    }

    @Generated
    public List<RecipeExample> getExamples() {
        return this.examples;
    }

    @Deprecated
    @Generated
    public URI getSource() {
        return this.source;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RecipeDescriptor(name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", instanceName=" + this.getInstanceName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ", options=" + this.getOptions() + ", recipeList=" + this.getRecipeList() + ", dataTables=" + this.getDataTables() + ", maintainers=" + this.getMaintainers() + ", contributors=" + this.getContributors() + ", examples=" + this.getExamples() + ", source=" + this.getSource() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeDescriptor)) {
            return false;
        }
        RecipeDescriptor other = (RecipeDescriptor)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<OptionDescriptor> this$options = this.getOptions();
        List<OptionDescriptor> other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<OptionDescriptor> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public RecipeDescriptor withRecipeList(List<RecipeDescriptor> recipeList) {
        return this.recipeList == recipeList ? this : new RecipeDescriptor(this.name, this.displayName, this.instanceName, this.description, this.tags, this.estimatedEffortPerOccurrence, this.options, recipeList, this.dataTables, this.maintainers, this.contributors, this.examples, this.source);
    }

    @NonNull
    @Generated
    public RecipeDescriptor withDataTables(List<DataTableDescriptor> dataTables) {
        return this.dataTables == dataTables ? this : new RecipeDescriptor(this.name, this.displayName, this.instanceName, this.description, this.tags, this.estimatedEffortPerOccurrence, this.options, this.recipeList, dataTables, this.maintainers, this.contributors, this.examples, this.source);
    }
}

