/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Validated;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;

public class CaretRange
extends LatestRelease {
    private static final Pattern CARET_RANGE_PATTERN = Pattern.compile("\\^(\\d+)(?:\\.([*xX]|\\d+))?(?:\\.([*xX]|\\d+))?(?:\\.([*xX]|\\d+))?");
    private final String upperExclusive;
    private final String lower;

    private CaretRange(String lower, String upperExclusive, @Nullable String metadataPattern) {
        super(metadataPattern);
        this.lower = lower;
        this.upperExclusive = upperExclusive;
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        return super.isValid(currentVersion, version) && super.compare(currentVersion, version, this.upperExclusive) < 0 && super.compare(currentVersion, version, this.lower) >= 0;
    }

    public static Validated<CaretRange> build(String pattern, @Nullable String metadataPattern) {
        Matcher matcher = CARET_RANGE_PATTERN.matcher(pattern);
        if (!matcher.matches()) {
            return Validated.invalid("caretRange", pattern, "not a caret range");
        }
        String major = matcher.group(1);
        String minor = CaretRange.normalizeWildcard(matcher.group(2));
        String patch = CaretRange.normalizeWildcard(matcher.group(3));
        String micro = CaretRange.normalizeWildcard(matcher.group(4));
        if ("*".equals(minor) && (matcher.group(3) != null || matcher.group(4) != null)) {
            return Validated.invalid("caretRange", pattern, "not a caret range: nothing can follow a wildcard");
        }
        if ("*".equals(patch) && matcher.group(4) != null) {
            return Validated.invalid("caretRange", pattern, "not a caret range: nothing can follow a wildcard");
        }
        String lower = minor == null ? major : (patch == null ? major + "." + minor : (micro == null ? major + "." + minor + "." + patch : major + "." + minor + "." + patch + "." + micro));
        String upper = minor == null ? Integer.toString(Integer.parseInt(major) + 1) : (patch == null ? ("0".equals(major) ? "0." + (Integer.parseInt(minor) + 1) : Integer.parseInt(major) + 1 + ".0") : (micro == null ? ("0".equals(major) ? "0." + (Integer.parseInt(minor) + 1) + ".0" : Integer.parseInt(major) + 1 + ".0.0") : ("0".equals(major) ? "0." + (Integer.parseInt(minor) + 1) + ".0.0" : Integer.parseInt(major) + 1 + ".0.0.0")));
        return Validated.valid("caretRange", new CaretRange(lower, upper, metadataPattern));
    }

    private static @Nullable String normalizeWildcard(@Nullable String part) {
        return "*".equals(part) || "x".equals(part) || "X".equals(part) ? null : part;
    }

    @Override
    public int compare(@Nullable String currentVersion, String v1, String v2) {
        Validated<CaretRange> maybeCaretV1 = CaretRange.build(v1, null);
        Validated<CaretRange> maybeCaretV2 = CaretRange.build(v2, null);
        if (maybeCaretV1.isValid() && maybeCaretV2.isValid()) {
            CaretRange caretV1 = Objects.requireNonNull(maybeCaretV1.getValue());
            CaretRange caretV2 = Objects.requireNonNull(maybeCaretV2.getValue());
            int compare = super.compare(currentVersion, caretV1.upperExclusive, caretV2.upperExclusive);
            if (compare != 0) {
                return compare;
            }
            return super.compare(currentVersion, caretV1.lower, caretV2.lower);
        }
        if (maybeCaretV1.isValid()) {
            if (!Semver.isVersion(v2)) {
                return 1;
            }
            CaretRange caretV1 = Objects.requireNonNull(maybeCaretV1.getValue());
            int compare = super.compare(currentVersion, caretV1.upperExclusive, v2);
            if (compare < 0) {
                return compare;
            }
            if (compare == 0) {
                return -1;
            }
            compare = super.compare(currentVersion, caretV1.lower, v2);
            return Math.max(compare, 0);
        }
        if (maybeCaretV2.isValid()) {
            if (!Semver.isVersion(v1)) {
                return -1;
            }
            CaretRange caretV2 = Objects.requireNonNull(maybeCaretV2.getValue());
            int compare = super.compare(currentVersion, v1, caretV2.upperExclusive);
            if (compare > 0) {
                return compare;
            }
            if (compare == 0) {
                return 1;
            }
            compare = super.compare(currentVersion, v1, caretV2.lower);
            return Math.min(compare, 0);
        }
        return super.compare(currentVersion, v1, v2);
    }
}

