/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.TildeRange;
import org.openrewrite.semver.VersionComparator;

public final class LatestMinor
implements VersionComparator {
    private final @Nullable String metadataPattern;

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        VersionComparator comparator;
        Validated<LatestRelease> validated;
        Validated<LatestRelease> validated2 = validated = currentVersion == null ? LatestRelease.buildLatestRelease("latest.release", this.metadataPattern) : TildeRange.build("~" + Semver.majorVersion(currentVersion), this.metadataPattern, true);
        if (validated.isValid() && (comparator = (VersionComparator)validated.getValue()) != null) {
            return comparator.isValid(currentVersion, version);
        }
        return false;
    }

    @Override
    public int compare(@Nullable String currentVersion, String v1, String v2) {
        if (currentVersion == null) {
            return new LatestRelease(null).compare(null, v1, v2);
        }
        return TildeRange.build("~" + Semver.majorVersion(currentVersion) + "." + Semver.minorVersion(currentVersion), this.metadataPattern).getValue().compare(currentVersion, v1, v2);
    }

    public static Validated<LatestMinor> build(String toVersion, @Nullable String metadataPattern) {
        return "latest.minor".equalsIgnoreCase(toVersion) ? Validated.valid("latestMinor", new LatestMinor(metadataPattern)) : Validated.invalid("latestMinor", toVersion, "not latest minor");
    }

    @Generated
    public LatestMinor(@Nullable String metadataPattern) {
        this.metadataPattern = metadataPattern;
    }

    @Generated
    public @Nullable String getMetadataPattern() {
        return this.metadataPattern;
    }

    @Override
    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LatestMinor)) {
            return false;
        }
        LatestMinor other = (LatestMinor)o;
        String this$metadataPattern = this.getMetadataPattern();
        String other$metadataPattern = other.getMetadataPattern();
        return !(this$metadataPattern == null ? other$metadataPattern != null : !this$metadataPattern.equals(other$metadataPattern));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $metadataPattern = this.getMetadataPattern();
        result = result * 59 + ($metadataPattern == null ? 43 : $metadataPattern.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "LatestMinor(metadataPattern=" + this.getMetadataPattern() + ")";
    }
}

