/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaUnrestrictedClassLoader;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;

public class Java11Parser
implements JavaParser {
    private final JavaParser delegate;

    Java11Parser(JavaParser delegate) {
        this.delegate = delegate;
    }

    public List<J.CompilationUnit> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.delegate.parseInputs(sourceFiles, relativeTo, ctx);
    }

    public JavaParser reset() {
        this.delegate.reset();
        return this;
    }

    public void setClasspath(Collection<Path> classpath) {
        this.delegate.setClasspath(classpath);
    }

    public void setSourceSet(String sourceSet) {
        this.delegate.setSourceSet(sourceSet);
    }

    public JavaSourceSet getSourceSet(ExecutionContext ctx) {
        return this.delegate.getSourceSet(ctx);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends JavaParser.Builder<Java11Parser, Builder> {
        @Nullable
        private static ClassLoader moduleClassLoader;

        static synchronized void lazyInitClassLoaders() {
            if (moduleClassLoader != null) {
                return;
            }
            ClassLoader appClassLoader = Java11Parser.class.getClassLoader();
            moduleClassLoader = new JavaUnrestrictedClassLoader(appClassLoader);
        }

        public Java11Parser build() {
            Builder.lazyInitClassLoaders();
            try {
                Class<?> parserImplementation = Class.forName("org.openrewrite.java.isolated.ReloadableJava11Parser", true, moduleClassLoader);
                Constructor<?> parserConstructor = parserImplementation.getDeclaredConstructor(Boolean.TYPE, Collection.class, Collection.class, Collection.class, Charset.class, Collection.class, JavaTypeCache.class);
                parserConstructor.setAccessible(true);
                JavaParser delegate = (JavaParser)parserConstructor.newInstance(this.logCompilationWarningsAndErrors, this.classpath, this.classBytesClasspath, this.dependsOn, this.charset, this.styles, this.javaTypeCache);
                return new Java11Parser(delegate);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to construct Java11Parser.", e);
            }
        }
    }
}

