/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public class LambdaBlockToExpression
extends Recipe {
    public String getDisplayName() {
        return "Simplify lambda blocks to expressions";
    }

    public String getDescription() {
        return "Single-line statement lambdas returning a value can be replaced with expression lambdas.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                if (cu instanceof J.CompilationUnit) {
                    return (JavaSourceFile)cu.withMarkers(cu.getMarkers().add((Marker)new SearchResult(Tree.randomId(), null)));
                }
                return cu;
            }
        };
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext executionContext) {
                List<Statement> statements;
                J l = super.visitLambda(lambda, executionContext);
                if (lambda.getBody() instanceof J.Block && (statements = ((J.Block)lambda.getBody()).getStatements()).size() == 1 && statements.get(0) instanceof J.Return) {
                    return ((J.Lambda)l).withBody(((J.Return)statements.get(0)).getExpression());
                }
                return l;
            }
        };
    }
}

