/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.openrewrite.Cursor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.internal.template.JavaTemplateParser;
import org.openrewrite.java.internal.template.Substitutions;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.internal.template.KotlinSubstitutions;
import org.openrewrite.kotlin.internal.template.KotlinTemplateParser;

public class KotlinTemplate
extends JavaTemplate {
    private KotlinTemplate(boolean contextSensitive, KotlinParser.Builder parser, String code, Set<String> imports, Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate) {
        super(code, Collections.emptySet(), onAfterVariableSubstitution, (JavaTemplateParser)new KotlinTemplateParser(contextSensitive, KotlinTemplate.augmentClasspath(parser), onAfterVariableSubstitution, onBeforeParseTemplate, imports));
    }

    private static KotlinParser.Builder augmentClasspath(KotlinParser.Builder parserBuilder) {
        return parserBuilder.addClasspathEntry(KotlinTemplate.getTemplateClasspathDir());
    }

    protected Substitutions substitutions(Object[] parameters) {
        return new KotlinSubstitutions(this.getCode(), parameters);
    }

    public static <J2 extends J> J2 apply(String template, Cursor scope, JavaCoordinates coordinates, Object ... parameters) {
        return (J2)KotlinTemplate.builder(template).build().apply(scope, coordinates, parameters);
    }

    public static Builder builder(String code) {
        return new Builder(code);
    }

    public static boolean matches(String template, Cursor cursor) {
        return KotlinTemplate.builder(template).build().matches(cursor);
    }

    public static class Builder
    extends JavaTemplate.Builder {
        private final String code;
        private final Set<String> imports = new HashSet<String>();
        private KotlinParser.Builder parser = KotlinParser.builder();
        private Consumer<String> onAfterVariableSubstitution = s -> {};
        private Consumer<String> onBeforeParseTemplate = s -> {};

        Builder(String code) {
            super(code);
            this.code = code;
        }

        public JavaTemplate.Builder contextSensitive() {
            throw new UnsupportedOperationException("Only context-free templates are supported");
        }

        public Builder imports(String ... fullyQualifiedTypeNames) {
            for (String typeName : fullyQualifiedTypeNames) {
                this.validateImport(typeName);
                this.imports.add("import " + typeName + "\n");
            }
            return this;
        }

        private void validateImport(String typeName) {
            if (StringUtils.isBlank((String)typeName)) {
                throw new IllegalArgumentException("Imports must not be blank");
            }
            if (typeName.startsWith("import ")) {
                throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include an \"import \" prefix");
            }
            if (typeName.endsWith(";") || typeName.endsWith("\n")) {
                throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include a suffixed terminator");
            }
        }

        Builder parser(KotlinParser.Builder parser) {
            this.parser = parser;
            return this;
        }

        public Builder doAfterVariableSubstitution(Consumer<String> afterVariableSubstitution) {
            this.onAfterVariableSubstitution = afterVariableSubstitution;
            return this;
        }

        public Builder doBeforeParseTemplate(Consumer<String> beforeParseTemplate) {
            this.onBeforeParseTemplate = beforeParseTemplate;
            return this;
        }

        public KotlinTemplate build() {
            return new KotlinTemplate(false, this.parser.clone(), this.code, this.imports, this.onAfterVariableSubstitution, this.onBeforeParseTemplate);
        }
    }
}

