/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.tree.K;

public class RemoveTrailingWhitespaceVisitor<P>
extends KotlinIsoVisitor<P> {
    private final @Nullable Tree stopAfter;

    @JsonCreator
    public RemoveTrailingWhitespaceVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public RemoveTrailingWhitespaceVisitor() {
        this(null);
    }

    @Override
    public K.CompilationUnit visitCompilationUnit(K.CompilationUnit cu, P p) {
        String eof = cu.getEof().getWhitespace();
        StringBuilder builder = new StringBuilder();
        for (char c : eof.toCharArray()) {
            if (c != '\n' && c != '\r') continue;
            builder.appendCodePoint(c);
        }
        eof = builder.toString();
        J c = super.visitCompilationUnit(cu, (Object)p);
        return c.withEof(c.getEof().withWhitespace(eof));
    }

    public Space visitSpace(Space space, Space.Location loc, P p) {
        Space s = space;
        int lastNewline = s.getWhitespace().lastIndexOf(10);
        if (lastNewline > 0 && loc != Space.Location.IMPORT_PREFIX) {
            StringBuilder ws = new StringBuilder();
            char[] charArray = s.getWhitespace().toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                char c = charArray[i];
                if (i >= lastNewline) {
                    ws.append(c);
                    continue;
                }
                if (c != ',' && c != '\r' && c != '\n') continue;
                ws.append(c);
            }
            s = s.withWhitespace(ws.toString());
        }
        return s;
    }

    public @Nullable J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    public @Nullable J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }
}

