/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.format.BlankLinesVisitor;
import org.openrewrite.kotlin.format.ImportReorderingVisitor;
import org.openrewrite.kotlin.format.MergeSpacesVisitor;
import org.openrewrite.kotlin.format.MinimumViableSpacingVisitor;
import org.openrewrite.kotlin.format.NormalizeFormatVisitor;
import org.openrewrite.kotlin.format.NormalizeLineBreaksVisitor;
import org.openrewrite.kotlin.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.kotlin.format.RemoveTrailingWhitespaceVisitor;
import org.openrewrite.kotlin.format.SpacesVisitor;
import org.openrewrite.kotlin.format.TabsAndIndentsVisitor;
import org.openrewrite.kotlin.format.TrailingCommaVisitor;
import org.openrewrite.kotlin.format.WrappingAndBracesVisitor;
import org.openrewrite.kotlin.style.BlankLinesStyle;
import org.openrewrite.kotlin.style.IntelliJ;
import org.openrewrite.kotlin.style.SpacesStyle;
import org.openrewrite.kotlin.style.TabsAndIndentsStyle;
import org.openrewrite.kotlin.style.WrappingAndBracesStyle;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.Style;

public class AutoFormatVisitor<P>
extends KotlinIsoVisitor<P> {
    private final @Nullable Tree stopAfter;

    public AutoFormatVisitor() {
        this(null);
    }

    public AutoFormatVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public J visit(@Nullable Tree tree, P p, Cursor cursor) {
        JavaSourceFile cu = tree instanceof JavaSourceFile ? (JavaSourceFile)tree : (JavaSourceFile)cursor.firstEnclosingOrThrow(JavaSourceFile.class);
        tree = new ImportReorderingVisitor().visitNonNull(tree, p, cursor.fork());
        J t = (J)new NormalizeFormatVisitor(this.stopAfter).visit(tree, p, cursor.fork());
        t = (J)new MinimumViableSpacingVisitor(this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new BlankLinesVisitor((BlankLinesStyle)Style.from(BlankLinesStyle.class, (SourceFile)cu, IntelliJ::blankLines), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new WrappingAndBracesVisitor((WrappingAndBracesStyle)Style.from(WrappingAndBracesStyle.class, (SourceFile)cu, IntelliJ::wrappingAndBraces), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new SpacesVisitor((SpacesStyle)Style.from(SpacesStyle.class, (SourceFile)cu, IntelliJ::spaces), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new NormalizeTabsOrSpacesVisitor((TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)cu, IntelliJ::tabsAndIndents), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = new TabsAndIndentsVisitor<P>((TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)cu, IntelliJ::tabsAndIndents), (WrappingAndBracesStyle)Style.from(WrappingAndBracesStyle.class, (SourceFile)cu, IntelliJ::wrappingAndBraces), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new NormalizeLineBreaksVisitor((GeneralFormatStyle)Style.from(GeneralFormatStyle.class, (SourceFile)cu, () -> new GeneralFormatStyle(false)), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visit((Tree)t, p, cursor.fork());
        return (J)new MergeSpacesVisitor().visit(tree, t);
    }

    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
            if (!(cu instanceof K.CompilationUnit)) {
                return cu;
            }
            tree = new ImportReorderingVisitor().visitNonNull(tree, p);
            tree = new TrailingCommaVisitor(IntelliJ.other().getUseTrailingComma()).visitNonNull(tree, p);
            JavaSourceFile t = (JavaSourceFile)new NormalizeFormatVisitor<P>(this.stopAfter).visit(tree, p);
            t = (JavaSourceFile)new MinimumViableSpacingVisitor<P>(this.stopAfter).visit((Tree)t, p);
            t = (JavaSourceFile)new BlankLinesVisitor<P>((BlankLinesStyle)Style.from(BlankLinesStyle.class, (SourceFile)cu, IntelliJ::blankLines), this.stopAfter).visit((Tree)t, p);
            t = (JavaSourceFile)new WrappingAndBracesVisitor<P>((WrappingAndBracesStyle)Style.from(WrappingAndBracesStyle.class, (SourceFile)cu, IntelliJ::wrappingAndBraces), this.stopAfter).visit((Tree)t, p);
            t = (JavaSourceFile)new SpacesVisitor<P>((SpacesStyle)Style.from(SpacesStyle.class, (SourceFile)cu, IntelliJ::spaces), this.stopAfter).visit((Tree)t, p);
            t = (JavaSourceFile)new NormalizeTabsOrSpacesVisitor<P>((TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)cu, IntelliJ::tabsAndIndents), this.stopAfter).visit((Tree)t, p);
            t = (JavaSourceFile)new TabsAndIndentsVisitor<P>((TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)cu, IntelliJ::tabsAndIndents), (WrappingAndBracesStyle)Style.from(WrappingAndBracesStyle.class, (SourceFile)cu, IntelliJ::wrappingAndBraces), this.stopAfter).visit((Tree)t, p);
            t = (JavaSourceFile)new NormalizeLineBreaksVisitor<P>((GeneralFormatStyle)Style.from(GeneralFormatStyle.class, (SourceFile)cu, () -> new GeneralFormatStyle(false)), this.stopAfter).visit((Tree)t, p);
            t = (JavaSourceFile)new RemoveTrailingWhitespaceVisitor<P>(this.stopAfter).visit((Tree)t, p);
            return (J)new MergeSpacesVisitor().visit(tree, t);
        }
        return (J)tree;
    }
}

