/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.UpdateMavenModel;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Plugin;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public class MavenVisitor<P>
extends XmlVisitor<P> {
    static final XPathMatcher DEPENDENCY_MATCHER = new XPathMatcher("/project/dependencies/dependency");
    static final XPathMatcher PLUGIN_DEPENDENCY_MATCHER = new XPathMatcher("//plugins/plugin/dependencies/dependency");
    static final XPathMatcher MANAGED_DEPENDENCY_MATCHER = new XPathMatcher("/project/dependencyManagement/dependencies/dependency");
    static final XPathMatcher PROPERTY_MATCHER = new XPathMatcher("/project/properties/*");
    static final XPathMatcher PLUGIN_MATCHER = new XPathMatcher("//plugins/plugin");
    static final XPathMatcher PARENT_MATCHER = new XPathMatcher("/project/parent");
    @Nullable
    private transient Xml.Document document;
    @Nullable
    private transient MavenResolutionResult resolutionResult;

    public String getLanguage() {
        return "maven";
    }

    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return super.isAcceptable(sourceFile, p) && sourceFile.getMarkers().findFirst(MavenResolutionResult.class).isPresent();
    }

    protected MavenResolutionResult getResolutionResult() {
        Iterator itr = this.getCursor().getPath(Xml.Document.class::isInstance);
        if (itr.hasNext()) {
            Xml.Document newDocument = (Xml.Document)itr.next();
            if (this.document != null && this.document != newDocument) {
                throw new IllegalStateException("The same MavenVisitor instance has been used on two different XML documents. This violates the Recipe contract that they will return a unique visitor instance every time getVisitor() is called.");
            }
            this.document = newDocument;
        }
        if (this.resolutionResult == null) {
            this.resolutionResult = (MavenResolutionResult)Optional.ofNullable(this.document).map(Xml.Document::getMarkers).flatMap(markers -> markers.findFirst(MavenResolutionResult.class)).orElseThrow(() -> new IllegalStateException("Maven visitors should not be visiting XML documents without a Maven marker"));
        }
        return this.resolutionResult;
    }

    public boolean isPropertyTag() {
        return PROPERTY_MATCHER.matches(this.getCursor());
    }

    public boolean isDependencyTag() {
        return this.isTag("dependency") && DEPENDENCY_MATCHER.matches(this.getCursor());
    }

    public boolean isDependencyTag(String groupId, String artifactId) {
        if (!this.isDependencyTag()) {
            return false;
        }
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        Map<Scope, List<ResolvedDependency>> dependencies = this.getResolutionResult().getDependencies();
        for (Scope scope : Scope.values()) {
            if (!dependencies.containsKey((Object)scope)) continue;
            for (ResolvedDependency resolvedDependency : dependencies.get((Object)scope)) {
                Dependency req;
                String reqGroup;
                Scope tagScope;
                if (!StringUtils.matchesGlob((String)resolvedDependency.getGroupId(), (String)groupId) || !StringUtils.matchesGlob((String)resolvedDependency.getArtifactId(), (String)artifactId)) continue;
                String scopeName = tag.getChildValue("scope").orElse(null);
                Scope scope2 = tagScope = scopeName != null ? Scope.fromName(scopeName) : null;
                if (tagScope == null && (tagScope = this.getResolutionResult().getPom().getManagedScope(groupId, artifactId, tag.getChildValue("type").orElse(null), tag.getChildValue("classifier").orElse(null))) == null) {
                    tagScope = Scope.Compile;
                }
                if ((reqGroup = (req = resolvedDependency.getRequested()).getGroupId()) != null && !reqGroup.equals(tag.getChildValue("groupId").orElse(null)) || !req.getArtifactId().equals(tag.getChildValue("artifactId").orElse(null)) || scope != tagScope) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPluginDependencyTag(String groupId, String artifactId) {
        if (!PLUGIN_DEPENDENCY_MATCHER.matches(this.getCursor())) {
            return false;
        }
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        return StringUtils.matchesGlob((String)tag.getChildValue("groupId").orElse(null), (String)groupId) && StringUtils.matchesGlob((String)tag.getChildValue("artifactId").orElse(null), (String)artifactId);
    }

    public boolean isManagedDependencyTag() {
        return this.isTag("dependency") && MANAGED_DEPENDENCY_MATCHER.matches(this.getCursor());
    }

    public boolean isManagedDependencyTag(String groupId, String artifactId) {
        if (!this.isManagedDependencyTag()) {
            return false;
        }
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        for (ResolvedManagedDependency dm : this.getResolutionResult().getPom().getDependencyManagement()) {
            ManagedDependency requestedBom;
            ManagedDependency req;
            String reqGroup;
            if (StringUtils.matchesGlob((String)dm.getGroupId(), (String)groupId) && StringUtils.matchesGlob((String)dm.getArtifactId(), (String)artifactId) && (reqGroup = (req = dm.getRequested()).getGroupId()).equals(tag.getChildValue("groupId").orElse(null)) && req.getArtifactId().equals(tag.getChildValue("artifactId").orElse(null)) && dm.getScope() == tag.getChildValue("scope").map(Scope::fromName).orElse(null)) {
                return true;
            }
            if (dm.getBomGav() == null || !StringUtils.matchesGlob((String)dm.getBomGav().getGroupId(), (String)groupId) || !StringUtils.matchesGlob((String)dm.getBomGav().getArtifactId(), (String)artifactId) || !(requestedBom = dm.getRequestedBom()).getGroupId().equals(tag.getChildValue("groupId").orElse(null)) || !requestedBom.getArtifactId().equals(tag.getChildValue("artifactId").orElse(null))) continue;
            return true;
        }
        return false;
    }

    public boolean isManagedDependencyImportTag(String groupId, String artifactId) {
        if (!this.isManagedDependencyTag(groupId, artifactId)) {
            return false;
        }
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        return tag.getChildValue("type").map("pom"::equalsIgnoreCase).orElse(false) != false && tag.getChildValue("scope").map("import"::equalsIgnoreCase).orElse(false) != false;
    }

    public void maybeUpdateModel() {
        for (TreeVisitor afterVisit : this.getAfterVisit()) {
            if (!(afterVisit instanceof UpdateMavenModel)) continue;
            return;
        }
        this.doAfterVisit((TreeVisitor)new UpdateMavenModel());
    }

    public boolean isPluginTag() {
        return this.isTag("plugin") && PLUGIN_MATCHER.matches(this.getCursor());
    }

    public boolean isPluginTag(String groupId, @Nullable String artifactId) {
        return this.isPluginTag() && this.hasPluginGroupId(groupId) && this.hasPluginArtifactId(artifactId);
    }

    private boolean hasPluginGroupId(String groupId) {
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        boolean isGroupIdFound = StringUtils.matchesGlob((String)tag.getChildValue("groupId").orElse("org.apache.maven.plugins"), (String)groupId);
        if (!isGroupIdFound && this.getResolutionResult().getPom().getProperties() != null && tag.getChildValue("groupId").isPresent() && ((String)tag.getChildValue("groupId").get()).trim().startsWith("${")) {
            String propertyKey = ((String)tag.getChildValue("groupId").get()).trim();
            String value = this.getResolutionResult().getPom().getValue(propertyKey);
            isGroupIdFound = value != null && StringUtils.matchesGlob((String)value, (String)groupId);
        }
        return isGroupIdFound;
    }

    private boolean hasPluginArtifactId(@Nullable String artifactId) {
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        boolean isArtifactIdFound = tag.getChildValue("artifactId").map(a -> StringUtils.matchesGlob((String)a, (String)artifactId)).orElse(artifactId == null);
        if (!isArtifactIdFound && artifactId != null && this.getResolutionResult().getPom().getProperties() != null && tag.getChildValue("artifactId").isPresent() && ((String)tag.getChildValue("artifactId").get()).trim().startsWith("${")) {
            String propertyKey = ((String)tag.getChildValue("artifactId").get()).trim();
            String value = this.getResolutionResult().getPom().getValue(propertyKey);
            isArtifactIdFound = value != null && StringUtils.matchesGlob((String)value, (String)artifactId);
        }
        return isArtifactIdFound;
    }

    public boolean isParentTag() {
        return this.isTag("parent") && PARENT_MATCHER.matches(this.getCursor());
    }

    private boolean isTag(String name) {
        return this.getCursor().getValue() instanceof Xml.Tag && name.equals(((Xml.Tag)this.getCursor().getValue()).getName());
    }

    @Nullable
    public ResolvedDependency findDependency(Xml.Tag tag) {
        Scope scope;
        Map<Scope, List<ResolvedDependency>> dependencies = this.getResolutionResult().getDependencies();
        if (dependencies.containsKey((Object)(scope = Scope.fromName(tag.getChildValue("scope").orElse("compile"))))) {
            for (ResolvedDependency resolvedDependency : dependencies.get((Object)scope)) {
                Dependency req = resolvedDependency.getRequested();
                String reqGroup = req.getGroupId();
                String reqVersion = req.getVersion();
                if (reqGroup != null && !reqGroup.equals(tag.getChildValue("groupId").orElse(null)) || !req.getArtifactId().equals(tag.getChildValue("artifactId").orElse(null)) || reqVersion != null && !reqVersion.equals(tag.getChildValue("version").orElse(null)) || req.getClassifier() != null && !req.getClassifier().equals(tag.getChildValue("classifier").orElse(null))) continue;
                return resolvedDependency;
            }
        }
        return null;
    }

    @Nullable
    public ResolvedManagedDependency findManagedDependency(Xml.Tag tag) {
        String groupId = this.getResolutionResult().getPom().getValue(tag.getChildValue("groupId").orElse(this.getResolutionResult().getPom().getGroupId()));
        String artifactId = this.getResolutionResult().getPom().getValue(tag.getChildValue("artifactId").orElse(""));
        String classifier = this.getResolutionResult().getPom().getValue(tag.getChildValue("classifier").orElse(null));
        if (groupId != null && artifactId != null) {
            return this.findManagedDependency(groupId, artifactId, classifier);
        }
        return null;
    }

    @Nullable
    public ResolvedManagedDependency findManagedDependency(String groupId, String artifactId) {
        return this.findManagedDependency(groupId, artifactId, null);
    }

    @Nullable
    private ResolvedManagedDependency findManagedDependency(String groupId, String artifactId, @Nullable String classifier) {
        for (ResolvedManagedDependency d : this.getResolutionResult().getPom().getDependencyManagement()) {
            if (!groupId.equals(d.getGroupId()) || !artifactId.equals(d.getArtifactId()) || classifier != null && !classifier.equals(d.getClassifier())) continue;
            return d;
        }
        return null;
    }

    @Nullable
    public ResolvedManagedDependency findManagedDependency(Xml.Tag tag, @Nullable Scope inClasspathOf) {
        Scope tagScope = Scope.fromName(tag.getChildValue("scope").orElse(null));
        if (inClasspathOf != null && tagScope != inClasspathOf && !tagScope.isInClasspathOf(inClasspathOf)) {
            return null;
        }
        return this.findManagedDependency(tag);
    }

    @Nullable
    public ResolvedDependency findDependency(Xml.Tag tag, @Nullable Scope inClasspathOf) {
        Scope tagScope = Scope.fromName(tag.getChildValue("scope").orElse("compile"));
        if (inClasspathOf != null && tagScope != inClasspathOf && !tagScope.isInClasspathOf(inClasspathOf)) {
            return null;
        }
        for (Map.Entry<Scope, List<ResolvedDependency>> scope : this.getResolutionResult().getDependencies().entrySet()) {
            if (inClasspathOf != null && scope.getKey() != inClasspathOf && !scope.getKey().isInClasspathOf(inClasspathOf)) continue;
            for (ResolvedDependency d : scope.getValue()) {
                if (!tag.getChildValue("groupId").orElse(this.getResolutionResult().getPom().getGroupId()).equals(d.getGroupId()) || !tag.getChildValue("artifactId").orElse(this.getResolutionResult().getPom().getArtifactId()).equals(d.getArtifactId())) continue;
                return d;
            }
        }
        return null;
    }

    public List<ResolvedDependency> findDependencies(String groupId, String artifactId) {
        return this.getResolutionResult().findDependencies(groupId, artifactId, null);
    }

    public Collection<ResolvedDependency> findDependencies(Predicate<ResolvedDependency> matcher) {
        ArrayList<ResolvedDependency> found = null;
        for (List<ResolvedDependency> scope : this.getResolutionResult().getDependencies().values()) {
            for (ResolvedDependency d : scope) {
                if (!matcher.test(d)) continue;
                if (found == null) {
                    found = new ArrayList<ResolvedDependency>();
                }
                found.add(d);
            }
        }
        return found == null ? Collections.emptyList() : found;
    }

    public MavenMetadata downloadMetadata(String groupId, String artifactId, ExecutionContext ctx) throws MavenDownloadingException {
        return this.downloadMetadata(groupId, artifactId, null, ctx);
    }

    public MavenMetadata downloadMetadata(String groupId, String artifactId, @Nullable ResolvedPom containingPom, ExecutionContext ctx) throws MavenDownloadingException {
        return new MavenPomDownloader(Collections.emptyMap(), ctx, this.getResolutionResult().getMavenSettings(), this.getResolutionResult().getActiveProfiles()).downloadMetadata(new GroupArtifact(groupId, artifactId), containingPom, this.getResolutionResult().getPom().getRepositories());
    }

    public boolean isDependencyLikeTag() {
        return this.isManagedDependencyTag() || this.isDependencyTag() || this.isPluginTag();
    }

    @Nullable
    public Plugin findPlugin(Xml.Tag tag) {
        List<Plugin> plugins = this.getResolutionResult().getPom().getPlugins();
        if (plugins != null) {
            for (Plugin resolvedPlugin : plugins) {
                String reqGroup = resolvedPlugin.getGroupId();
                String reqVersion = resolvedPlugin.getVersion();
                if (reqGroup != null && !reqGroup.equals(tag.getChildValue("groupId").orElse(null)) || !resolvedPlugin.getArtifactId().equals(tag.getChildValue("artifactId").orElse(null)) || reqVersion != null && !reqVersion.equals(tag.getChildValue("version").orElse(null))) continue;
                return resolvedPlugin;
            }
        }
        return null;
    }
}

