/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.marketplace;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.config.ClasspathScanningLoader;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.internal.RecipeLoader;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.maven.marketplace.RecipeClassLoader;
import org.openrewrite.maven.marketplace.RecipeClassLoaderFactory;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public class ResolvedMavenRecipeBundle
implements RecipeBundle {
    private final ResolvedGroupArtifactVersion gav;
    private final Path recipeJar;
    private final List<Path> classpath;
    private final RecipeClassLoaderFactory classLoaderFactory;
    private final @Nullable String team;
    private transient @Nullable Environment environment;
    private transient @Nullable RecipeLoader recipeLoader;
    private transient @Nullable ClassLoader classLoader;

    public String getPackageEcosystem() {
        return "maven";
    }

    public String getPackageName() {
        return this.gav.getGroupId() + ":" + this.gav.getArtifactId();
    }

    public @Nullable String getVersion() {
        return this.gav.getDatedSnapshotVersion() == null ? this.gav.getVersion() : this.gav.getDatedSnapshotVersion();
    }

    public RecipeDescriptor describe(RecipeListing listing) {
        for (RecipeDescriptor descriptor : this.getEnvironment().listRecipeDescriptors()) {
            if (!descriptor.getName().equals(listing.getName())) continue;
            return descriptor.withBundle((RecipeBundle)this);
        }
        throw new IllegalArgumentException("Did not find a matching recipe descriptor in the recipe JAR " + this.gav);
    }

    public Environment getEnvironment() {
        if (this.environment == null) {
            ClassLoader scanningClassLoader = RecipeClassLoader.forScanning(this.recipeJar, this.classpath);
            this.environment = Environment.builder().load((ResourceLoader)new ClasspathScanningLoader(new Properties(), scanningClassLoader)).build();
        }
        return this.environment;
    }

    public Recipe prepare(RecipeListing listing, Map<String, Object> options) {
        return this.recipeLoader().load(listing.getName(), options);
    }

    private RecipeLoader recipeLoader() {
        if (this.recipeLoader == null) {
            this.recipeLoader = new RecipeLoader(this.classLoader());
        }
        return this.recipeLoader;
    }

    private ClassLoader classLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.classLoaderFactory.create(this.recipeJar, this.classpath);
        }
        return this.classLoader;
    }

    @Generated
    public ResolvedMavenRecipeBundle(ResolvedGroupArtifactVersion gav, Path recipeJar, List<Path> classpath, RecipeClassLoaderFactory classLoaderFactory, @Nullable String team) {
        this.gav = gav;
        this.recipeJar = recipeJar;
        this.classpath = classpath;
        this.classLoaderFactory = classLoaderFactory;
        this.team = team;
    }

    @Generated
    public @Nullable String getTeam() {
        return this.team;
    }
}

