/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.internal.InsertDependencyComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class AddManagedDependencyVisitor
extends MavenIsoVisitor<ExecutionContext> {
    private static final XPathMatcher MANAGED_DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencyManagement/dependencies");
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final @Nullable String scope;
    private final @Nullable String type;
    private final @Nullable String classifier;
    private final @Nullable String because;

    @Override
    public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
        Xml.Document doc = super.visitDocument(document, ctx);
        if (this.documentHasManagedDependency(doc, ctx)) {
            return document;
        }
        Xml.Tag root = document.getRoot();
        List rootContent = root.getContent() != null ? root.getContent() : Collections.emptyList();
        Xml.Tag dependencyManagementTag = root.getChild("dependencyManagement").orElse(null);
        if (dependencyManagementTag == null) {
            doc = (Xml.Document)new AddToTagVisitor(root, Xml.Tag.build((String)"<dependencyManagement>\n<dependencies/>\n</dependencyManagement>"), (Comparator)new MavenTagInsertionComparator(rootContent)).visitNonNull((Tree)doc, (Object)ctx);
        } else if (!dependencyManagementTag.getChild("dependencies").isPresent()) {
            doc = (Xml.Document)new AddToTagVisitor(dependencyManagementTag, Xml.Tag.build((String)"\n<dependencies/>\n"), (Comparator)new MavenTagInsertionComparator(rootContent)).visitNonNull((Tree)doc, (Object)ctx);
        }
        return (Xml.Document)new InsertDependencyInOrder(this.groupId, this.artifactId, this.version, this.type, this.scope, this.classifier, this.because).visitNonNull((Tree)doc, ctx);
    }

    private boolean documentHasManagedDependency(Xml.Document doc, ExecutionContext ctx) {
        final AtomicBoolean managedDepExists = new AtomicBoolean(false);
        new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                Xml.Tag tg = super.visitTag(tag, executionContext);
                if (this.isManagedDependencyTag(AddManagedDependencyVisitor.this.groupId, AddManagedDependencyVisitor.this.artifactId)) {
                    managedDepExists.set(true);
                }
                return tg;
            }
        }.visitNonNull((Tree)doc, ctx);
        return managedDepExists.get();
    }

    private static boolean matchesDependency(Xml.Tag dependencyTag, String groupId, String artifactId) {
        return "dependency".equals(dependencyTag.getName()) && groupId.equals(dependencyTag.getChildValue("groupId").orElse(null)) && artifactId.equals(dependencyTag.getChildValue("artifactId").orElse(null));
    }

    @Generated
    public AddManagedDependencyVisitor(String groupId, String artifactId, String version, @Nullable String scope, @Nullable String type, @Nullable String classifier, @Nullable String because) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.scope = scope;
        this.type = type;
        this.classifier = classifier;
        this.because = because;
    }

    private static class InsertDependencyInOrder
    extends MavenIsoVisitor<ExecutionContext> {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final @Nullable String type;
        private final @Nullable String scope;
        private final @Nullable String classifier;
        private final @Nullable String because;

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (MANAGED_DEPENDENCIES_MATCHER.matches(this.getCursor())) {
                for (Xml.Tag dependency : tag.getChildren()) {
                    if (!AddManagedDependencyVisitor.matchesDependency(dependency, this.groupId, this.artifactId)) continue;
                    return tag;
                }
                Xml.Tag dependencyTag = Xml.Tag.build((String)("\n<dependency>\n<groupId>" + this.groupId + "</groupId>\n<artifactId>" + this.artifactId + "</artifactId>\n<version>" + this.version + "</version>\n" + (this.classifier == null ? "" : "<classifier>" + this.classifier + "</classifier>\n") + (this.type == null || "jar".equals(this.type) ? "" : "<type>" + this.type + "</type>\n") + (this.scope == null || "compile".equals(this.scope) ? "" : "<scope>" + this.scope + "</scope>\n") + "</dependency>"));
                this.doAfterVisit((TreeVisitor)new AddDependencyWithCommentVisitor(tag, dependencyTag, this.because, new InsertDependencyComparator(tag.getContent() == null ? Collections.emptyList() : tag.getContent(), dependencyTag)));
            }
            return super.visitTag(tag, ctx);
        }

        @Generated
        public InsertDependencyInOrder(String groupId, String artifactId, String version, @Nullable String type, @Nullable String scope, @Nullable String classifier, @Nullable String because) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.type = type;
            this.scope = scope;
            this.classifier = classifier;
            this.because = because;
        }
    }

    private static class AddDependencyWithCommentVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private final Xml.Tag scope;
        private final Xml.Tag dependencyTag;
        private final @Nullable String because;
        private final Comparator<Content> tagComparator;

        @Override
        public Xml.Tag visitTag(Xml.Tag t, ExecutionContext ctx) {
            if (this.scope.isScope((Tree)t)) {
                t = this.ensureClosingTag(t, ctx);
                Xml.Tag formattedDependencyTag = this.formatDependencyTag(ctx);
                ArrayList<Content> content = t.getContent() == null ? new ArrayList<Content>() : new ArrayList(t.getContent());
                int insertIndex = this.findInsertIndex(content);
                if (this.because != null) {
                    this.addComment(content, insertIndex, this.because, formattedDependencyTag.getPrefix());
                    this.addDependency(content, insertIndex + 1, formattedDependencyTag);
                } else {
                    this.addDependency(content, insertIndex, formattedDependencyTag);
                }
                t = t.withContent(content);
            }
            return super.visitTag(t, ctx);
        }

        private Xml.Tag ensureClosingTag(Xml.Tag t, ExecutionContext ctx) {
            if (t.getClosing() == null) {
                t = t.withClosing((Xml.Tag.Closing)this.autoFormat((Xml)new Xml.Tag.Closing(Tree.randomId(), "\n", Markers.EMPTY, t.getName(), ""), null, ctx, this.getCursor())).withBeforeTagDelimiterPrefix("");
            }
            if (!t.getClosing().getPrefix().contains("\n")) {
                t = t.withClosing(t.getClosing().withPrefix("\n"));
            }
            return t;
        }

        private Xml.Tag formatDependencyTag(ExecutionContext ctx) {
            Xml.Tag formatted = this.dependencyTag;
            if (!formatted.getPrefix().contains("\n")) {
                formatted = formatted.withPrefix("\n");
            }
            return (Xml.Tag)this.autoFormat((Xml)formatted, null, ctx, this.getCursor());
        }

        private int findInsertIndex(List<Content> content) {
            for (int i = 0; i < content.size(); ++i) {
                Content item = content.get(i);
                if (!(item instanceof Xml.Tag) || this.tagComparator.compare(item, (Content)this.dependencyTag) <= 0) continue;
                return this.findInsertPositionBeforePrecedingComments(content, i);
            }
            return content.size();
        }

        private void addComment(List<Content> content, int insertIndex, String because, String prefix) {
            Xml.Comment comment = new Xml.Comment(Tree.randomId(), prefix, Markers.EMPTY, " " + because + " ");
            content.add(insertIndex, (Content)comment);
        }

        private void addDependency(List<Content> content, int insertIndex, Xml.Tag dependencyTag) {
            content.add(insertIndex, (Content)dependencyTag);
        }

        private int findInsertPositionBeforePrecedingComments(List<Content> content, int tagIndex) {
            int insertPos;
            for (insertPos = tagIndex; insertPos > 0 && content.get(insertPos - 1) instanceof Xml.Comment; --insertPos) {
            }
            return insertPos;
        }

        @Generated
        public AddDependencyWithCommentVisitor(Xml.Tag scope, Xml.Tag dependencyTag, @Nullable String because, Comparator<Content> tagComparator) {
            this.scope = scope;
            this.dependencyTag = dependencyTag;
            this.because = because;
            this.tagComparator = tagComparator;
        }
    }
}

