/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.marker.AlreadyIncremented;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.xml.ChangeTagValue;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class IncrementProjectVersion
extends ScanningRecipe<Map<GroupArtifact, String>> {
    @Option(displayName="GroupId", description="The groupId of the maven project to change its version. This can be a glob expression.", example="org.openrewrite")
    private final String groupId;
    @Option(displayName="ArtifactId", description="The artifactId of the maven project to change its version. This can be a glob expression.", example="*")
    private final String artifactId;
    @Option(displayName="Semver Digit", description="`MAJOR` increments the first digit, `MINOR` increments the second digit, and `PATCH` increments the third digit.", example="PATCH")
    private final SemverDigit digit;

    public String getDisplayName() {
        return "Increment Maven Project Version";
    }

    public String getDescription() {
        return "Increase Maven project version by incrementing either the major, minor, or patch version as defined by [semver](https://semver.org/). Other versioning schemes are not supported.";
    }

    public Map<GroupArtifact, String> getInitialValue(ExecutionContext ctx) {
        return new HashMap<GroupArtifact, String>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Map<GroupArtifact, String> acc) {
        final XPathMatcher PROJECT_MATCHER = new XPathMatcher("/project");
        final Pattern SEMVER_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.?(\\d+)?(-.+)?$");
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, ctx);
                if (!PROJECT_MATCHER.matches(this.getCursor())) {
                    return t;
                }
                ResolvedPom resolvedPom = this.getResolutionResult().getPom();
                if (!StringUtils.matchesGlob((String)resolvedPom.getValue(t.getChildValue("groupId").orElse(null)), (String)IncrementProjectVersion.this.groupId) || !StringUtils.matchesGlob((String)resolvedPom.getValue(t.getChildValue("artifactId").orElse(null)), (String)IncrementProjectVersion.this.artifactId)) {
                    return t;
                }
                Optional versionTag = t.getChild("version");
                if (!versionTag.isPresent() || !((Xml.Tag)versionTag.get()).getValue().isPresent()) {
                    return t;
                }
                String versionTagValue = (String)((Xml.Tag)versionTag.get()).getValue().get();
                String oldVersion = resolvedPom.getValue(versionTagValue);
                if (oldVersion == null) {
                    return t;
                }
                String newVersion = this.incrementSemverDigit(oldVersion);
                if (newVersion.equals(oldVersion)) {
                    return t;
                }
                acc.put(new GroupArtifact(t.getChildValue("groupId").orElse(null), t.getChildValue("artifactId").orElse(null)), newVersion);
                return t;
            }

            private String incrementSemverDigit(String oldVersion) {
                Matcher m = SEMVER_PATTERN.matcher(oldVersion);
                if (!m.matches()) {
                    return oldVersion;
                }
                String major = m.group(1);
                String minor = m.group(2);
                String patch = m.group(3);
                String fourth = m.group(4);
                String extra = m.group(5);
                switch (IncrementProjectVersion.this.digit) {
                    case MAJOR: {
                        major = String.valueOf(Integer.parseInt(major) + 1);
                        minor = "0";
                        patch = "0";
                        break;
                    }
                    case MINOR: {
                        minor = String.valueOf(Integer.parseInt(minor) + 1);
                        patch = "0";
                        break;
                    }
                    case PATCH: {
                        patch = String.valueOf(Integer.parseInt(patch) + 1);
                    }
                }
                fourth = fourth == null ? "" : ".0";
                if (extra == null) {
                    extra = "";
                }
                return major + "." + minor + "." + patch + fourth + extra;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Map<GroupArtifact, String> acc) {
        return new MavenIsoVisitor<ExecutionContext>(){
            final XPathMatcher PARENT_MATCHER = new XPathMatcher("/project/parent");
            final XPathMatcher PROJECT_MATCHER = new XPathMatcher("/project");

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, ctx);
                if (!this.PROJECT_MATCHER.matches(this.getCursor()) && !this.PARENT_MATCHER.matches(this.getCursor()) || t.getMarkers().findFirst(AlreadyIncremented.class).isPresent()) {
                    return t;
                }
                String newVersion = (String)acc.get(new GroupArtifact(t.getChildValue("groupId").orElse(null), t.getChildValue("artifactId").orElse(null)));
                if (newVersion == null || newVersion.equals(t.getChildValue("version").orElse(null))) {
                    return t;
                }
                t = t.withMarkers(t.getMarkers().add((Marker)new AlreadyIncremented(Tree.randomId())));
                return (Xml.Tag)new ChangeTagValue("version", null, newVersion).getVisitor().visitNonNull((Tree)t, (Object)ctx);
            }
        };
    }

    public IncrementProjectVersion(String groupId, String artifactId, SemverDigit digit) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.digit = digit;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public SemverDigit getDigit() {
        return this.digit;
    }

    @NonNull
    public String toString() {
        return "IncrementProjectVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", digit=" + (Object)((Object)this.getDigit()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IncrementProjectVersion)) {
            return false;
        }
        IncrementProjectVersion other = (IncrementProjectVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        SemverDigit this$digit = this.getDigit();
        SemverDigit other$digit = other.getDigit();
        return !(this$digit == null ? other$digit != null : !((Object)((Object)this$digit)).equals((Object)other$digit));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof IncrementProjectVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        SemverDigit $digit = this.getDigit();
        result = result * 59 + ($digit == null ? 43 : ((Object)((Object)$digit)).hashCode());
        return result;
    }

    public static enum SemverDigit {
        MAJOR,
        MINOR,
        PATCH;

    }
}

