/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties.tree;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.internal.PropertiesPrinter;

public interface Properties
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptProperties((PropertiesVisitor)v.adapt(PropertiesVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(PropertiesVisitor.class);
    }

    @Nullable
    default public <P> Properties acceptProperties(PropertiesVisitor<P> v, P p) {
        return (Properties)v.defaultValue(this, p);
    }

    public String getPrefix();

    public Properties withPrefix(String var1);

    public static final class Comment
    implements Content {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final Delimiter delimiter;
        private final String message;

        @Override
        public <P> Properties acceptProperties(PropertiesVisitor<P> v, P p) {
            return v.visitComment(this, p);
        }

        public Comment(UUID id, String prefix, Markers markers, Delimiter delimiter, String message) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.delimiter = delimiter;
            this.message = message;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Delimiter getDelimiter() {
            return this.delimiter;
        }

        public String getMessage() {
            return this.message;
        }

        @NonNull
        public String toString() {
            return "Properties.Comment(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", delimiter=" + (Object)((Object)this.getDelimiter()) + ", message=" + this.getMessage() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Comment)) {
                return false;
            }
            Comment other = (Comment)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Comment withId(UUID id) {
            return this.id == id ? this : new Comment(id, this.prefix, this.markers, this.delimiter, this.message);
        }

        @Override
        @NonNull
        public Comment withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Comment(this.id, prefix, this.markers, this.delimiter, this.message);
        }

        @NonNull
        public Comment withMarkers(Markers markers) {
            return this.markers == markers ? this : new Comment(this.id, this.prefix, markers, this.delimiter, this.message);
        }

        @NonNull
        public Comment withDelimiter(Delimiter delimiter) {
            return this.delimiter == delimiter ? this : new Comment(this.id, this.prefix, this.markers, delimiter, this.message);
        }

        @NonNull
        public Comment withMessage(String message) {
            return this.message == message ? this : new Comment(this.id, this.prefix, this.markers, this.delimiter, message);
        }

        public static enum Delimiter {
            HASH_TAG(Character.valueOf('#')),
            EXCLAMATION_MARK(Character.valueOf('!'));

            private final Character character;

            private Delimiter(Character character) {
                this.character = character;
            }

            public Character getCharacter() {
                return this.character;
            }
        }
    }

    public static final class Value {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final String text;

        public Value(UUID id, String prefix, Markers markers, String text) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.text = text;
        }

        public UUID getId() {
            return this.id;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getText() {
            return this.text;
        }

        @NonNull
        public String toString() {
            return "Properties.Value(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value other = (Value)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Value withId(UUID id) {
            return this.id == id ? this : new Value(id, this.prefix, this.markers, this.text);
        }

        @NonNull
        public Value withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Value(this.id, prefix, this.markers, this.text);
        }

        @NonNull
        public Value withMarkers(Markers markers) {
            return this.markers == markers ? this : new Value(this.id, this.prefix, markers, this.text);
        }

        @NonNull
        public Value withText(String text) {
            return this.text == text ? this : new Value(this.id, this.prefix, this.markers, text);
        }
    }

    public static final class Entry
    implements Content {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final String key;
        private final String beforeEquals;
        @Nullable
        private final Delimiter delimiter;
        private final Value value;

        public Delimiter getDelimiter() {
            return this.delimiter == null ? Delimiter.EQUALS : this.delimiter;
        }

        @Override
        public <P> Properties acceptProperties(PropertiesVisitor<P> v, P p) {
            return v.visitEntry(this, p);
        }

        public Entry(UUID id, String prefix, Markers markers, String key, String beforeEquals, @Nullable Delimiter delimiter, Value value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.beforeEquals = beforeEquals;
            this.delimiter = delimiter;
            this.value = value;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getKey() {
            return this.key;
        }

        public String getBeforeEquals() {
            return this.beforeEquals;
        }

        public Value getValue() {
            return this.value;
        }

        @NonNull
        public String toString() {
            return "Properties.Entry(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", key=" + this.getKey() + ", beforeEquals=" + this.getBeforeEquals() + ", delimiter=" + (Object)((Object)this.getDelimiter()) + ", value=" + this.getValue() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Entry withId(UUID id) {
            return this.id == id ? this : new Entry(id, this.prefix, this.markers, this.key, this.beforeEquals, this.delimiter, this.value);
        }

        @Override
        @NonNull
        public Entry withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Entry(this.id, prefix, this.markers, this.key, this.beforeEquals, this.delimiter, this.value);
        }

        @NonNull
        public Entry withMarkers(Markers markers) {
            return this.markers == markers ? this : new Entry(this.id, this.prefix, markers, this.key, this.beforeEquals, this.delimiter, this.value);
        }

        @NonNull
        public Entry withKey(String key) {
            return this.key == key ? this : new Entry(this.id, this.prefix, this.markers, key, this.beforeEquals, this.delimiter, this.value);
        }

        @NonNull
        public Entry withBeforeEquals(String beforeEquals) {
            return this.beforeEquals == beforeEquals ? this : new Entry(this.id, this.prefix, this.markers, this.key, beforeEquals, this.delimiter, this.value);
        }

        @NonNull
        public Entry withDelimiter(@Nullable Delimiter delimiter) {
            return this.delimiter == delimiter ? this : new Entry(this.id, this.prefix, this.markers, this.key, this.beforeEquals, delimiter, this.value);
        }

        @NonNull
        public Entry withValue(Value value) {
            return this.value == value ? this : new Entry(this.id, this.prefix, this.markers, this.key, this.beforeEquals, this.delimiter, value);
        }

        public static enum Delimiter {
            COLON(Character.valueOf(':')),
            EQUALS(Character.valueOf('=')),
            NONE(Character.valueOf('\u0000'));

            private final Character character;

            private Delimiter(Character character) {
                this.character = character;
            }

            public static Delimiter getDelimiter(String value) {
                return "=".equals(value.trim()) ? EQUALS : (":".equals(value.trim()) ? COLON : ("".equals(value.trim()) ? NONE : EQUALS));
            }

            public Character getCharacter() {
                return this.character;
            }
        }
    }

    public static interface Content
    extends Properties {
    }

    public static final class File
    implements Properties,
    SourceFile {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final Path sourcePath;
        private final List<Content> content;
        private final String eof;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final FileAttributes fileAttributes;
        @Nullable
        private final Checksum checksum;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        public List<Content> getContent() {
            return Collections.unmodifiableList(this.content);
        }

        public File withContent(List<Content> content) {
            int size = content.size();
            if (size == this.content.size()) {
                boolean allIdentical = true;
                for (int i = 0; i < size; ++i) {
                    if (content.get(i) == this.content.get(i)) continue;
                    allIdentical = false;
                    break;
                }
                if (allIdentical) {
                    return this;
                }
            }
            return new File(this.id, this.prefix, this.markers, this.sourcePath, new ArrayList<Content>(content), this.eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum);
        }

        @Override
        public <P> Properties acceptProperties(PropertiesVisitor<P> v, P p) {
            return v.visitFile(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new PropertiesPrinter();
        }

        public File(UUID id, String prefix, Markers markers, Path sourcePath, List<Content> content, String eof, @Nullable String charsetName, boolean charsetBomMarked, @Nullable FileAttributes fileAttributes, @Nullable Checksum checksum) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.content = content;
            this.eof = eof;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.fileAttributes = fileAttributes;
            this.checksum = checksum;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public String getEof() {
            return this.eof;
        }

        @Nullable
        public String getCharsetName() {
            return this.charsetName;
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @Nullable
        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Nullable
        public Checksum getChecksum() {
            return this.checksum;
        }

        @NonNull
        public String toString() {
            return "Properties.File(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", content=" + this.getContent() + ", eof=" + this.getEof() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", fileAttributes=" + this.getFileAttributes() + ", checksum=" + this.getChecksum() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof File)) {
                return false;
            }
            File other = (File)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public File withId(UUID id) {
            return this.id == id ? this : new File(id, this.prefix, this.markers, this.sourcePath, this.content, this.eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum);
        }

        @Override
        @NonNull
        public File withPrefix(String prefix) {
            return this.prefix == prefix ? this : new File(this.id, prefix, this.markers, this.sourcePath, this.content, this.eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum);
        }

        @NonNull
        public File withMarkers(Markers markers) {
            return this.markers == markers ? this : new File(this.id, this.prefix, markers, this.sourcePath, this.content, this.eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum);
        }

        @NonNull
        public File withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new File(this.id, this.prefix, this.markers, sourcePath, this.content, this.eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum);
        }

        @NonNull
        public File withEof(String eof) {
            return this.eof == eof ? this : new File(this.id, this.prefix, this.markers, this.sourcePath, this.content, eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum);
        }

        @NonNull
        private File withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new File(this.id, this.prefix, this.markers, this.sourcePath, this.content, this.eof, charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum);
        }

        @NonNull
        public File withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new File(this.id, this.prefix, this.markers, this.sourcePath, this.content, this.eof, this.charsetName, charsetBomMarked, this.fileAttributes, this.checksum);
        }

        @NonNull
        public File withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new File(this.id, this.prefix, this.markers, this.sourcePath, this.content, this.eof, this.charsetName, this.charsetBomMarked, fileAttributes, this.checksum);
        }

        @NonNull
        public File withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new File(this.id, this.prefix, this.markers, this.sourcePath, this.content, this.eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, checksum);
        }
    }
}

