/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.python.internal.PsiPythonMapper;
import org.openrewrite.python.tree.Py;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class PythonParser
implements Parser<Py.CompilationUnit> {
    private final List<NamedStyles> styles;
    private final boolean logCompilationWarningsAndErrors;
    private final JavaTypeCache typeCache;

    public List<Py.CompilationUnit> parse(String ... sources) {
        ArrayList<Parser.Input> inputs = new ArrayList<Parser.Input>(sources.length);
        int i = 0;
        while (i < sources.length) {
            Path path = Paths.get("p" + i + ".py", new String[0]);
            int j = i++;
            inputs.add(new Parser.Input(path, null, () -> new ByteArrayInputStream(sources[j].getBytes(StandardCharsets.UTF_8)), true));
        }
        return this.parseInputs(inputs, null, (ExecutionContext)new InMemoryExecutionContext());
    }

    public List<Py.CompilationUnit> parseInputs(Iterable<Parser.Input> inputs, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        ParsingEventListener parsingListener = pctx.getParsingListener();
        return this.acceptedInputs(inputs).stream().map(sourceFile -> {
            Py.CompilationUnit compilationUnit;
            block8: {
                Timer.Builder timer = Timer.builder((String)"rewrite.parse").description("The time spent parsing an Python file").tag("file.type", "Python");
                Timer.Sample sample = Timer.start();
                Path path = sourceFile.getRelativePath(relativeTo);
                EncodingDetectingInputStream is = sourceFile.getSource(ctx);
                try {
                    Py.CompilationUnit py = new PsiPythonMapper().mapSource(is.readFully(), path, is.getCharset().toString(), is.isCharsetBomMarked());
                    sample.stop(MetricsHelper.successTags((Timer.Builder)timer).register((MeterRegistry)Metrics.globalRegistry));
                    parsingListener.parsed(sourceFile, (SourceFile)py);
                    compilationUnit = py;
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        sample.stop(MetricsHelper.errorTags((Timer.Builder)timer, (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                        pctx.parseFailure(sourceFile, relativeTo, (Parser)this, t);
                        ctx.getOnError().accept(t);
                        return null;
                    }
                }
                is.close();
            }
            return compilationUnit;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".py");
    }

    public PythonParser reset() {
        this.typeCache.clear();
        return this;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.py");
    }

    public static Builder builder() {
        return new Builder();
    }

    private PythonParser(List<NamedStyles> styles, boolean logCompilationWarningsAndErrors, JavaTypeCache typeCache) {
        this.styles = styles;
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
        this.typeCache = typeCache;
    }

    public static class Builder
    extends Parser.Builder {
        private JavaTypeCache typeCache = new JavaTypeCache();
        private boolean logCompilationWarningsAndErrors;
        private final List<NamedStyles> styles = new ArrayList<NamedStyles>();

        public Builder() {
            super(Py.CompilationUnit.class);
        }

        public Builder logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return this;
        }

        public Builder typeCache(JavaTypeCache typeCache) {
            this.typeCache = typeCache;
            return this;
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public PythonParser build() {
            return new PythonParser(this.styles, this.logCompilationWarningsAndErrors, this.typeCache);
        }

        public String getDslName() {
            return "python";
        }
    }
}

