/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.internal;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyFile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.python.internal.IntelliJUtils;

public class CollectIntelliJDependencies {
    private final ExecutionContext executionContext = new InMemoryExecutionContext();
    private static final List<String> ERROR_BLACKLIST = Arrays.asList("Not a stub type", "Missing extension point: Pythonid.knownDecoratorProvider", "ResolveScopeManager.getInstance must not return null", "ProjectFileIndex.getInstance must not return null", "ProjectFileIndex.getInstance must not return null", "Cannot invoke \"com.jetbrains.python.psi.PyElementGenerator.createExpressionFromText(com.jetbrains.python.psi.LanguageLevel, String)\" because \"elementGenerator\" is null", "the return value of \"com.intellij.openapi.project.Project.getService(java.lang.Class)\" is null");
    private final Set<Method> blacklistedMethods = new HashSet<Method>();

    public static void main(String[] args) {
        new CollectIntelliJDependencies().processDirectory(new File("example-data"));
    }

    private void processDirectory(File dir) {
        for (File child : dir.listFiles()) {
            if (child.isDirectory()) {
                this.processDirectory(child);
                continue;
            }
            this.processFile(child);
        }
    }

    private void processFile(File file) {
        byte[] data;
        if (!file.getName().endsWith(".py")) {
            return;
        }
        try {
            data = Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PyFile parsed = IntelliJUtils.parsePythonSource(file.getPath(), new String(data));
        this.processNode(parsed);
    }

    private void processNode(PsiElement element) {
        for (Method method : element.getClass().getMethods()) {
            this.runNodeMethod(element, method);
        }
        for (PsiElement child : element.getChildren()) {
            this.processNode(child);
        }
    }

    private void runNodeMethod(PsiElement element, Method method) {
        if (this.blacklistedMethods.contains(method)) {
            return;
        }
        if (!method.getName().startsWith("get") || method.getParameterCount() != 0) {
            return;
        }
        try {
            method.invoke((Object)element, new Object[0]);
        }
        catch (InvocationTargetException original) {
            boolean hadMessage = false;
            for (Throwable e = original.getTargetException(); e != null; e = e.getCause()) {
                String message = e.getMessage();
                if (message == null) continue;
                hadMessage = true;
                for (String pattern : ERROR_BLACKLIST) {
                    if (!message.contains(pattern)) continue;
                    System.err.println("BLACKLISTING METHOD:\n\t" + method.getDeclaringClass().getSimpleName() + "." + method.getName() + "\n\t" + e + "\n");
                    this.blacklistedMethods.add(method);
                    return;
                }
            }
            if (hadMessage) {
                original.getTargetException().printStackTrace();
            } else {
                System.err.println("METHOD " + method + " FAILED WITHOUT CONTEXT DUE TO: " + original.getTargetException());
                original.getTargetException().printStackTrace();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

