/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.model.ModelBranchUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyStubPackages;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyCanonicalPathProvider;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PythonModulePathCache;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QualifiedNameFinder {
    @Nullable
    public static String findShortestImportableName(@NotNull PsiElement foothold, @NotNull VirtualFile vfile) {
        QualifiedName qName;
        if (foothold == null) {
            QualifiedNameFinder.$$$reportNull$$$0(0);
        }
        if (vfile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(1);
        }
        return (qName = QualifiedNameFinder.findShortestImportableQName(foothold, vfile)) == null ? null : qName.toString();
    }

    @Nullable
    public static QualifiedName findShortestImportableQName(@Nullable PsiFileSystemItem fsItem) {
        VirtualFile vFile = fsItem != null ? fsItem.getVirtualFile() : null;
        return vFile != null ? QualifiedNameFinder.findShortestImportableQName(fsItem, vFile) : null;
    }

    @Nullable
    public static QualifiedName findShortestImportableQName(@NotNull PsiElement foothold, @NotNull VirtualFile vfile) {
        if (foothold == null) {
            QualifiedNameFinder.$$$reportNull$$$0(2);
        }
        if (vfile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(3);
        }
        return QualifiedNameFinder.shortestQName(QualifiedNameFinder.findImportableQNames(foothold, vfile));
    }

    @NotNull
    public static List<QualifiedName> findImportableQNames(@NotNull PsiElement foothold, @NotNull VirtualFile vfile) {
        PythonPathCache cache;
        List names;
        if (foothold == null) {
            QualifiedNameFinder.$$$reportNull$$$0(4);
        }
        if (vfile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(5);
        }
        List list = names = (cache = ResolveImportUtil.getPathCache((PsiElement)foothold)) != null ? cache.getNames(vfile) : null;
        if (names != null) {
            List list2 = names;
            if (list2 == null) {
                QualifiedNameFinder.$$$reportNull$$$0(6);
            }
            return list2;
        }
        PathChoosingVisitor visitor = new PathChoosingVisitor(vfile);
        RootVisitorHost.visitRoots((PsiElement)foothold, (RootVisitor)visitor);
        List results = visitor.getResults();
        if (cache != null) {
            cache.putNames(vfile, results);
        }
        List list3 = results;
        if (list3 == null) {
            QualifiedNameFinder.$$$reportNull$$$0(7);
        }
        return list3;
    }

    @Nullable
    private static QualifiedName shortestQName(@NotNull List<QualifiedName> qNames) {
        if (qNames == null) {
            QualifiedNameFinder.$$$reportNull$$$0(8);
        }
        return qNames.stream().min(Comparator.comparingInt(QualifiedName::getComponentCount)).orElse(null);
    }

    @Nullable
    public static String findShortestImportableName(Module module, @NotNull VirtualFile vfile) {
        PythonPathCache cache;
        List names;
        if (vfile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(9);
        }
        if ((names = (cache = PythonModulePathCache.getInstance((Module)module)).getNames(vfile)) == null) {
            PathChoosingVisitor visitor = new PathChoosingVisitor(vfile);
            RootVisitorHost.visitRoots((Module)module, (boolean)false, (RootVisitor)visitor);
            names = visitor.getResults();
            cache.putNames(vfile, names);
        }
        return Objects.toString(QualifiedNameFinder.shortestQName(names), null);
    }

    @Nullable
    public static QualifiedName findCanonicalImportPath(@NotNull PsiElement symbol, @Nullable PsiElement foothold) {
        if (symbol == null) {
            QualifiedNameFinder.$$$reportNull$$$0(10);
        }
        return PyUtil.getNullableParameterizedCachedValue(symbol, Couple.of((Object)symbol, (Object)foothold), QualifiedNameFinder::doFindCanonicalImportPath);
    }

    @Nullable
    private static QualifiedName doFindCanonicalImportPath(@NotNull Couple<PsiElement> param) {
        QualifiedName restored;
        QualifiedName qname;
        if (param == null) {
            QualifiedNameFinder.$$$reportNull$$$0(11);
        }
        PsiElement symbol = (PsiElement)param.getFirst();
        PsiElement foothold = (PsiElement)param.getSecond();
        PsiFileSystemItem srcfile = PyPsiUtils.getFileSystemItem(symbol);
        if (srcfile == null) {
            return null;
        }
        VirtualFile virtualFile = srcfile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (srcfile instanceof PsiFile && symbol instanceof PsiNamedElement && !(symbol instanceof PsiFileSystemItem)) {
            PyFile initPy;
            PyClass containingClass;
            PsiElement toplevel = symbol;
            if (symbol instanceof PyFunction && (containingClass = ((PyFunction)symbol).getContainingClass()) != null) {
                toplevel = containingClass;
            }
            for (PsiDirectory dir = ((PsiFile)srcfile).getContainingDirectory(); dir != null && (initPy = PyUtil.as(PyUtil.turnDirIntoInit(dir), PyFile.class)) != null; dir = dir.getParentDirectory()) {
                if (initPy.getImportTargets().isEmpty() && initPy.getFromImports().isEmpty()) {
                    initPy = QualifiedNameFinder.jumpFromBinarySkeletonsToRealInitPy(initPy);
                }
                List<RatedResolveResult> resolved = initPy.multiResolveName(((PsiNamedElement)toplevel).getName());
                PsiElement finalTopLevel = toplevel;
                if (!resolved.stream().anyMatch(r -> r.getElement() == finalTopLevel)) continue;
                virtualFile = dir.getVirtualFile();
            }
        }
        if ((qname = QualifiedNameFinder.findShortestImportableQName(foothold != null ? foothold : symbol, virtualFile)) != null && (restored = QualifiedNameFinder.canonizeQualifiedName(symbol, qname, foothold)) != null) {
            return restored;
        }
        return qname;
    }

    @NotNull
    private static PyFile jumpFromBinarySkeletonsToRealInitPy(@NotNull PyFile initPy) {
        PyFile libInitPy;
        List namesakeResults;
        PsiElement nonSkeletonResult;
        PsiDirectory libPackage;
        QualifiedName packageName;
        if (initPy == null) {
            QualifiedNameFinder.$$$reportNull$$$0(12);
        }
        if (PythonSdkUtil.isElementInSkeletons((PsiElement)initPy) && (packageName = QualifiedNameFinder.findShortestImportableQName(initPy)) != null && (libPackage = PyUtil.as(nonSkeletonResult = (PsiElement)((Object)ContainerUtil.find(namesakeResults = PyResolveImportUtil.resolveQualifiedName((QualifiedName)packageName, (PyQualifiedNameResolveContext)PyResolveImportUtil.fromFoothold((PsiElement)initPy)), e -> !PythonSdkUtil.isElementInSkeletons((PsiElement)e))), PsiDirectory.class)) != null && (libInitPy = PyUtil.as(PyUtil.turnDirIntoInit(libPackage), PyFile.class)) != null && libInitPy != initPy) {
            PyFile pyFile = libInitPy;
            if (pyFile == null) {
                QualifiedNameFinder.$$$reportNull$$$0(13);
            }
            return pyFile;
        }
        PyFile pyFile = initPy;
        if (pyFile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(14);
        }
        return pyFile;
    }

    @Nullable
    public static QualifiedName canonizeQualifiedName(PsiElement symbol, QualifiedName qname, PsiElement foothold) {
        for (PyCanonicalPathProvider provider : PyCanonicalPathProvider.EP_NAME.getExtensionList()) {
            QualifiedName restored = provider.getCanonicalPath(symbol, qname, foothold);
            if (restored == null) continue;
            return restored;
        }
        return null;
    }

    @Nullable
    public static String getQualifiedName(@NotNull PyElement element) {
        if (element == null) {
            QualifiedNameFinder.$$$reportNull$$$0(15);
        }
        return (String)CachedValuesManager.getCachedValue(element, () -> new CachedValueProvider.Result<String>(QualifiedNameFinder.getQualifiedNameInner(element), PsiModificationTracker.MODIFICATION_COUNT));
    }

    @Nullable
    private static String getQualifiedNameInner(@NotNull PyElement element) {
        String name;
        if (element == null) {
            QualifiedNameFinder.$$$reportNull$$$0(16);
        }
        if ((name = element.getName()) != null) {
            ScopeOwner owner = ScopeUtil.getScopeOwner(element);
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(element);
            if (owner instanceof PyClass) {
                String classQName = ((PyClass)owner).getQualifiedName();
                if (classQName != null) {
                    return classQName + "." + name;
                }
            } else if (owner instanceof PyFile) {
                String fileQName;
                if (builtinCache.isBuiltin(element)) {
                    return name;
                }
                VirtualFile virtualFile = ((PyFile)owner).getVirtualFile();
                if (virtualFile != null && (fileQName = QualifiedNameFinder.findShortestImportableName(element, virtualFile)) != null) {
                    return fileQName + "." + name;
                }
            }
        }
        return null;
    }

    @Nullable
    private static QualifiedName computeQualifiedNameInRoot(@NotNull VirtualFile root, @NotNull VirtualFile file) {
        VirtualFile effectiveRoot;
        String relativePath;
        if (root == null) {
            QualifiedNameFinder.$$$reportNull$$$0(17);
        }
        if (file == null) {
            QualifiedNameFinder.$$$reportNull$$$0(18);
        }
        if (StringUtil.isEmpty(relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)(effectiveRoot = ModelBranchUtil.obtainCopyFromTheSameBranch((VirtualFile)file, (VirtualFile)root)), (char)'/'))) {
            return null;
        }
        ArrayList<String> components = new ArrayList<String>(StringUtil.split(relativePath, "/"));
        if (components.isEmpty()) {
            return null;
        }
        int lastIndex = components.size() - 1;
        String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)components.get(lastIndex));
        if (!file.isDirectory() && nameWithoutExtension.equals("__init__")) {
            components.remove(lastIndex);
        } else {
            components.set(lastIndex, nameWithoutExtension);
        }
        if (components.isEmpty() || ContainerUtil.exists(components, part -> part.contains("."))) {
            return null;
        }
        return PyStubPackages.convertStubToRuntimePackageName((QualifiedName)QualifiedName.fromComponents(components));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfile";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/resolve/QualifiedNameFinder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qNames";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initPy";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/resolve/QualifiedNameFinder";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findImportableQNames";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpFromBinarySkeletonsToRealInitPy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findShortestImportableName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findShortestImportableQName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findImportableQNames";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shortestQName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findCanonicalImportPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doFindCanonicalImportPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "jumpFromBinarySkeletonsToRealInitPy";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameInner";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeQualifiedNameInRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 13, 14 -> new IllegalStateException(string);
        };
    }
}

