/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.processor;

import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.tools.Diagnostic;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.template.internal.JavacResolution;
import org.openrewrite.java.template.processor.RefasterTemplateProcessor;
import org.openrewrite.java.template.processor.TemplateDescriptor;

class RuleDescriptor {
    public final JCTree.JCClassDecl classDecl;
    public final List<TemplateDescriptor> beforeTemplates;
    public final @Nullable TemplateDescriptor afterTemplate;

    private RuleDescriptor(JCTree.JCClassDecl classDecl, List<TemplateDescriptor> beforeTemplates, @Nullable TemplateDescriptor afterTemplate) {
        this.classDecl = classDecl;
        this.beforeTemplates = beforeTemplates;
        this.afterTemplate = afterTemplate;
    }

    public static @Nullable RuleDescriptor create(JavacProcessingEnvironment processingEnv, JCTree.JCCompilationUnit cu, JCTree.JCClassDecl classDecl) {
        ArrayList<TemplateDescriptor> beforeTemplates = new ArrayList<TemplateDescriptor>();
        TemplateDescriptor afterTemplate = null;
        for (JCTree member : classDecl.getMembers()) {
            if (!(member instanceof JCTree.JCMethodDecl)) continue;
            JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)member;
            List<JCTree.JCAnnotation> annotations = RefasterTemplateProcessor.getMethodTreeAnnotations(method, "com.google.errorprone.refaster.annotation.BeforeTemplate"::equals);
            if (!annotations.isEmpty()) {
                beforeTemplates.add(new TemplateDescriptor(processingEnv, cu, classDecl, method));
            }
            if ((annotations = RefasterTemplateProcessor.getMethodTreeAnnotations(method, "com.google.errorprone.refaster.annotation.AfterTemplate"::equals)).isEmpty()) continue;
            afterTemplate = new TemplateDescriptor(processingEnv, cu, classDecl, method);
        }
        return new RuleDescriptor(classDecl, beforeTemplates, afterTemplate).validate(processingEnv, cu, classDecl);
    }

    private @Nullable RuleDescriptor validate(JavacProcessingEnvironment processingEnv, JCTree.JCCompilationUnit cu, JCTree.JCClassDecl classDecl) {
        if (this.beforeTemplates.isEmpty()) {
            return null;
        }
        for (JCTree member : classDecl.getMembers()) {
            Iterator<Object> iterator;
            if (!(member instanceof JCTree.JCMethodDecl) || !this.beforeTemplates.stream().noneMatch(t -> t.method == member)) continue;
            if (this.afterTemplate != null) {
                if (member == this.afterTemplate.method) continue;
            }
            if (!(iterator = RefasterTemplateProcessor.getMethodTreeAnnotations((JCTree.JCMethodDecl)member, RefasterTemplateProcessor.UNSUPPORTED_ANNOTATIONS::contains).iterator()).hasNext()) continue;
            JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)iterator.next();
            RefasterTemplateProcessor.printNoteOnce(processingEnv, "@" + annotation.annotationType + " is currently not supported", classDecl.sym);
            return null;
        }
        boolean valid = this.resolveAll(processingEnv, cu);
        if (!valid) {
            return null;
        }
        if (this.afterTemplate != null) {
            Set<Name> requiredParameters = RefasterTemplateProcessor.findParameterOrder(this.afterTemplate.method, 0).keySet();
            for (TemplateDescriptor beforeTemplate : this.beforeTemplates) {
                for (int i = 0; i < beforeTemplate.getArity(); ++i) {
                    Set<Name> providedParameters = RefasterTemplateProcessor.findParameterOrder(beforeTemplate.method, i).keySet();
                    if (providedParameters.containsAll(requiredParameters)) continue;
                    RefasterTemplateProcessor.printNoteOnce(processingEnv, "@AfterTemplate defines arguments that are not present in all @BeforeTemplate methods", classDecl.sym);
                    return null;
                }
            }
        }
        return this;
    }

    private boolean resolveAll(JavacProcessingEnvironment processingEnv, JCTree.JCCompilationUnit cu) {
        try {
            Context context = processingEnv.getContext();
            JavacResolution javacResolution = new JavacResolution(context);
            for (TemplateDescriptor beforeTemplate : this.beforeTemplates) {
                JCTree.JCMethodDecl resolvedMethod = (JCTree.JCMethodDecl)javacResolution.resolveAll(context, cu, Collections.singletonList(beforeTemplate.method)).get(beforeTemplate.method);
                resolvedMethod.params = beforeTemplate.method.params;
                beforeTemplate.method = resolvedMethod;
                if (beforeTemplate.validate()) continue;
                return false;
            }
            if (this.afterTemplate != null) {
                JCTree.JCMethodDecl resolvedMethod = (JCTree.JCMethodDecl)javacResolution.resolveAll(context, cu, Collections.singletonList(this.afterTemplate.method)).get(this.afterTemplate.method);
                resolvedMethod.params = this.afterTemplate.method.params;
                this.afterTemplate.method = resolvedMethod;
                if (!this.afterTemplate.validate()) {
                    return false;
                }
            }
        }
        catch (Throwable t) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Had trouble type attributing the template.");
            return false;
        }
        return true;
    }
}

