/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.trait;

import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.trait.Reference;
import org.openrewrite.trait.SimpleTraitMatcher;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.trait.XmlReference;
import org.openrewrite.xml.tree.Xml;

public final class SpringXmlReference
extends XmlReference {
    private final Cursor cursor;
    private final Reference.Kind kind;

    public Reference.Kind getKind() {
        return this.kind;
    }

    @Generated
    public SpringXmlReference(Cursor cursor, Reference.Kind kind) {
        this.cursor = cursor;
        this.kind = kind;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @NonNull
    @Generated
    public String toString() {
        return "SpringXmlReference(cursor=" + this.getCursor() + ", kind=" + this.getKind() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringXmlReference)) {
            return false;
        }
        SpringXmlReference other = (SpringXmlReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        Reference.Kind this$kind = this.getKind();
        Reference.Kind other$kind = other.getKind();
        return !(this$kind == null ? other$kind != null : !this$kind.equals(other$kind));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof SpringXmlReference;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        Reference.Kind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        return result;
    }

    public static class Provider
    extends Reference.AbstractProvider<SpringXmlReference> {
        private static final SimpleTraitMatcher<SpringXmlReference> matcher = new SimpleTraitMatcher<SpringXmlReference>(){
            private final Pattern referencePattern = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*");
            private final XPathMatcher classXPath = new XPathMatcher("//@class");
            private final XPathMatcher typeXPath = new XPathMatcher("//@type");
            private final XPathMatcher keyTypeXPath = new XPathMatcher("//@key-type");
            private final XPathMatcher valueTypeXPath = new XPathMatcher("//@value-type");
            private final XPathMatcher tags = new XPathMatcher("//value");

            protected @Nullable SpringXmlReference test(Cursor cursor) {
                Object value = cursor.getValue();
                if (value instanceof Xml.Attribute) {
                    String stringVal;
                    Xml.Attribute attrib = (Xml.Attribute)value;
                    if ((this.classXPath.matches(cursor) || this.typeXPath.matches(cursor) || this.keyTypeXPath.matches(cursor) || this.valueTypeXPath.matches(cursor)) && this.referencePattern.matcher(stringVal = attrib.getValueAsString()).matches()) {
                        return new SpringXmlReference(cursor, this.determineKind(stringVal));
                    }
                } else if (value instanceof Xml.Tag) {
                    Optional<String> stringVal;
                    Xml.Tag tag = (Xml.Tag)value;
                    if (this.tags.matches(cursor) && (stringVal = tag.getValue()).isPresent() && this.referencePattern.matcher(stringVal.get()).matches()) {
                        return new SpringXmlReference(cursor, this.determineKind(stringVal.get()));
                    }
                }
                return null;
            }

            Reference.Kind determineKind(String value) {
                return Character.isUpperCase(value.charAt(value.lastIndexOf(46) + 1)) ? Reference.Kind.TYPE : Reference.Kind.PACKAGE;
            }
        };

        public boolean isAcceptable(SourceFile sourceFile) {
            Xml.Document doc;
            if (sourceFile instanceof Xml.Document && (doc = (Xml.Document)sourceFile).getRoot() != null) {
                for (Xml.Attribute attrib : doc.getRoot().getAttributes()) {
                    if (!attrib.getKeyAsString().equals("xsi:schemaLocation") || !attrib.getValueAsString().contains("www.springframework.org/schema/beans")) continue;
                    return true;
                }
            }
            return false;
        }

        public SimpleTraitMatcher<SpringXmlReference> getMatcher() {
            return matcher;
        }
    }
}

