/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.internal;

import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.marker.Marker;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public class XmlPrinter<P>
extends XmlVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> XML_MARKER_WRAPPER = out -> "<!--~~" + out + (out.isEmpty() ? "" : "~~") + ">-->";

    @Override
    public Xml visitDocument(Xml.Document document, PrintOutputCapture<P> p) {
        this.beforeSyntax(document, p);
        document = (Xml.Document)super.visitDocument(document, p);
        this.afterSyntax(document, p);
        p.append(document.getEof());
        return document;
    }

    @Override
    public Xml visitProlog(Xml.Prolog prolog, PrintOutputCapture<P> p) {
        this.beforeSyntax(prolog, p);
        super.visitProlog(prolog, p);
        this.afterSyntax(prolog, p);
        return prolog;
    }

    @Override
    public Xml visitXmlDecl(Xml.XmlDecl xmlDecl, PrintOutputCapture<P> p) {
        this.beforeSyntax(xmlDecl, p);
        p.append("<?").append(xmlDecl.getName());
        this.visit(xmlDecl.getAttributes(), p);
        p.append(xmlDecl.getBeforeTagDelimiterPrefix()).append("?>");
        this.afterSyntax(xmlDecl, p);
        return xmlDecl;
    }

    @Override
    public Xml visitTag(Xml.Tag tag, PrintOutputCapture<P> p) {
        this.beforeSyntax(tag, p);
        p.append('<');
        boolean isJspDirective = this.getCursor().getParentOrThrow().getValue() instanceof Xml.Prolog;
        if (isJspDirective) {
            p.append("%@");
        }
        p.append(tag.getName());
        this.visit(tag.getAttributes(), p);
        p.append(tag.getBeforeTagDelimiterPrefix());
        if (tag.getClosing() == null) {
            p.append("/>");
        } else {
            p.append('>');
            this.visit(tag.getContent(), p);
            this.visit(tag.getClosing(), p);
        }
        this.afterSyntax(tag, p);
        return tag;
    }

    @Override
    public Xml visitTagClosing(Xml.Tag.Closing closing, PrintOutputCapture<P> p) {
        this.beforeSyntax(closing, p);
        p.append("</").append(closing.getName()).append(closing.getBeforeTagDelimiterPrefix()).append(">");
        this.afterSyntax(closing, p);
        return closing;
    }

    @Override
    public Xml visitAttribute(Xml.Attribute attribute, PrintOutputCapture<P> p) {
        this.beforeSyntax(attribute, p);
        p.append(attribute.getKey().getPrefix()).append(attribute.getKeyAsString()).append(attribute.getBeforeEquals()).append('=');
        this.visit(attribute.getValue(), p);
        this.afterSyntax(attribute, p);
        return attribute;
    }

    @Override
    public Xml visitAttributeValue(Xml.Attribute.Value value, PrintOutputCapture<P> p) {
        this.beforeSyntax(value, p);
        char valueDelim = Xml.Attribute.Value.Quote.Double == value.getQuote() ? (char)'\"' : '\'';
        p.append(valueDelim).append(value.getValue()).append(valueDelim);
        this.afterSyntax(value, p);
        return value;
    }

    @Override
    public Xml visitComment(Xml.Comment comment, PrintOutputCapture<P> p) {
        this.beforeSyntax(comment, p);
        p.append("<!--").append(comment.getText()).append("-->");
        this.afterSyntax(comment, p);
        return comment;
    }

    @Override
    public Xml visitProcessingInstruction(Xml.ProcessingInstruction processingInstruction, PrintOutputCapture<P> p) {
        this.beforeSyntax(processingInstruction, p);
        p.append("<?").append(processingInstruction.getName());
        this.visit(processingInstruction.getProcessingInstructions(), p);
        p.append(processingInstruction.getBeforeTagDelimiterPrefix()).append("?>");
        this.afterSyntax(processingInstruction, p);
        return processingInstruction;
    }

    @Override
    public Xml visitCharData(Xml.CharData charData, PrintOutputCapture<P> p) {
        this.beforeSyntax(charData, p);
        if (charData.isCdata()) {
            p.append("<![CDATA[").append(charData.getText()).append("]]>");
        } else {
            p.append(charData.getText());
        }
        p.append(charData.getAfterText());
        this.afterSyntax(charData, p);
        return charData;
    }

    @Override
    public Xml visitDocTypeDecl(Xml.DocTypeDecl docTypeDecl, PrintOutputCapture<P> p) {
        this.beforeSyntax(docTypeDecl, p);
        p.append("<!" + docTypeDecl.getDocumentDeclaration());
        this.visit(docTypeDecl.getName(), p);
        this.visit(docTypeDecl.getExternalId(), p);
        this.visit(docTypeDecl.getInternalSubset(), p);
        this.visit(docTypeDecl.getExternalSubsets(), p);
        p.append(docTypeDecl.getBeforeTagDelimiterPrefix());
        p.append('>');
        this.afterSyntax(docTypeDecl, p);
        return docTypeDecl;
    }

    @Override
    public Xml visitDocTypeDeclExternalSubsets(Xml.DocTypeDecl.ExternalSubsets externalSubsets, PrintOutputCapture<P> p) {
        this.beforeSyntax(externalSubsets, p);
        p.append('[');
        this.visit(externalSubsets.getElements(), p);
        p.append(']');
        this.afterSyntax(externalSubsets, p);
        return externalSubsets;
    }

    @Override
    public Xml visitElement(Xml.Element element, PrintOutputCapture<P> p) {
        this.beforeSyntax(element, p);
        this.visit(element.getSubset(), p);
        p.append(element.getBeforeTagDelimiterPrefix());
        this.afterSyntax(element, p);
        return element;
    }

    @Override
    public Xml visitIdent(Xml.Ident ident, PrintOutputCapture<P> p) {
        this.beforeSyntax(ident, p);
        p.append(ident.getName());
        this.afterSyntax(ident, p);
        return ident;
    }

    @Override
    public Xml visitJspDirective(Xml.JspDirective jsp, PrintOutputCapture<P> p) {
        this.beforeSyntax(jsp, p);
        p.append("<%@");
        p.append(jsp.getBeforeTypePrefix());
        p.append(jsp.getType());
        this.visit(jsp.getAttributes(), p);
        p.append(jsp.getBeforeDirectiveEndPrefix());
        p.append("%>");
        this.afterSyntax(jsp, p);
        return jsp;
    }

    private void beforeSyntax(Xml x, PrintOutputCapture<P> p) {
        for (Marker marker : x.getMarkers().getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), XML_MARKER_WRAPPER));
        }
        p.append(x.getPrefix());
        this.visitMarkers(x.getMarkers(), p);
        for (Marker marker : x.getMarkers().getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), XML_MARKER_WRAPPER));
        }
    }

    private void afterSyntax(Xml x, PrintOutputCapture<P> p) {
        for (Marker marker : x.getMarkers().getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), XML_MARKER_WRAPPER));
        }
    }
}

