/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.archetype;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.SelectorUtils;
import org.ops4j.pax.construct.archetype.AbstractPaxArchetypeMojo;
import org.ops4j.pax.construct.util.BndUtils;
import org.ops4j.pax.construct.util.PomUtils;

public class OSGiBundleArchetypeMojo
extends AbstractPaxArchetypeMojo {
    private static final String OSGI_BUNDLE_ARCHETYPE_ID = "maven-archetype-osgi-bundle";
    private static final String OSGI_SERVICE_ARCHETYPE_ID = "maven-archetype-osgi-service";
    private static final String SPRING_BEAN_ARCHETYPE_ID = "maven-archetype-spring-bean";
    private static final String SPRING_VERSION_PROPERTY = "spring.maven.artifact.version";
    private static final String SPRING_VERSION_VARIABLE = "${spring.maven.artifact.version}";
    private static final String TEMP_SETTINGS_PATH = "target/settings/";
    private String parentId;
    private String bundleGroupId;
    private String packageName;
    private String bundleName;
    private String version;
    private boolean provideInterface;
    private boolean provideInternals;
    private boolean provideActivator;
    private String junitVersion;
    private String springVersion;
    private boolean noDependencies;
    private boolean m_haveExampleActivator;

    protected String getParentId() {
        return this.parentId;
    }

    protected void updateExtensionFields() {
        this.populateMissingFields();
        this.setMainArchetype(OSGI_BUNDLE_ARCHETYPE_ID);
        this.setArchetypeProperty("groupId", this.getInternalGroupId(this.bundleGroupId));
        this.setArchetypeProperty("artifactId", this.bundleName);
        this.setArchetypeProperty("version", this.version);
        this.setArchetypeProperty("packageName", this.packageName);
        if (!this.hasCustomContent() && (this.provideInterface || this.provideInternals)) {
            if (null == this.springVersion) {
                this.scheduleArchetype("org.ops4j.pax.construct", OSGI_SERVICE_ARCHETYPE_ID, null);
                this.m_haveExampleActivator = this.provideActivator && this.provideInternals;
            } else {
                this.scheduleArchetype("org.ops4j.pax.construct", SPRING_BEAN_ARCHETYPE_ID, null);
            }
        }
        this.setArchetypeProperty("symbolicName", this.getBundleSymbolicName());
    }

    private void populateMissingFields() {
        if (PomUtils.isEmpty(this.bundleName)) {
            this.bundleName = this.packageName;
        }
        this.packageName = this.packageName.replaceAll("[/\\\\]+$", "");
        this.bundleName = this.bundleName.replaceAll("[/\\\\]+$", "");
        if ("true".equals(this.junitVersion) || "".equals(this.junitVersion)) {
            this.junitVersion = "3.8.2";
        }
        if ("true".equals(this.springVersion) || "".equals(this.springVersion)) {
            this.springVersion = "2.5.4";
        }
    }

    public String getBundleSymbolicName() {
        if (this.bundleName.startsWith(this.packageName)) {
            return this.bundleName;
        }
        return this.getCompoundId(this.getInternalGroupId(this.bundleGroupId), this.bundleName);
    }

    protected void postProcess(PomUtils.Pom pom, BndUtils.Bnd bnd) throws MojoExecutionException {
        if (null == pom.getParentId()) {
            OSGiBundleArchetypeMojo.makeStandalone(pom, "compiled", this.getPluginVersion());
        }
        this.markBogusFiles();
        this.updatePomDependencies(pom);
        this.updateBndInstructions(bnd);
    }

    private void updatePomDependencies(PomUtils.Pom pom) {
        if (!this.noDependencies) {
            this.addCoreOSGiSupport(pom);
            if (this.junitVersion != null) {
                this.addJUnitTestSupport(pom);
            }
            if (this.springVersion != null) {
                this.addSpringBeanSupport(pom);
            }
        }
    }

    private void markBogusFiles() {
        String packagePath = this.packageName.replace('.', '/');
        if (!this.provideInterface) {
            this.addTempFiles("src/main/java/" + packagePath + "/*.java");
        }
        if (!this.provideInternals) {
            this.addTempFiles("src/main/resources/");
            this.addTempFiles("src/main/java/" + packagePath + "/internal/");
        }
        if (!this.provideInternals || null == this.junitVersion && !this.hasCustomContent()) {
            this.addTempFiles("src/test/resources/");
            this.addTempFiles("src/test/java/" + packagePath + "/internal/");
        }
        if (!this.provideActivator) {
            this.addTempFiles("src/main/java/" + packagePath + "/internal/*Activator.java");
        }
        this.addTempFiles(TEMP_SETTINGS_PATH);
    }

    protected static void makeStandalone(PomUtils.Pom pom, String bundleType, String pluginVersion) throws MojoExecutionException {
        PomUtils.Pom customSettings;
        PomUtils.Pom pluginSettings;
        File baseDir = pom.getBasedir();
        File pluginSettingsDir = new File(baseDir, TEMP_SETTINGS_PATH);
        File customSettingsDir = new File(pluginSettingsDir, bundleType);
        try {
            pluginSettings = PomUtils.readPom(pluginSettingsDir);
            customSettings = PomUtils.readPom(customSettingsDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to find settings POM");
        }
        pom.mergeSection(customSettings, "build/resources", "build", false);
        pom.mergeSection(pluginSettings, "build/pluginManagement/plugins", "build", false);
        pom.mergeSection(customSettings, "build/plugins", "build", false);
        pom.updatePluginVersion("org.ops4j", "maven-pax-plugin", pluginVersion);
    }

    private void addCoreOSGiSupport(PomUtils.Pom pom) {
        Dependency osgiCore = new Dependency();
        osgiCore.setGroupId("org.osgi");
        osgiCore.setArtifactId("osgi_R4_core");
        if (null == pom.getParentId()) {
            osgiCore.setVersion("1.0");
            osgiCore.setScope("provided");
        }
        osgiCore.setOptional(true);
        pom.addDependency(osgiCore, true);
        Dependency osgiCompendium = new Dependency();
        osgiCompendium.setGroupId("org.osgi");
        osgiCompendium.setArtifactId("osgi_R4_compendium");
        if (null == pom.getParentId()) {
            osgiCompendium.setVersion("1.0");
            osgiCompendium.setScope("provided");
        }
        osgiCompendium.setOptional(true);
        pom.addDependency(osgiCompendium, true);
    }

    private void addSpringBeanSupport(PomUtils.Pom pom) {
        pom.setProperty(SPRING_VERSION_PROPERTY, this.springVersion);
        if (this.junitVersion != null) {
            Dependency springTest = new Dependency();
            springTest.setGroupId("org.springframework");
            springTest.setArtifactId("spring-test");
            springTest.setVersion(SPRING_VERSION_VARIABLE);
            springTest.setScope("test");
            pom.addDependency(springTest, true);
        }
        Dependency springBundle = new Dependency();
        springBundle.setGroupId("org.springframework");
        springBundle.setVersion(SPRING_VERSION_VARIABLE);
        springBundle.setScope("provided");
        springBundle.setOptional(true);
        springBundle.setArtifactId("spring-core");
        pom.addDependency(springBundle, true);
        springBundle.setArtifactId("spring-context");
        pom.addDependency(springBundle, true);
        springBundle.setArtifactId("spring-beans");
        pom.addDependency(springBundle, true);
    }

    private void addJUnitTestSupport(PomUtils.Pom pom) {
        Dependency junit = new Dependency();
        junit.setGroupId("junit");
        junit.setArtifactId("junit");
        junit.setVersion(this.junitVersion);
        junit.setScope("test");
        pom.addDependency(junit, true);
    }

    private void updateBndInstructions(BndUtils.Bnd bnd) {
        boolean haveInternals = false;
        boolean haveInterface = false;
        Set filenames = this.getFinalFilenames();
        Iterator i = filenames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (SelectorUtils.matchPath((String)OSGiBundleArchetypeMojo.fixPathPattern("src/main/java/**/internal/*.java"), (String)name)) {
                haveInternals = true;
                continue;
            }
            if (!SelectorUtils.matchPath((String)OSGiBundleArchetypeMojo.fixPathPattern("src/main/java/**/*.java"), (String)name)) continue;
            haveInterface = true;
        }
        this.applyBndInstructions(bnd, this.m_haveExampleActivator, haveInternals, haveInterface);
    }

    private static String fixPathPattern(String pathPattern) {
        return pathPattern.replace('/', File.separatorChar);
    }

    private void applyBndInstructions(BndUtils.Bnd bnd, boolean haveActivator, boolean haveInternals, boolean haveInterface) {
        if (!haveActivator) {
            bnd.removeInstruction("Bundle-Activator");
        }
        if (!haveInternals) {
            bnd.setInstruction("Export-Package", "${bundle.namespace}.*;version=\"${pom.version}\"", true);
            bnd.setInstruction("Private-Package", null, true);
        }
        if (!haveInterface) {
            bnd.setInstruction("Export-Package", null, true);
        }
    }
}

