/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.clone;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.ops4j.pax.construct.clone.MavenOptionBuilder;
import org.ops4j.pax.construct.clone.PaxCommandBuilder;
import org.ops4j.pax.construct.clone.PaxScript;
import org.ops4j.pax.construct.util.StreamFactory;

public class PaxScriptImpl
implements PaxScript {
    private final List m_commands = new ArrayList();

    List getCommands() {
        return this.m_commands;
    }

    public PaxCommandBuilder call(String command) {
        return new PaxCommand(command);
    }

    public void write(String title, File scriptFile, List setupCommands) throws IOException {
        Collections.sort(this.m_commands, new ByTargetDir());
        scriptFile.getParentFile().mkdirs();
        BufferedWriter writer = new BufferedWriter(StreamFactory.newPlatformWriter(scriptFile));
        boolean isBatchFile = scriptFile.getName().endsWith(".bat");
        PaxScriptImpl.writeSnippet(writer, isBatchFile, "header");
        writer.newLine();
        PaxScriptImpl.writeMessage(writer, "INSTALLING ARCHETYPES CLONED FROM [" + title + ']');
        writer.newLine();
        PaxScriptImpl.writeCommands(writer, isBatchFile, setupCommands);
        writer.newLine();
        PaxScriptImpl.writeSnippet(writer, isBatchFile, "postsetup");
        writer.newLine();
        PaxScriptImpl.writeMessage(writer, "RECREATING MAVEN PROJECT BASED ON [" + title + ']');
        writer.newLine();
        PaxScriptImpl.writeCommands(writer, isBatchFile, this.m_commands);
        IOUtil.close((Writer)writer);
    }

    private static void writeSnippet(BufferedWriter writer, boolean isBatchFile, String snippet) throws IOException {
        String resourceName = isBatchFile ? "/snippets/" + snippet + ".bat" : "/snippets/" + snippet + ".sh";
        String snippetText = IOUtil.toString((InputStream)PaxScriptImpl.class.getResourceAsStream(resourceName));
        writer.write(snippetText);
    }

    private static void writeMessage(BufferedWriter writer, String message) throws IOException {
        String border = "++++" + message.replaceAll(".", "+");
        writer.write("echo " + border);
        writer.newLine();
        writer.write("echo + " + message + " +");
        writer.newLine();
        writer.write("echo " + border);
        writer.newLine();
    }

    private static void writeCommands(BufferedWriter writer, boolean isBatchFile, List commands) throws IOException {
        boolean standalone = commands.size() == 1;
        Iterator i = commands.iterator();
        while (i.hasNext()) {
            String cmd = i.next().toString();
            if (isBatchFile) {
                writer.write("call ");
                cmd = cmd.replaceAll("\\$\\{([^}]*)\\}", "%$1%");
            }
            if (standalone) {
                cmd = isBatchFile ? StringUtils.replace((String)cmd, (String)" -- ", (String)" %1 %2 %3 %4 %5 %6 %7 %8 %9 -- ") : StringUtils.replace((String)cmd, (String)" -- ", (String)" \"$@\" -- ");
            }
            writer.write(cmd);
            writer.newLine();
        }
    }

    static class ByTargetDir
    implements Comparator {
        ByTargetDir() {
        }

        public int compare(Object lhs, Object rhs) {
            if (lhs instanceof PaxCommand) {
                if (rhs instanceof PaxCommand) {
                    return this.compare((PaxCommand)lhs, (PaxCommand)rhs);
                }
                return 1;
            }
            if (rhs instanceof PaxCommand) {
                return -1;
            }
            return 0;
        }

        private int compare(PaxCommand lhsCommand, PaxCommand rhsCommand) {
            boolean lhsIsImport = "import-bundle".equals(lhsCommand.getName());
            boolean rhsIsImport = "import-bundle".equals(rhsCommand.getName());
            if (lhsIsImport && !rhsIsImport) {
                return 1;
            }
            if (!lhsIsImport && rhsIsImport) {
                return -1;
            }
            return lhsCommand.getTargetDir().compareTo(rhsCommand.getTargetDir());
        }
    }

    class PaxCommand
    implements PaxCommandBuilder {
        private final String m_name;
        private final List m_paxOptions;
        private final List m_mvnOptions;
        private String m_targetDir;

        public PaxCommand(String command) {
            this.m_name = command;
            this.m_mvnOptions = new ArrayList();
            this.m_paxOptions = new ArrayList();
            this.m_targetDir = "";
            PaxScriptImpl.this.getCommands().add(this);
        }

        String getName() {
            return this.m_name;
        }

        List getMvnOptions() {
            return this.m_mvnOptions;
        }

        List getPaxOptions() {
            return this.m_paxOptions;
        }

        String getTargetDir() {
            return this.m_targetDir;
        }

        void setTargetDir(String targetDir) {
            this.m_targetDir = targetDir;
        }

        public PaxCommandBuilder flag(char flag) {
            this.m_paxOptions.add(new Flag("" + flag));
            return this;
        }

        public PaxCommandBuilder option(char option, String value) {
            this.m_paxOptions.add(new Option("" + option, ' ', value));
            return this;
        }

        public MavenOptionBuilder maven() {
            return new MavenOption();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("pax-" + this.m_name);
            Iterator i = this.m_paxOptions.iterator();
            while (i.hasNext()) {
                buf.append(' ');
                buf.append(i.next());
            }
            if (!this.m_mvnOptions.isEmpty()) {
                buf.append(" --");
            }
            i = this.m_mvnOptions.iterator();
            while (i.hasNext()) {
                buf.append(' ');
                buf.append(i.next());
            }
            return buf.toString();
        }

        class MavenOption
        implements MavenOptionBuilder {
            MavenOption() {
            }

            public MavenOptionBuilder flag(String flag) {
                PaxCommand.this.getMvnOptions().add(new Flag('D' + flag));
                return this;
            }

            public MavenOptionBuilder option(String option, String value) {
                if ("targetDirectory".equals(option)) {
                    PaxCommand.this.setTargetDir(value);
                }
                PaxCommand.this.getMvnOptions().add(new Option('D' + option, '=', value));
                return this;
            }
        }
    }

    private class Option
    extends Flag {
        private char m_separator;
        private String m_value;

        public Option(String option, char separator, String value) {
            super(option);
            this.m_separator = separator;
            this.m_value = value;
        }

        public String toString() {
            if (' ' == this.m_separator) {
                return super.toString() + this.m_separator + '\"' + this.m_value + '\"';
            }
            return '\"' + super.toString() + this.m_separator + this.m_value + '\"';
        }
    }

    private class Flag {
        private String m_flag;

        public Flag(String flag) {
            this.m_flag = flag;
        }

        public String toString() {
            return '-' + this.m_flag;
        }
    }
}

