/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.util;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.ops4j.pax.construct.util.RoundTripBndFile;

public final class BndUtils {
    private BndUtils() {
    }

    public static Bnd readBnd(File here) throws IOException {
        File candidate = here;
        if (null == here) {
            throw new IOException("null location");
        }
        if (here.isDirectory()) {
            candidate = new File(here, "osgi.bnd");
        }
        return new RoundTripBndFile(candidate);
    }

    public static class ExistingInstructionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ExistingInstructionException(String directive) {
            super("Bnd file already has a " + directive + " directive, use -Doverwrite or -o to replace it");
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        public String toString() {
            return "[INFO] not available";
        }
    }

    public static interface Bnd {
        public String getInstruction(String var1);

        public void setInstruction(String var1, String var2, boolean var3) throws ExistingInstructionException;

        public boolean removeInstruction(String var1);

        public Set getDirectives();

        public void overlayInstructions(Bnd var1);

        public File getFile();

        public File getBasedir();

        public void write() throws IOException;
    }
}

