/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.http.client.protocol;

import java.io.IOException;
import java.util.Collection;
import shaded.org.apache.http.Header;
import shaded.org.apache.http.HttpException;
import shaded.org.apache.http.HttpRequest;
import shaded.org.apache.http.HttpRequestInterceptor;
import shaded.org.apache.http.annotation.Contract;
import shaded.org.apache.http.annotation.ThreadingBehavior;
import shaded.org.apache.http.protocol.HttpContext;
import shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection<? extends Header> defHeaders = (Collection<? extends Header>)request.getParams().getParameter("http.default-headers");
        if (defHeaders == null) {
            defHeaders = this.defaultHeaders;
        }
        if (defHeaders != null) {
            for (Header header : defHeaders) {
                request.addHeader(header);
            }
        }
    }
}

