/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.Objects;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;

final class TwoIndexProperties
implements IndexProperties {
    private final Object propertyA;
    private final Object propertyB;

    TwoIndexProperties(Object propertyA, Object propertyB) {
        this.propertyA = propertyA;
        this.propertyB = propertyB;
    }

    @Override
    public <Type_> Type_ toKey(int index) {
        switch (index) {
            case 0: {
                return (Type_)this.propertyA;
            }
            case 1: {
                return (Type_)this.propertyB;
            }
        }
        throw new IllegalArgumentException("Impossible state: index (" + index + ") != 0");
    }

    @Override
    public <Type_> Type_ toKey(int from, int to) {
        switch (to - from) {
            case 1: {
                return this.toKey(from);
            }
            case 2: {
                if (from != 0 || to != 2) {
                    throw new IllegalArgumentException("Impossible state: key from (" + from + ") to (" + to + ").");
                }
                return (Type_)this;
            }
        }
        throw new IllegalArgumentException("Impossible state: key from (" + from + ") to (" + to + ").");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TwoIndexProperties)) {
            return false;
        }
        TwoIndexProperties other = (TwoIndexProperties)o;
        return Objects.equals(this.propertyA, other.propertyA) && Objects.equals(this.propertyB, other.propertyB);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.propertyA);
        result = 31 * result + Objects.hashCode(this.propertyB);
        return result;
    }

    public String toString() {
        return "[" + this.propertyA + ", " + this.propertyB + "]";
    }
}

