/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner;

import java.lang.reflect.Field;
import java.util.Objects;
import org.optaplanner.core.api.function.TriConsumer;
import org.optaplanner.core.impl.domain.solution.cloner.FieldCloningUtils;

final class ShallowCloningFieldCloner {
    private final Field field;
    private final TriConsumer<Field, Object, Object> copyOperation;

    public static ShallowCloningFieldCloner of(Field field) {
        Class<?> fieldType = field.getType();
        if (fieldType == Boolean.TYPE) {
            return new ShallowCloningFieldCloner(field, FieldCloningUtils::copyBoolean);
        }
        if (fieldType == Byte.TYPE) {
            return new ShallowCloningFieldCloner(field, FieldCloningUtils::copyByte);
        }
        if (fieldType == Character.TYPE) {
            return new ShallowCloningFieldCloner(field, FieldCloningUtils::copyChar);
        }
        if (fieldType == Short.TYPE) {
            return new ShallowCloningFieldCloner(field, FieldCloningUtils::copyShort);
        }
        if (fieldType == Integer.TYPE) {
            return new ShallowCloningFieldCloner(field, FieldCloningUtils::copyInt);
        }
        if (fieldType == Long.TYPE) {
            return new ShallowCloningFieldCloner(field, FieldCloningUtils::copyLong);
        }
        if (fieldType == Float.TYPE) {
            return new ShallowCloningFieldCloner(field, FieldCloningUtils::copyFloat);
        }
        if (fieldType == Double.TYPE) {
            return new ShallowCloningFieldCloner(field, FieldCloningUtils::copyDouble);
        }
        return new ShallowCloningFieldCloner(field, FieldCloningUtils::copyObject);
    }

    private ShallowCloningFieldCloner(Field field, TriConsumer<Field, Object, Object> copyOperation) {
        this.field = Objects.requireNonNull(field);
        this.copyOperation = Objects.requireNonNull(copyOperation);
    }

    public <C> void clone(C original, C clone) {
        this.copyOperation.accept(this.field, original, clone);
    }
}

