/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.inverserelation;

import java.util.List;
import org.optaplanner.core.api.domain.variable.ListVariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class SingletonListInverseVariableListener<Solution_>
implements ListVariableListener<Solution_, Object, Object>,
SingletonInverseVariableSupply {
    protected final InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor;
    protected final ListVariableDescriptor<Solution_> sourceVariableDescriptor;

    public SingletonListInverseVariableListener(InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor, ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public void beforeEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
        for (Object element : this.sourceVariableDescriptor.getListVariable(entity)) {
            this.setInverse((InnerScoreDirector)scoreDirector, element, entity, null);
        }
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        for (Object element : this.sourceVariableDescriptor.getListVariable(entity)) {
            this.setInverse(innerScoreDirector, element, null, entity);
        }
    }

    @Override
    public void afterListVariableElementUnassigned(ScoreDirector<Solution_> scoreDirector, Object element) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        innerScoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
        this.shadowVariableDescriptor.setValue(element, null);
        innerScoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
    }

    @Override
    public void beforeListVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity, int fromIndex, int toIndex) {
    }

    @Override
    public void afterListVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity, int fromIndex, int toIndex) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        for (int i = fromIndex; i < toIndex; ++i) {
            Object element = listVariable.get(i);
            if (this.shadowVariableDescriptor.getValue(element) == entity) continue;
            innerScoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
            this.shadowVariableDescriptor.setValue(element, entity);
            innerScoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
        }
    }

    private void setInverse(InnerScoreDirector<Solution_, ?> scoreDirector, Object element, Object inverseEntity, Object expectedOldInverseEntity) {
        Object oldInverseEntity = this.shadowVariableDescriptor.getValue(element);
        if (oldInverseEntity == inverseEntity) {
            return;
        }
        if (oldInverseEntity != expectedOldInverseEntity) {
            throw new IllegalStateException("The entity (" + inverseEntity + ") has a list variable (" + this.sourceVariableDescriptor.getVariableName() + ") and one of its elements (" + element + ") which has a shadow variable (" + this.shadowVariableDescriptor.getVariableName() + ") has an oldInverseEntity (" + oldInverseEntity + ") which is not that entity.\nVerify the consistency of your input problem for that shadow variable.");
        }
        scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
        this.shadowVariableDescriptor.setValue(element, inverseEntity);
        scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
    }

    @Override
    public Object getInverseSingleton(Object planningValue) {
        return this.shadowVariableDescriptor.getValue(planningValue);
    }
}

