/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.nearby;

import java.util.Objects;
import org.optaplanner.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.AbstractNearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.optaplanner.core.impl.util.MemoizingSupply;

public abstract class AbstractNearbySelector<Solution_, ChildSelector_ extends PhaseLifecycleListener<Solution_>, ReplayingSelector_ extends PhaseLifecycleListener<Solution_>>
extends AbstractDemandEnabledSelector<Solution_> {
    protected final ChildSelector_ childSelector;
    protected final ReplayingSelector_ replayingSelector;
    protected final NearbyDistanceMeter<?, ?> nearbyDistanceMeter;
    protected final NearbyRandom nearbyRandom;
    protected final boolean randomSelection;
    private final AbstractNearbyDistanceMatrixDemand<?, ?, ?, ?> nearbyDistanceMatrixDemand;
    protected MemoizingSupply<NearbyDistanceMatrix<Object, Object>> nearbyDistanceMatrixSupply = null;

    protected AbstractNearbySelector(ChildSelector_ childSelector, Object replayingSelector, NearbyDistanceMeter<?, ?> nearbyDistanceMeter, NearbyRandom nearbyRandom, boolean randomSelection) {
        this.childSelector = childSelector;
        this.replayingSelector = this.castReplayingSelector(replayingSelector);
        this.nearbyDistanceMeter = nearbyDistanceMeter;
        if (randomSelection && nearbyRandom == null) {
            throw new IllegalArgumentException("The selector (" + this + ") with randomSelection (" + randomSelection + ") has no nearbyRandom (" + nearbyRandom + ").");
        }
        this.nearbyRandom = nearbyRandom;
        this.randomSelection = randomSelection;
        this.nearbyDistanceMatrixDemand = this.createDemand();
        this.phaseLifecycleSupport.addEventListener(childSelector);
        this.phaseLifecycleSupport.addEventListener(this.replayingSelector);
    }

    protected abstract ReplayingSelector_ castReplayingSelector(Object var1);

    protected abstract AbstractNearbyDistanceMatrixDemand<?, ?, ?, ?> createDemand();

    public final AbstractNearbyDistanceMatrixDemand<?, ?, ?, ?> getNearbyDistanceMatrixDemand() {
        return this.nearbyDistanceMatrixDemand;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.nearbyDistanceMatrixSupply = (MemoizingSupply)solverScope.getScoreDirector().getSupplyManager().demand(this.nearbyDistanceMatrixDemand);
    }

    @Override
    public final void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.nearbyDistanceMatrixSupply.read();
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        solverScope.getScoreDirector().getSupplyManager().cancel(this.nearbyDistanceMatrixDemand);
        this.nearbyDistanceMatrixSupply = null;
    }

    @Override
    public final boolean isNeverEnding() {
        return this.randomSelection || !this.isCountable();
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractNearbySelector that = (AbstractNearbySelector)other;
        return this.randomSelection == that.randomSelection && Objects.equals(this.childSelector, that.childSelector) && Objects.equals(this.replayingSelector, that.replayingSelector) && Objects.equals(this.nearbyDistanceMeter, that.nearbyDistanceMeter) && Objects.equals(this.nearbyRandom, that.nearbyRandom);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.randomSelection, this.childSelector, this.replayingSelector, this.nearbyDistanceMeter, this.nearbyRandom);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(" + this.replayingSelector + ", " + this.childSelector + ")";
    }
}

