/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.nearby;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.AbstractNearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;

final class EntityNearbyDistanceMatrixDemand<Solution_, Origin_, Destination_>
extends AbstractNearbyDistanceMatrixDemand<Origin_, Destination_, EntitySelector<Solution_>, EntitySelector<Solution_>> {
    private final ToIntFunction<Origin_> destinationSizeFunction;

    public EntityNearbyDistanceMatrixDemand(NearbyDistanceMeter<Origin_, Destination_> meter, NearbyRandom random, EntitySelector<Solution_> childSelector, EntitySelector<Solution_> replayingOriginEntitySelector, ToIntFunction<Origin_> destinationSizeFunction) {
        super(meter, random, childSelector, replayingOriginEntitySelector);
        this.destinationSizeFunction = destinationSizeFunction;
    }

    @Override
    protected NearbyDistanceMatrix<Origin_, Destination_> supplyNearbyDistanceMatrix() {
        long childSize = ((EntitySelector)this.childSelector).getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The childEntitySelector (" + this.childSelector + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        long originSize = ((EntitySelector)this.replayingSelector).getSize();
        if (originSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The originEntitySelector (" + this.replayingSelector + ") has an entitySize (" + originSize + ") which is higher than Integer.MAX_VALUE.");
        }
        Function<Object, Iterator> destinationIteratorProvider = origin -> ((EntitySelector)this.childSelector).endingIterator();
        NearbyDistanceMatrix nearbyDistanceMatrix = new NearbyDistanceMatrix(this.meter, (int)originSize, destinationIteratorProvider, this.destinationSizeFunction);
        ((EntitySelector)this.replayingSelector).endingIterator().forEachRemaining(origin -> nearbyDistanceMatrix.addAllDestinations(origin));
        return nearbyDistanceMatrix;
    }
}

