/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.list.nearby;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.AbstractNearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.list.ElementDestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.value.mimic.MimicReplayingValueSelector;

final class ListNearbyDistanceMatrixDemand<Solution_, Origin_, Destination_>
extends AbstractNearbyDistanceMatrixDemand<Origin_, Destination_, ElementDestinationSelector<Solution_>, MimicReplayingValueSelector<Solution_>> {
    private final ToIntFunction<Origin_> destinationSizeFunction;

    public ListNearbyDistanceMatrixDemand(NearbyDistanceMeter<Origin_, Destination_> meter, NearbyRandom random, ElementDestinationSelector<Solution_> childDestinationSelector, MimicReplayingValueSelector<Solution_> replayingOriginValueSelector, ToIntFunction<Origin_> destinationSizeFunction) {
        super(meter, random, childDestinationSelector, replayingOriginValueSelector);
        this.destinationSizeFunction = destinationSizeFunction;
    }

    @Override
    protected NearbyDistanceMatrix<Origin_, Destination_> supplyNearbyDistanceMatrix() {
        long childSize = ((ElementDestinationSelector)this.childSelector).getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The childSize (" + childSize + ") is higher than Integer.MAX_VALUE.");
        }
        long originSize = ((MimicReplayingValueSelector)this.replayingSelector).getSize();
        if (originSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The originValueSelector (" + this.replayingSelector + ") has a valueSize (" + originSize + ") which is higher than Integer.MAX_VALUE.");
        }
        Function<Object, Iterator> destinationIteratorProvider = origin -> ((ElementDestinationSelector)this.childSelector).endingIterator();
        NearbyDistanceMatrix nearbyDistanceMatrix = new NearbyDistanceMatrix(this.meter, (int)originSize, destinationIteratorProvider, this.destinationSizeFunction);
        ((MimicReplayingValueSelector)this.replayingSelector).endingIterator(null).forEachRemaining(origin -> nearbyDistanceMatrix.addAllDestinations(origin));
        return nearbyDistanceMatrix;
    }
}

