/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.composite;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import java.util.function.ToDoubleFunction;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.solver.random.RandomUtils;

final class BiasedRandomUnionMoveIterator<Solution_>
extends SelectionIterator<Move<Solution_>> {
    private final Map<Iterator<Move<Solution_>>, ProbabilityItem<Solution_>> probabilityItemMap;
    private final NavigableMap<Double, Iterator<Move<Solution_>>> moveIteratorMap;
    private final Random workingRandom;
    private double probabilityWeightTotal;
    private boolean stale;

    public BiasedRandomUnionMoveIterator(List<MoveSelector<Solution_>> childMoveSelectorList, ToDoubleFunction<MoveSelector<Solution_>> probabilityWeightFunction, Random workingRandom) {
        this.probabilityItemMap = new LinkedHashMap<Iterator<Move<Solution_>>, ProbabilityItem<Solution_>>(childMoveSelectorList.size());
        for (MoveSelector<Solution_> moveSelector : childMoveSelectorList) {
            Iterator moveIterator = moveSelector.iterator();
            ProbabilityItem probabilityItem = new ProbabilityItem();
            probabilityItem.moveSelector = moveSelector;
            probabilityItem.moveIterator = moveIterator;
            probabilityItem.probabilityWeight = probabilityWeightFunction.applyAsDouble(moveSelector);
            this.probabilityItemMap.put(moveIterator, probabilityItem);
        }
        this.moveIteratorMap = new TreeMap<Double, Iterator<Move<Solution_>>>();
        this.stale = true;
        this.workingRandom = workingRandom;
    }

    @Override
    public boolean hasNext() {
        if (this.stale) {
            this.refreshMoveIteratorMap();
        }
        return !this.moveIteratorMap.isEmpty();
    }

    @Override
    public Move<Solution_> next() {
        if (this.stale) {
            this.refreshMoveIteratorMap();
        }
        double randomOffset = RandomUtils.nextDouble(this.workingRandom, this.probabilityWeightTotal);
        Map.Entry<Double, Iterator<Move<Solution_>>> entry = this.moveIteratorMap.floorEntry(randomOffset);
        Iterator<Move<Solution_>> moveIterator = entry.getValue();
        Move<Solution_> next = moveIterator.next();
        if (!moveIterator.hasNext()) {
            this.stale = true;
        }
        return next;
    }

    private void refreshMoveIteratorMap() {
        this.moveIteratorMap.clear();
        double probabilityWeightOffset = 0.0;
        for (ProbabilityItem<Solution_> probabilityItem : this.probabilityItemMap.values()) {
            if (probabilityItem.probabilityWeight == 0.0 || !probabilityItem.moveIterator.hasNext()) continue;
            this.moveIteratorMap.put(probabilityWeightOffset, probabilityItem.moveIterator);
            probabilityWeightOffset += probabilityItem.probabilityWeight;
        }
        this.probabilityWeightTotal = probabilityWeightOffset;
    }

    private static final class ProbabilityItem<Solution_> {
        MoveSelector<Solution_> moveSelector;
        Iterator<Move<Solution_>> moveIterator;
        double probabilityWeight;

        private ProbabilityItem() {
        }
    }
}

