/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;

public final class SelectedCountLimitValueSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements EntityIndependentValueSelector<Solution_> {
    private final ValueSelector<Solution_> childValueSelector;
    private final long selectedCountLimit;

    public SelectedCountLimitValueSelector(ValueSelector<Solution_> childValueSelector, long selectedCountLimit) {
        this.childValueSelector = childValueSelector;
        this.selectedCountLimit = selectedCountLimit;
        if (selectedCountLimit < 0L) {
            throw new IllegalArgumentException("The selector (" + this + ") has a negative selectedCountLimit (" + selectedCountLimit + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public long getSize(Object entity) {
        long childSize = this.childValueSelector.getSize(entity);
        return Math.min(this.selectedCountLimit, childSize);
    }

    @Override
    public long getSize() {
        if (!(this.childValueSelector instanceof EntityIndependentValueSelector)) {
            throw new IllegalArgumentException("To use the method getSize(), the moveSelector (" + this + ") needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + this.childValueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
        }
        long childSize = ((EntityIndependentValueSelector)this.childValueSelector).getSize();
        return Math.min(this.selectedCountLimit, childSize);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return new SelectedCountLimitValueIterator(this.childValueSelector.iterator(entity));
    }

    @Override
    public Iterator<Object> iterator() {
        return new SelectedCountLimitValueIterator(((EntityIndependentValueSelector)this.childValueSelector).iterator());
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return new SelectedCountLimitValueIterator(this.childValueSelector.endingIterator(entity));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SelectedCountLimitValueSelector that = (SelectedCountLimitValueSelector)other;
        return this.selectedCountLimit == that.selectedCountLimit && Objects.equals(this.childValueSelector, that.childValueSelector);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childValueSelector, this.selectedCountLimit);
    }

    public String toString() {
        return "SelectedCountLimit(" + this.childValueSelector + ")";
    }

    private class SelectedCountLimitValueIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> childValueIterator;
        private long selectedSize;

        public SelectedCountLimitValueIterator(Iterator<Object> childValueIterator) {
            this.childValueIterator = childValueIterator;
            this.selectedSize = 0L;
        }

        @Override
        public boolean hasNext() {
            return this.selectedSize < SelectedCountLimitValueSelector.this.selectedCountLimit && this.childValueIterator.hasNext();
        }

        @Override
        public Object next() {
            if (this.selectedSize >= SelectedCountLimitValueSelector.this.selectedCountLimit) {
                throw new NoSuchElementException();
            }
            ++this.selectedSize;
            return this.childValueIterator.next();
        }
    }
}

