/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.score.director;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.KieResources;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.optaplanner.core.api.score.calculator.IncrementalScoreCalculator;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.score.definition.ScoreDefinitionType;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.config.util.KeyAsElementMapConverter;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.buildin.bendable.BendableScoreDefinition;
import org.optaplanner.core.impl.score.buildin.bendablebigdecimal.BendableBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.bendablelong.BendableLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardmediumsoft.HardMediumSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardmediumsoftlong.HardMediumSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoftdouble.HardSoftDoubleScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoftlong.HardSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simplebigdecimal.SimpleBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simpledouble.SimpleDoubleScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simplelong.SimpleLongScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenDroolsScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.easy.EasyScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.stream.ConstraintStreamScoreDirectorFactory;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="scoreDirectorFactory")
public class ScoreDirectorFactoryConfig
extends AbstractConfig<ScoreDirectorFactoryConfig> {
    private static final Logger logger = LoggerFactory.getLogger(ScoreDirectorFactoryConfig.class);
    private static final String GENERATE_DROOLS_TEST_ON_ERROR_PROPERTY_NAME = "optaplanner.drools.generateTestOnError";
    @Deprecated
    protected Class<? extends ScoreDefinition> scoreDefinitionClass = null;
    @Deprecated
    protected ScoreDefinitionType scoreDefinitionType = null;
    @Deprecated
    protected Integer bendableHardLevelsSize = null;
    @Deprecated
    protected Integer bendableSoftLevelsSize = null;
    protected Class<? extends EasyScoreCalculator> easyScoreCalculatorClass = null;
    @XStreamConverter(value=KeyAsElementMapConverter.class)
    protected Map<String, String> easyScoreCalculatorCustomProperties = null;
    protected Class<? extends ConstraintProvider> constraintProviderClass = null;
    @XStreamConverter(value=KeyAsElementMapConverter.class)
    protected Map<String, String> constraintProviderCustomProperties = null;
    protected ConstraintStreamImplType constraintStreamImplType;
    protected Class<? extends IncrementalScoreCalculator> incrementalScoreCalculatorClass = null;
    @XStreamConverter(value=KeyAsElementMapConverter.class)
    protected Map<String, String> incrementalScoreCalculatorCustomProperties = null;
    protected String ksessionName = null;
    @XStreamOmitField
    @Deprecated
    protected KieBase kieBase = null;
    @XStreamImplicit(itemFieldName="scoreDrl")
    protected List<String> scoreDrlList = null;
    @XStreamImplicit(itemFieldName="scoreDrlFile")
    protected List<File> scoreDrlFileList = null;
    @XStreamConverter(value=KeyAsElementMapConverter.class)
    protected Map<String, String> kieBaseConfigurationProperties = null;
    @Deprecated
    protected Boolean generateDroolsTestOnError = null;
    protected String initializingScoreTrend = null;
    @XStreamAlias(value="assertionScoreDirectorFactory")
    protected ScoreDirectorFactoryConfig assertionScoreDirectorFactory = null;

    @Deprecated
    public Class<? extends ScoreDefinition> getScoreDefinitionClass() {
        return this.scoreDefinitionClass;
    }

    @Deprecated
    public void setScoreDefinitionClass(Class<? extends ScoreDefinition> scoreDefinitionClass) {
        this.scoreDefinitionClass = scoreDefinitionClass;
    }

    @Deprecated
    public ScoreDefinitionType getScoreDefinitionType() {
        return this.scoreDefinitionType;
    }

    @Deprecated
    public void setScoreDefinitionType(ScoreDefinitionType scoreDefinitionType) {
        this.scoreDefinitionType = scoreDefinitionType;
    }

    @Deprecated
    public Integer getBendableHardLevelsSize() {
        return this.bendableHardLevelsSize;
    }

    @Deprecated
    public void setBendableHardLevelsSize(Integer bendableHardLevelsSize) {
        this.bendableHardLevelsSize = bendableHardLevelsSize;
    }

    @Deprecated
    public Integer getBendableSoftLevelsSize() {
        return this.bendableSoftLevelsSize;
    }

    @Deprecated
    public void setBendableSoftLevelsSize(Integer bendableSoftLevelsSize) {
        this.bendableSoftLevelsSize = bendableSoftLevelsSize;
    }

    public Class<? extends EasyScoreCalculator> getEasyScoreCalculatorClass() {
        return this.easyScoreCalculatorClass;
    }

    public void setEasyScoreCalculatorClass(Class<? extends EasyScoreCalculator> easyScoreCalculatorClass) {
        this.easyScoreCalculatorClass = easyScoreCalculatorClass;
    }

    public Map<String, String> getEasyScoreCalculatorCustomProperties() {
        return this.easyScoreCalculatorCustomProperties;
    }

    public void setEasyScoreCalculatorCustomProperties(Map<String, String> easyScoreCalculatorCustomProperties) {
        this.easyScoreCalculatorCustomProperties = easyScoreCalculatorCustomProperties;
    }

    public Class<? extends ConstraintProvider> getConstraintProviderClass() {
        return this.constraintProviderClass;
    }

    public void setConstraintProviderClass(Class<? extends ConstraintProvider> constraintProviderClass) {
        this.constraintProviderClass = constraintProviderClass;
    }

    public Map<String, String> getConstraintProviderCustomProperties() {
        return this.constraintProviderCustomProperties;
    }

    public void setConstraintProviderCustomProperties(Map<String, String> constraintProviderCustomProperties) {
        this.constraintProviderCustomProperties = constraintProviderCustomProperties;
    }

    public ConstraintStreamImplType getConstraintStreamImplType() {
        return this.constraintStreamImplType;
    }

    public void setConstraintStreamImplType(ConstraintStreamImplType constraintStreamImplType) {
        this.constraintStreamImplType = constraintStreamImplType;
    }

    public Class<? extends IncrementalScoreCalculator> getIncrementalScoreCalculatorClass() {
        return this.incrementalScoreCalculatorClass;
    }

    public void setIncrementalScoreCalculatorClass(Class<? extends IncrementalScoreCalculator> incrementalScoreCalculatorClass) {
        this.incrementalScoreCalculatorClass = incrementalScoreCalculatorClass;
    }

    public Map<String, String> getIncrementalScoreCalculatorCustomProperties() {
        return this.incrementalScoreCalculatorCustomProperties;
    }

    public void setIncrementalScoreCalculatorCustomProperties(Map<String, String> incrementalScoreCalculatorCustomProperties) {
        this.incrementalScoreCalculatorCustomProperties = incrementalScoreCalculatorCustomProperties;
    }

    public String getKsessionName() {
        return this.ksessionName;
    }

    public void setKsessionName(String ksessionName) {
        this.ksessionName = ksessionName;
    }

    @Deprecated
    public KieBase getKieBase() {
        return this.kieBase;
    }

    @Deprecated
    public void setKieBase(KieBase kieBase) {
        this.kieBase = kieBase;
    }

    public List<String> getScoreDrlList() {
        return this.scoreDrlList;
    }

    public void setScoreDrlList(List<String> scoreDrlList) {
        this.scoreDrlList = scoreDrlList;
    }

    public List<File> getScoreDrlFileList() {
        return this.scoreDrlFileList;
    }

    public void setScoreDrlFileList(List<File> scoreDrlFileList) {
        this.scoreDrlFileList = scoreDrlFileList;
    }

    public Map<String, String> getKieBaseConfigurationProperties() {
        return this.kieBaseConfigurationProperties;
    }

    public void setKieBaseConfigurationProperties(Map<String, String> kieBaseConfigurationProperties) {
        this.kieBaseConfigurationProperties = kieBaseConfigurationProperties;
    }

    public String getInitializingScoreTrend() {
        return this.initializingScoreTrend;
    }

    public void setInitializingScoreTrend(String initializingScoreTrend) {
        this.initializingScoreTrend = initializingScoreTrend;
    }

    public ScoreDirectorFactoryConfig getAssertionScoreDirectorFactory() {
        return this.assertionScoreDirectorFactory;
    }

    public void setAssertionScoreDirectorFactory(ScoreDirectorFactoryConfig assertionScoreDirectorFactory) {
        this.assertionScoreDirectorFactory = assertionScoreDirectorFactory;
    }

    @Deprecated
    public Boolean isGenerateDroolsTestOnError() {
        return this.generateDroolsTestOnError;
    }

    @Deprecated
    public void setGenerateDroolsTestOnError(Boolean generateDroolsTestOnError) {
        this.generateDroolsTestOnError = generateDroolsTestOnError;
    }

    public ScoreDirectorFactoryConfig withEasyScoreCalculatorClass(Class<? extends EasyScoreCalculator> easyScoreCalculatorClass) {
        this.easyScoreCalculatorClass = easyScoreCalculatorClass;
        return this;
    }

    public ScoreDirectorFactoryConfig withEasyScoreCalculatorCustomProperties(Map<String, String> easyScoreCalculatorCustomProperties) {
        this.easyScoreCalculatorCustomProperties = easyScoreCalculatorCustomProperties;
        return this;
    }

    public ScoreDirectorFactoryConfig withConstraintProviderClass(Class<? extends ConstraintProvider> constraintProviderClass) {
        this.constraintProviderClass = constraintProviderClass;
        return this;
    }

    public ScoreDirectorFactoryConfig withConstraintProviderCustomProperties(Map<String, String> constraintProviderCustomProperties) {
        this.constraintProviderCustomProperties = constraintProviderCustomProperties;
        return this;
    }

    public ScoreDirectorFactoryConfig withConstraintStreamImplType(ConstraintStreamImplType constraintStreamImplType) {
        this.constraintStreamImplType = constraintStreamImplType;
        return this;
    }

    public ScoreDirectorFactoryConfig withIncrementalScoreCalculatorClass(Class<? extends IncrementalScoreCalculator> incrementalScoreCalculatorClass) {
        this.incrementalScoreCalculatorClass = incrementalScoreCalculatorClass;
        return this;
    }

    public ScoreDirectorFactoryConfig withIncrementalScoreCalculatorCustomProperties(Map<String, String> incrementalScoreCalculatorCustomProperties) {
        this.incrementalScoreCalculatorCustomProperties = incrementalScoreCalculatorCustomProperties;
        return this;
    }

    public ScoreDirectorFactoryConfig withScoreDrlList(List<String> scoreDrlList) {
        this.scoreDrlList = scoreDrlList;
        return this;
    }

    public ScoreDirectorFactoryConfig withScoreDrls(String ... scoreDrls) {
        this.scoreDrlList = Arrays.asList(scoreDrls);
        return this;
    }

    public ScoreDirectorFactoryConfig withScoreDrlFileList(List<File> scoreDrlFileList) {
        this.scoreDrlFileList = scoreDrlFileList;
        return this;
    }

    public ScoreDirectorFactoryConfig withScoreDrlFiles(File ... scoreDrlFiles) {
        this.scoreDrlFileList = Arrays.asList(scoreDrlFiles);
        return this;
    }

    public ScoreDirectorFactoryConfig withInitializingScoreTrend(String initializingScoreTrend) {
        this.initializingScoreTrend = initializingScoreTrend;
        return this;
    }

    public ScoreDirectorFactoryConfig withAssertionScoreDirectorFactory(ScoreDirectorFactoryConfig assertionScoreDirectorFactory) {
        this.assertionScoreDirectorFactory = assertionScoreDirectorFactory;
        return this;
    }

    public ScoreDefinition buildDeprecatedScoreDefinition() {
        if (this.scoreDefinitionType != ScoreDefinitionType.BENDABLE && this.scoreDefinitionType != ScoreDefinitionType.BENDABLE_LONG && this.scoreDefinitionType != ScoreDefinitionType.BENDABLE_BIG_DECIMAL && (this.bendableHardLevelsSize != null || this.bendableSoftLevelsSize != null)) {
            throw new IllegalArgumentException("A bendableHardLevelsSize (" + this.bendableHardLevelsSize + ") or bendableSoftLevelsSize (" + this.bendableSoftLevelsSize + ") needs a scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ") that is bendable.");
        }
        if (!(this.scoreDefinitionType != ScoreDefinitionType.BENDABLE && this.scoreDefinitionType != ScoreDefinitionType.BENDABLE_LONG && this.scoreDefinitionType != ScoreDefinitionType.BENDABLE_BIG_DECIMAL || this.bendableHardLevelsSize != null && this.bendableSoftLevelsSize != null)) {
            throw new IllegalArgumentException("With scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ") there must be a bendableHardLevelsSize (" + this.bendableHardLevelsSize + ") and a bendableSoftLevelsSize (" + this.bendableSoftLevelsSize + ").");
        }
        if (this.scoreDefinitionClass != null) {
            if (this.scoreDefinitionType != null) {
                throw new IllegalArgumentException("With scoreDefinitionClass (" + this.scoreDefinitionClass + ") there must be no scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ").");
            }
            return ConfigUtils.newInstance(this, "scoreDefinitionClass", this.scoreDefinitionClass);
        }
        if (this.scoreDefinitionType != null) {
            switch (this.scoreDefinitionType) {
                case SIMPLE: {
                    return new SimpleScoreDefinition();
                }
                case SIMPLE_LONG: {
                    return new SimpleLongScoreDefinition();
                }
                case SIMPLE_DOUBLE: {
                    return new SimpleDoubleScoreDefinition();
                }
                case SIMPLE_BIG_DECIMAL: {
                    return new SimpleBigDecimalScoreDefinition();
                }
                case HARD_SOFT: {
                    return new HardSoftScoreDefinition();
                }
                case HARD_SOFT_LONG: {
                    return new HardSoftLongScoreDefinition();
                }
                case HARD_SOFT_DOUBLE: {
                    return new HardSoftDoubleScoreDefinition();
                }
                case HARD_SOFT_BIG_DECIMAL: {
                    return new HardSoftBigDecimalScoreDefinition();
                }
                case HARD_MEDIUM_SOFT: {
                    return new HardMediumSoftScoreDefinition();
                }
                case HARD_MEDIUM_SOFT_LONG: {
                    return new HardMediumSoftLongScoreDefinition();
                }
                case BENDABLE: {
                    return new BendableScoreDefinition(this.bendableHardLevelsSize, this.bendableSoftLevelsSize);
                }
                case BENDABLE_LONG: {
                    return new BendableLongScoreDefinition(this.bendableHardLevelsSize, this.bendableSoftLevelsSize);
                }
                case BENDABLE_BIG_DECIMAL: {
                    return new BendableBigDecimalScoreDefinition(this.bendableHardLevelsSize, this.bendableSoftLevelsSize);
                }
            }
            throw new IllegalStateException("The scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ") is not implemented.");
        }
        return null;
    }

    public <Solution_> InnerScoreDirectorFactory<Solution_> buildScoreDirectorFactory(SolverConfigContext configContext, ClassLoader classLoader, EnvironmentMode environmentMode, SolutionDescriptor<Solution_> solutionDescriptor) {
        AbstractScoreDirectorFactory scoreDirectorFactory;
        DroolsScoreDirectorFactory<Solution_> droolsScoreDirectorFactory;
        IncrementalScoreDirectorFactory<Solution_> incrementalScoreDirectorFactory;
        ConstraintStreamScoreDirectorFactory<Solution_> constraintStreamScoreDirectorFactory;
        EasyScoreDirectorFactory<Solution_> easyScoreDirectorFactory = this.buildEasyScoreDirectorFactory(solutionDescriptor);
        if (Stream.of(easyScoreDirectorFactory, constraintStreamScoreDirectorFactory = this.buildConstraintStreamScoreDirectorFactory(solutionDescriptor), incrementalScoreDirectorFactory = this.buildIncrementalScoreDirectorFactory(solutionDescriptor), droolsScoreDirectorFactory = this.buildDroolsScoreDirectorFactory(configContext, classLoader, solutionDescriptor)).filter(Objects::nonNull).count() > 1L) {
            ArrayList<String> scoreDirectorFactoryPropertyList = new ArrayList<String>(4);
            if (easyScoreDirectorFactory != null) {
                scoreDirectorFactoryPropertyList.add("an easyScoreCalculatorClass");
            }
            if (constraintStreamScoreDirectorFactory != null) {
                scoreDirectorFactoryPropertyList.add("a constraintProviderClass");
            }
            if (incrementalScoreDirectorFactory != null) {
                scoreDirectorFactoryPropertyList.add("an incrementalScoreCalculatorClass");
            }
            if (droolsScoreDirectorFactory != null) {
                scoreDirectorFactoryPropertyList.add("a droolsScoreDirectorFactory");
            }
            throw new IllegalArgumentException("The scoreDirectorFactory cannot have " + String.join((CharSequence)" and ", scoreDirectorFactoryPropertyList) + " together.");
        }
        if (easyScoreDirectorFactory != null) {
            scoreDirectorFactory = easyScoreDirectorFactory;
        } else if (constraintStreamScoreDirectorFactory != null) {
            scoreDirectorFactory = constraintStreamScoreDirectorFactory;
        } else if (incrementalScoreDirectorFactory != null) {
            scoreDirectorFactory = incrementalScoreDirectorFactory;
        } else if (droolsScoreDirectorFactory != null) {
            scoreDirectorFactory = droolsScoreDirectorFactory;
        } else {
            throw new IllegalArgumentException("The scoreDirectorFactory lacks a configuration for an easyScoreCalculatorClass, a constraintProviderClass, an incrementalScoreCalculatorClass or a droolsScoreDirectorFactory.");
        }
        if (this.assertionScoreDirectorFactory != null) {
            if (this.assertionScoreDirectorFactory.getAssertionScoreDirectorFactory() != null) {
                throw new IllegalArgumentException("A assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory + ") cannot have a non-null assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory.getAssertionScoreDirectorFactory() + ").");
            }
            if (this.assertionScoreDirectorFactory.getScoreDefinitionClass() != null || this.assertionScoreDirectorFactory.getScoreDefinitionType() != null) {
                throw new IllegalArgumentException("A assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory + ") must reuse the scoreDefinition of its parent. It cannot have a non-null scoreDefinition* property.");
            }
            if (environmentMode.compareTo(EnvironmentMode.FAST_ASSERT) > 0) {
                throw new IllegalArgumentException("A non-null assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory + ") requires an environmentMode (" + (Object)((Object)environmentMode) + ") of " + (Object)((Object)EnvironmentMode.FAST_ASSERT) + " or lower.");
            }
            scoreDirectorFactory.setAssertionScoreDirectorFactory(this.assertionScoreDirectorFactory.buildScoreDirectorFactory(configContext, classLoader, EnvironmentMode.NON_REPRODUCIBLE, solutionDescriptor));
        }
        scoreDirectorFactory.setInitializingScoreTrend(InitializingScoreTrend.parseTrend(this.initializingScoreTrend == null ? InitializingScoreTrendLevel.ANY.name() : this.initializingScoreTrend, solutionDescriptor.getScoreDefinition().getLevelsSize()));
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            scoreDirectorFactory.setAssertClonedSolution(true);
        }
        return scoreDirectorFactory;
    }

    protected <Solution_> EasyScoreDirectorFactory<Solution_> buildEasyScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        if (this.easyScoreCalculatorClass != null) {
            if (!EasyScoreCalculator.class.isAssignableFrom(this.easyScoreCalculatorClass)) {
                throw new IllegalArgumentException("The easyScoreCalculatorClass (" + this.easyScoreCalculatorClass + ") does not implement " + EasyScoreCalculator.class.getSimpleName() + ".");
            }
            EasyScoreCalculator easyScoreCalculator = ConfigUtils.newInstance(this, "easyScoreCalculatorClass", this.easyScoreCalculatorClass);
            ConfigUtils.applyCustomProperties(easyScoreCalculator, "easyScoreCalculatorClass", this.easyScoreCalculatorCustomProperties, "easyScoreCalculatorCustomProperties");
            return new EasyScoreDirectorFactory<Solution_>(solutionDescriptor, easyScoreCalculator);
        }
        if (this.easyScoreCalculatorCustomProperties != null) {
            throw new IllegalStateException("If there is no easyScoreCalculatorClass (" + this.easyScoreCalculatorClass + "), then there can be no easyScoreCalculatorCustomProperties (" + this.easyScoreCalculatorCustomProperties + ") either.");
        }
        return null;
    }

    protected <Solution_> ConstraintStreamScoreDirectorFactory<Solution_> buildConstraintStreamScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        if (this.constraintProviderClass != null) {
            if (!ConstraintProvider.class.isAssignableFrom(this.constraintProviderClass)) {
                throw new IllegalArgumentException("The constraintProviderClass (" + this.constraintProviderClass + ") does not implement " + ConstraintProvider.class.getSimpleName() + ".");
            }
            ConstraintProvider constraintProvider = ConfigUtils.newInstance(this, "constraintProviderClass", this.constraintProviderClass);
            ConfigUtils.applyCustomProperties(constraintProvider, "constraintProviderClass", this.constraintProviderCustomProperties, "constraintProviderCustomProperties");
            ConstraintStreamImplType constraintStreamImplType_ = (ConstraintStreamImplType)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.constraintStreamImplType), (Object)((Object)ConstraintStreamImplType.DROOLS)));
            return new ConstraintStreamScoreDirectorFactory<Solution_>(solutionDescriptor, constraintProvider, constraintStreamImplType_);
        }
        if (this.constraintProviderCustomProperties != null) {
            throw new IllegalStateException("If there is no constraintProviderClass (" + this.constraintProviderClass + "), then there can be no constraintProviderCustomProperties (" + this.constraintProviderCustomProperties + ") either.");
        }
        return null;
    }

    protected <Solution_> IncrementalScoreDirectorFactory<Solution_> buildIncrementalScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        if (this.incrementalScoreCalculatorClass != null) {
            if (!IncrementalScoreCalculator.class.isAssignableFrom(this.incrementalScoreCalculatorClass)) {
                throw new IllegalArgumentException("The incrementalScoreCalculatorClass (" + this.incrementalScoreCalculatorClass + ") does not implement " + IncrementalScoreCalculator.class.getSimpleName() + ".");
            }
            return new IncrementalScoreDirectorFactory<Solution_>(solutionDescriptor, this.incrementalScoreCalculatorClass, this.incrementalScoreCalculatorCustomProperties);
        }
        if (this.incrementalScoreCalculatorCustomProperties != null) {
            throw new IllegalStateException("If there is no incrementalScoreCalculatorClass (" + this.incrementalScoreCalculatorClass + "), then there can be no incrementalScoreCalculatorCustomProperties (" + this.incrementalScoreCalculatorCustomProperties + ") either.");
        }
        return null;
    }

    protected <Solution_> DroolsScoreDirectorFactory<Solution_> buildDroolsScoreDirectorFactory(SolverConfigContext configContext, ClassLoader classLoader, SolutionDescriptor<Solution_> solutionDescriptor) {
        boolean generateDroolsTestOnError = BooleanUtils.isTrue((Boolean)this.generateDroolsTestOnError) || Boolean.parseBoolean(System.getProperty(GENERATE_DROOLS_TEST_ON_ERROR_PROPERTY_NAME, "false"));
        KieContainer kieContainer = configContext.getKieContainer();
        if (kieContainer != null || this.ksessionName != null) {
            if (kieContainer == null) {
                throw new IllegalArgumentException("If ksessionName (" + this.ksessionName + ") is not null, then the kieContainer (" + kieContainer + ") must not be null.");
            }
            if (!ConfigUtils.isEmptyCollection(this.scoreDrlList) || !ConfigUtils.isEmptyCollection(this.scoreDrlFileList)) {
                throw new IllegalArgumentException("If kieContainer or ksessionName (" + this.ksessionName + ") is not null, then the scoreDrlList (" + this.scoreDrlList + ") and the scoreDrlFileList (" + this.scoreDrlFileList + ") must be empty.\nMaybe this is running in a kjar in kie-server, in which case the DRL's are located by the META-INF/kmodule.xml, so only ksessionName is allowed.");
            }
            if (this.kieBase != null) {
                throw new IllegalArgumentException("If kieContainer or ksessionName (" + this.ksessionName + ") is not null, then the kieBase must be null.");
            }
            if (this.kieBaseConfigurationProperties != null) {
                throw new IllegalArgumentException("If kieContainer or ksessionName (" + this.ksessionName + ") is not null, then the kieBaseConfigurationProperties (" + this.kieBaseConfigurationProperties + ") must be null.");
            }
            if (generateDroolsTestOnError) {
                return new TestGenDroolsScoreDirectorFactory<Solution_>(solutionDescriptor, kieContainer, this.ksessionName);
            }
            return new DroolsScoreDirectorFactory<Solution_>(solutionDescriptor, kieContainer, this.ksessionName);
        }
        if (this.kieBase != null) {
            if (!ConfigUtils.isEmptyCollection(this.scoreDrlList) || !ConfigUtils.isEmptyCollection(this.scoreDrlFileList)) {
                throw new IllegalArgumentException("If kieBase is not null, then the scoreDrlList (" + this.scoreDrlList + ") and the scoreDrlFileList (" + this.scoreDrlFileList + ") must be empty.");
            }
            if (this.kieBaseConfigurationProperties != null) {
                throw new IllegalArgumentException("If kieBase is not null, then the kieBaseConfigurationProperties (" + this.kieBaseConfigurationProperties + ") must be null.");
            }
            if (generateDroolsTestOnError) {
                return new TestGenDroolsScoreDirectorFactory<Solution_>(solutionDescriptor, this.kieBase, null, null);
            }
            return new DroolsScoreDirectorFactory<Solution_>(solutionDescriptor, this.kieBase);
        }
        if (!ConfigUtils.isEmptyCollection(this.scoreDrlList) || !ConfigUtils.isEmptyCollection(this.scoreDrlFileList)) {
            KieServices kieServices = KieServices.Factory.get();
            KieResources kieResources = kieServices.getResources();
            KieFileSystem kieFileSystem = kieServices.newKieFileSystem();
            if (!ConfigUtils.isEmptyCollection(this.scoreDrlList)) {
                ClassLoader actualClassLoader = classLoader != null ? classLoader : this.getClass().getClassLoader();
                for (String scoreDrl : this.scoreDrlList) {
                    if (scoreDrl == null) {
                        throw new IllegalArgumentException("The scoreDrl (" + scoreDrl + ") cannot be null.");
                    }
                    URL scoreDrlURL = actualClassLoader.getResource(scoreDrl);
                    if (scoreDrlURL == null) {
                        String errorMessage = "The scoreDrl (" + scoreDrl + ") does not exist as a classpath resource in the classLoader (" + actualClassLoader + ").";
                        if (scoreDrl.startsWith("/")) {
                            errorMessage = errorMessage + "\nAs from 6.1, a classpath resource should not start with a slash (/). A scoreDrl now adheres to ClassLoader.getResource(String). Remove the leading slash from the scoreDrl if you're upgrading from 6.0.";
                        }
                        throw new IllegalArgumentException(errorMessage);
                    }
                    kieFileSystem.write(kieResources.newClassPathResource(scoreDrl, "UTF-8", actualClassLoader));
                }
            }
            if (!ConfigUtils.isEmptyCollection(this.scoreDrlFileList)) {
                for (File scoreDrlFile : this.scoreDrlFileList) {
                    if (scoreDrlFile == null) {
                        throw new IllegalArgumentException("The scoreDrlFile (" + scoreDrlFile + ") cannot be null.");
                    }
                    if (!scoreDrlFile.exists()) {
                        throw new IllegalArgumentException("The scoreDrlFile (" + scoreDrlFile + ") does not exist.");
                    }
                    kieFileSystem.write(kieResources.newFileSystemResource(scoreDrlFile, "UTF-8"));
                }
            }
            KieModuleModel kmodel = kieServices.newKieModuleModel().setConfigurationProperty("drools.propertySpecific", PropertySpecificOption.ALLOWED.toString());
            kieFileSystem.writeKModuleXML(kmodel.toXML());
            KieBuilder kieBuilder = kieServices.newKieBuilder(kieFileSystem);
            kieBuilder.buildAll();
            Results results = kieBuilder.getResults();
            if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
                throw new IllegalStateException("There are errors in a score DRL:\n" + results);
            }
            if (results.hasMessages(new Message.Level[]{Message.Level.WARNING})) {
                logger.warn("There are warnings in a score DRL:\n{}", (Object)results);
            }
            kieContainer = kieServices.newKieContainer(kieBuilder.getKieModule().getReleaseId());
            KieBaseConfiguration kieBaseConfiguration = kieServices.newKieBaseConfiguration();
            if (this.kieBaseConfigurationProperties != null) {
                for (Map.Entry<String, String> entry : this.kieBaseConfigurationProperties.entrySet()) {
                    kieBaseConfiguration.setProperty(entry.getKey(), entry.getValue());
                }
            }
            KieBase kieBase = kieContainer.newKieBase(kieBaseConfiguration);
            if (generateDroolsTestOnError) {
                return new TestGenDroolsScoreDirectorFactory<Solution_>(solutionDescriptor, kieBase, this.scoreDrlList, this.scoreDrlFileList);
            }
            return new DroolsScoreDirectorFactory<Solution_>(solutionDescriptor, kieBase);
        }
        if (this.kieBaseConfigurationProperties != null) {
            throw new IllegalArgumentException("If kieBaseConfigurationProperties (" + this.kieBaseConfigurationProperties + ") is not null, the scoreDrlList (" + this.scoreDrlList + ") or the scoreDrlFileList (" + this.scoreDrlFileList + ") must not be empty.");
        }
        if (this.generateDroolsTestOnError != null) {
            throw new IllegalArgumentException("If generateDroolsTestOnError (" + generateDroolsTestOnError + ") is not null, the scoreDrlList (" + this.scoreDrlList + ") or the scoreDrlFileList (" + this.scoreDrlFileList + ") must not be empty.");
        }
        return null;
    }

    @Override
    public ScoreDirectorFactoryConfig inherit(ScoreDirectorFactoryConfig inheritedConfig) {
        if (this.scoreDefinitionClass == null && this.scoreDefinitionType == null && this.bendableHardLevelsSize == null && this.bendableSoftLevelsSize == null) {
            this.scoreDefinitionClass = inheritedConfig.getScoreDefinitionClass();
            this.scoreDefinitionType = inheritedConfig.getScoreDefinitionType();
            this.bendableHardLevelsSize = inheritedConfig.getBendableHardLevelsSize();
            this.bendableSoftLevelsSize = inheritedConfig.getBendableSoftLevelsSize();
        }
        this.easyScoreCalculatorClass = ConfigUtils.inheritOverwritableProperty(this.easyScoreCalculatorClass, inheritedConfig.getEasyScoreCalculatorClass());
        this.easyScoreCalculatorCustomProperties = ConfigUtils.inheritMergeableMapProperty(this.easyScoreCalculatorCustomProperties, inheritedConfig.getEasyScoreCalculatorCustomProperties());
        this.constraintProviderClass = ConfigUtils.inheritOverwritableProperty(this.constraintProviderClass, inheritedConfig.getConstraintProviderClass());
        this.constraintProviderCustomProperties = ConfigUtils.inheritMergeableMapProperty(this.constraintProviderCustomProperties, inheritedConfig.getConstraintProviderCustomProperties());
        this.constraintStreamImplType = ConfigUtils.inheritOverwritableProperty(this.constraintStreamImplType, inheritedConfig.getConstraintStreamImplType());
        this.incrementalScoreCalculatorClass = ConfigUtils.inheritOverwritableProperty(this.incrementalScoreCalculatorClass, inheritedConfig.getIncrementalScoreCalculatorClass());
        this.incrementalScoreCalculatorCustomProperties = ConfigUtils.inheritMergeableMapProperty(this.incrementalScoreCalculatorCustomProperties, inheritedConfig.getIncrementalScoreCalculatorCustomProperties());
        this.ksessionName = ConfigUtils.inheritOverwritableProperty(this.ksessionName, inheritedConfig.getKsessionName());
        this.kieBase = ConfigUtils.inheritOverwritableProperty(this.kieBase, inheritedConfig.getKieBase());
        this.scoreDrlList = ConfigUtils.inheritMergeableListProperty(this.scoreDrlList, inheritedConfig.getScoreDrlList());
        this.scoreDrlFileList = ConfigUtils.inheritMergeableListProperty(this.scoreDrlFileList, inheritedConfig.getScoreDrlFileList());
        this.kieBaseConfigurationProperties = ConfigUtils.inheritMergeableMapProperty(this.kieBaseConfigurationProperties, inheritedConfig.getKieBaseConfigurationProperties());
        this.initializingScoreTrend = ConfigUtils.inheritOverwritableProperty(this.initializingScoreTrend, inheritedConfig.getInitializingScoreTrend());
        this.assertionScoreDirectorFactory = ConfigUtils.inheritOverwritableProperty(this.assertionScoreDirectorFactory, inheritedConfig.getAssertionScoreDirectorFactory());
        this.generateDroolsTestOnError = ConfigUtils.inheritOverwritableProperty(this.generateDroolsTestOnError, inheritedConfig.isGenerateDroolsTestOnError());
        return this;
    }

    @Override
    public ScoreDirectorFactoryConfig copyConfig() {
        return new ScoreDirectorFactoryConfig().inherit(this);
    }
}

