/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.solver;

import java.util.concurrent.ThreadFactory;
import javax.xml.bind.annotation.XmlType;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType(propOrder={"parallelSolverCount", "threadFactoryClass"})
public class SolverManagerConfig
extends AbstractConfig<SolverManagerConfig> {
    public static final String PARALLEL_SOLVER_COUNT_AUTO = "AUTO";
    private static final Logger logger = LoggerFactory.getLogger(SolverManagerConfig.class);
    protected String parallelSolverCount = null;
    protected Class<? extends ThreadFactory> threadFactoryClass = null;

    public String getParallelSolverCount() {
        return this.parallelSolverCount;
    }

    public void setParallelSolverCount(String parallelSolverCount) {
        this.parallelSolverCount = parallelSolverCount;
    }

    public Class<? extends ThreadFactory> getThreadFactoryClass() {
        return this.threadFactoryClass;
    }

    public void setThreadFactoryClass(Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
    }

    public SolverManagerConfig withParallelSolverCount(String parallelSolverCount) {
        this.parallelSolverCount = parallelSolverCount;
        return this;
    }

    public SolverManagerConfig withThreadFactoryClass(Class<? extends ThreadFactory> threadFactoryClass) {
        this.threadFactoryClass = threadFactoryClass;
        return this;
    }

    public Integer resolveParallelSolverCount() {
        int availableProcessorCount = this.getAvailableProcessors();
        Integer resolvedParallelSolverCount = this.parallelSolverCount == null || this.parallelSolverCount.equals(PARALLEL_SOLVER_COUNT_AUTO) ? Integer.valueOf(this.resolveParallelSolverCountAutomatically(availableProcessorCount)) : Integer.valueOf(ConfigUtils.resolvePoolSize("parallelSolverCount", this.parallelSolverCount, PARALLEL_SOLVER_COUNT_AUTO));
        if (resolvedParallelSolverCount < 1) {
            throw new IllegalArgumentException("The parallelSolverCount (" + this.parallelSolverCount + ") resulted in a resolvedParallelSolverCount (" + resolvedParallelSolverCount + ") that is lower than 1.");
        }
        if (resolvedParallelSolverCount > availableProcessorCount) {
            logger.warn("The resolvedParallelSolverCount ({}) is higher than the availableProcessorCount ({}), which is counter-efficient.", (Object)resolvedParallelSolverCount, (Object)availableProcessorCount);
        }
        return resolvedParallelSolverCount;
    }

    protected int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    protected int resolveParallelSolverCountAutomatically(int availableProcessorCount) {
        if (availableProcessorCount < 2) {
            return 1;
        }
        return availableProcessorCount / 2;
    }

    @Override
    public SolverManagerConfig inherit(SolverManagerConfig inheritedConfig) {
        this.parallelSolverCount = ConfigUtils.inheritOverwritableProperty(this.parallelSolverCount, inheritedConfig.getParallelSolverCount());
        this.threadFactoryClass = ConfigUtils.inheritOverwritableProperty(this.threadFactoryClass, inheritedConfig.getThreadFactoryClass());
        return this;
    }

    @Override
    public SolverManagerConfig copyConfig() {
        return new SolverManagerConfig().inherit(this);
    }
}

