/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.rules;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block4;
import org.drools.model.functions.Predicate3;
import org.drools.model.view.ViewItem;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.ConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.AbstractConstraintModelJoiningNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNode;
import org.optaplanner.core.impl.score.stream.drools.common.rules.AbstractGroupByMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.AbstractRuleAssembler;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiExistenceMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiGroupBy0Map1CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiGroupBy1Map0CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiGroupBy1Map0CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiGroupBy1Map1CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiGroupBy1Map1CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiGroupBy2Map0CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiGroupBy2Map0CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiGroupBy2Map1CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiGroupBy2Map1CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiGroupBy2Map2CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.BiGroupBy2Map2CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriJoinMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniRuleAssembler;

final class BiRuleAssembler
extends AbstractRuleAssembler<BiPredicate> {
    private BiPredicate filterToApplyToLastPrimaryPattern = null;

    public BiRuleAssembler(DroolsVariableFactory variableFactory, int expectedGroupByCount, List<ViewItem> finishedExpressions, Variable aVariable, Variable bVariable, List<PatternDSL.PatternDef> primaryPatterns, Map<Integer, List<ViewItem>> dependentExpressionMap) {
        super(variableFactory, expectedGroupByCount, finishedExpressions, primaryPatterns, dependentExpressionMap, aVariable, bVariable);
    }

    @Override
    protected void addFilterToLastPrimaryPattern(BiPredicate biPredicate) {
        this.filterToApplyToLastPrimaryPattern = this.filterToApplyToLastPrimaryPattern == null ? biPredicate : this.filterToApplyToLastPrimaryPattern.and(biPredicate);
    }

    @Override
    protected AbstractRuleAssembler join(UniRuleAssembler ruleAssembler, ConstraintGraphNode joinNode) {
        return new TriJoinMutator((AbstractConstraintModelJoiningNode)joinNode).apply(this, ruleAssembler);
    }

    @Override
    protected AbstractRuleAssembler andThenExists(AbstractConstraintModelJoiningNode joiningNode, boolean shouldExist) {
        return new BiExistenceMutator(joiningNode, shouldExist).apply(this);
    }

    @Override
    protected AbstractGroupByMutator new0Map1CollectGroupByMutator(Object collector) {
        return new BiGroupBy0Map1CollectMutator((BiConstraintCollector)collector);
    }

    @Override
    protected AbstractGroupByMutator new1Map0CollectGroupByMutator(Object mapping) {
        if (this.getExpectedGroupByCount() == 1) {
            return new BiGroupBy1Map0CollectFastMutator((BiFunction)mapping);
        }
        return new BiGroupBy1Map0CollectMutator((BiFunction)mapping);
    }

    @Override
    protected AbstractGroupByMutator new1Map1CollectGroupByMutator(Object mapping, Object collector) {
        if (this.getExpectedGroupByCount() == 1) {
            return new BiGroupBy1Map1CollectFastMutator((BiFunction)mapping, (BiConstraintCollector)collector);
        }
        return new BiGroupBy1Map1CollectMutator((BiFunction)mapping, (BiConstraintCollector)collector);
    }

    @Override
    protected AbstractGroupByMutator new2Map0CollectGroupByMutator(Object mappingA, Object mappingB) {
        if (this.getExpectedGroupByCount() == 1) {
            return new BiGroupBy2Map0CollectFastMutator((BiFunction)mappingA, (BiFunction)mappingB);
        }
        return new BiGroupBy2Map0CollectMutator((BiFunction)mappingA, (BiFunction)mappingB);
    }

    @Override
    protected AbstractGroupByMutator new2Map1CollectGroupByMutator(Object mappingA, Object mappingB, Object collectorC) {
        if (this.getExpectedGroupByCount() == 1) {
            return new BiGroupBy2Map1CollectFastMutator((BiFunction)mappingA, (BiFunction)mappingB, (BiConstraintCollector)collectorC);
        }
        return new BiGroupBy2Map1CollectMutator((BiFunction)mappingA, (BiFunction)mappingB, (BiConstraintCollector)collectorC);
    }

    @Override
    protected AbstractGroupByMutator new2Map2CollectGroupByMutator(Object mappingA, Object mappingB, Object collectorC, Object collectorD) {
        if (this.getExpectedGroupByCount() == 1) {
            return new BiGroupBy2Map2CollectFastMutator((BiFunction)mappingA, (BiFunction)mappingB, (BiConstraintCollector)collectorC, (BiConstraintCollector)collectorD);
        }
        return new BiGroupBy2Map2CollectMutator((BiFunction)mappingA, (BiFunction)mappingB, (BiConstraintCollector)collectorC, (BiConstraintCollector)collectorD);
    }

    @Override
    protected ConsequenceBuilder.ValidBuilder buildConsequence(DroolsConstraint constraint, Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, Variable ... variables) {
        ConstraintConsequence consequence = constraint.getConsequence();
        switch (consequence.getMatchWeightType()) {
            case INTEGER: {
                ToIntBiFunction intMatchWeighter = (ToIntBiFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, (Variable)variables[0], (Variable)variables[1]).execute((Block4 & Serializable)(drools, scoreHolder, a, b) -> BiRuleAssembler.impactScore(constraint, (Drools)drools, (AbstractScoreHolder)scoreHolder, intMatchWeighter.applyAsInt(a, b)));
            }
            case LONG: {
                ToLongBiFunction longMatchWeighter = (ToLongBiFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, (Variable)variables[0], (Variable)variables[1]).execute((Block4 & Serializable)(drools, scoreHolder, a, b) -> BiRuleAssembler.impactScore(constraint, (Drools)drools, (AbstractScoreHolder)scoreHolder, longMatchWeighter.applyAsLong(a, b)));
            }
            case BIG_DECIMAL: {
                BiFunction bigDecimalMatchWeighter = (BiFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, (Variable)variables[0], (Variable)variables[1]).execute((Block4 & Serializable)(drools, scoreHolder, a, b) -> BiRuleAssembler.impactScore(constraint, (Drools)drools, (AbstractScoreHolder)scoreHolder, (BigDecimal)bigDecimalMatchWeighter.apply(a, b)));
            }
            case DEFAULT: {
                return DSL.on(scoreHolderGlobal, (Variable)variables[0], (Variable)variables[1]).execute((Block4 & Serializable)(drools, scoreHolder, a, b) -> BiRuleAssembler.impactScore((Drools)drools, (AbstractScoreHolder)scoreHolder));
            }
        }
        throw new UnsupportedOperationException(consequence.getMatchWeightType().toString());
    }

    @Override
    protected void applyFilterToLastPrimaryPattern() {
        if (this.filterToApplyToLastPrimaryPattern == null) {
            return;
        }
        BiPredicate predicate = this.filterToApplyToLastPrimaryPattern;
        this.getLastPrimaryPattern().expr("Filter using " + predicate, this.getVariable(0), this.getVariable(1), (Predicate3 & Serializable)(fact, a, b) -> predicate.test(a, b));
        this.filterToApplyToLastPrimaryPattern = null;
    }
}

