/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.oneOf;

import java.util.Objects;
import org.organicdesign.fp.collections.ImList;
import org.organicdesign.fp.function.Fn1;
import org.organicdesign.fp.type.RuntimeTypes;

public abstract class OneOf4<A, B, C, D> {
    private final Object item;
    private final int sel;
    private final ImList<Class> types;

    protected OneOf4(Object o, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass, int index) {
        this.types = RuntimeTypes.registerClasses(aClass, bClass, cClass, dClass);
        this.sel = index;
        this.item = o;
        if (index < 0) {
            throw new IllegalArgumentException("Selected item index must be 0-3");
        }
        if (index > 3) {
            throw new IllegalArgumentException("Selected item index must be 0-3");
        }
        if (o != null && !((Class)this.types.get(index)).isInstance(o)) {
            throw new ClassCastException("You specified index " + index + ", indicating a(n) " + ((Class)this.types.get(index)).getCanonicalName() + ", but passed a " + o.getClass().getCanonicalName());
        }
    }

    public <R> R match(Fn1<A, R> fa, Fn1<B, R> fb, Fn1<C, R> fc, Fn1<D, R> fd) {
        if (this.sel == 0) {
            return fa.apply(this.item);
        }
        if (this.sel == 1) {
            return fb.apply(this.item);
        }
        if (this.sel == 2) {
            return fc.apply(this.item);
        }
        return fd.apply(this.item);
    }

    public int hashCode() {
        return Objects.hashCode(this.item) + this.sel;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OneOf4)) {
            return false;
        }
        OneOf4 that = (OneOf4)other;
        return this.sel == that.sel && Objects.equals(this.item, that.item);
    }

    public String toString() {
        return RuntimeTypes.union2Str(this.item, this.types);
    }
}

