/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.organicdesign.fp.collections.Equator;
import org.organicdesign.fp.collections.UnmodIterable;
import org.organicdesign.fp.collections.UnmodList;
import org.organicdesign.fp.collections.UnmodListIterator;
import org.organicdesign.fp.collections.UnmodSortedIterable;

public class RangeOfInt
implements UnmodList<Integer>,
Serializable {
    private final int start;
    private final int end;
    private transient int size;
    private static final long serialVersionUID = 20160906061300L;

    @NotNull
    public static RangeOfInt of(@NotNull Number s, @NotNull Number e) {
        if (e.longValue() < s.longValue()) {
            throw new IllegalArgumentException("end of range must be >= start of range");
        }
        return new RangeOfInt(s.intValue(), e.intValue());
    }

    @NotNull
    public static RangeOfInt of(@NotNull Number e) {
        if (e.longValue() < 0L) {
            throw new IllegalArgumentException("Single argument factory can't accept a negative endpoint (it assumes start is zero and positive unit step).");
        }
        return new RangeOfInt(0, e.intValue());
    }

    private RangeOfInt(int s, int e) {
        this.start = s;
        this.end = e;
        this.size = this.end - this.start;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.size = this.end - this.start;
    }

    public boolean contains(int i) {
        return i >= this.start && i < this.end;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            return this.contains((Integer)o);
        }
        if (o instanceof Long) {
            long l = (Long)o;
            return l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE && this.contains((int)l);
        }
        if (o instanceof BigInteger) {
            try {
                return this.contains(((BigInteger)o).intValueExact());
            }
            catch (ArithmeticException ignore) {
                return false;
            }
        }
        if (o instanceof String) {
            return this.contains(Integer.valueOf((String)o));
        }
        throw new IllegalArgumentException("Don't know how to convert to a primitive int without risking accidental truncation.  Pass an Integer, Long, BigInteger, or String that parses within Integer bounds instead.");
    }

    @Override
    public Integer get(int idx) {
        if (idx >= 0 && idx < this.size) {
            return this.start + idx;
        }
        throw new IndexOutOfBoundsException("Index " + idx + " was outside the size of this range: " + this.start + " to " + this.end);
    }

    @Override
    public int indexOf(Object o) {
        int i;
        if (o instanceof Number && (i = ((Number)o).intValue()) >= this.start && i < this.end) {
            return i - this.start;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int hashCode() {
        return this.start + this.end;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RangeOfInt)) {
            return false;
        }
        RangeOfInt that = (RangeOfInt)other;
        return this.start == that.start && this.end == that.end;
    }

    @Override
    @NotNull
    public UnmodListIterator<Integer> listIterator(final int startIdx) {
        if (startIdx < 0 || startIdx > this.size) {
            throw new IndexOutOfBoundsException("Index: " + startIdx);
        }
        return new UnmodListIterator<Integer>(){
            int val;
            {
                this.val = RangeOfInt.this.start + startIdx;
            }

            @Override
            public boolean hasNext() {
                return this.val < RangeOfInt.this.end;
            }

            @Override
            public Integer next() {
                if (this.val >= RangeOfInt.this.end) {
                    throw new NoSuchElementException();
                }
                Integer t = this.val;
                ++this.val;
                return t;
            }

            @Override
            public boolean hasPrevious() {
                return this.val > RangeOfInt.this.start;
            }

            @Override
            public Integer previous() {
                if (this.val <= RangeOfInt.this.start) {
                    throw new NoSuchElementException();
                }
                --this.val;
                return this.val;
            }

            @Override
            public int nextIndex() {
                return this.val - RangeOfInt.this.start;
            }
        };
    }

    @Override
    @NotNull
    public RangeOfInt subList(int fromIndex, int toIndex) {
        if (fromIndex == 0 && toIndex == this.size) {
            return this;
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        return RangeOfInt.of(this.start + fromIndex, this.start + toIndex);
    }

    public static enum Equat implements Equator<List<Integer>>
    {
        LIST{

            @Override
            public int hash(List<Integer> integers) {
                return UnmodIterable.hash(integers);
            }

            @Override
            public boolean eq(List<Integer> o1, List<Integer> o2) {
                if (o1 == o2) {
                    return true;
                }
                if (o1 == null || o2 == null) {
                    return false;
                }
                if (o1 instanceof RangeOfInt && o2 instanceof RangeOfInt) {
                    return o1.equals(o2);
                }
                return o1.size() == o2.size() && UnmodSortedIterable.equal(UnmodSortedIterable.castFromList(o1), UnmodSortedIterable.castFromList(o2));
            }
        };

    }
}

