/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.organicdesign.fp.collections.UnmodIterable;
import org.organicdesign.fp.oneOf.Option;
import org.organicdesign.fp.oneOf.Or;
import org.organicdesign.fp.xform.Xform;

@FunctionalInterface
public interface Fn1<T, U>
extends Function<T, U>,
Consumer<T> {
    @NotNull
    public static <V> Fn1<V, V> identity() {
        return ConstObjObj.IDENTITY;
    }

    @NotNull
    public static <S> Fn1<S, Boolean> or(@NotNull Fn1<S, Boolean> a, @NotNull Fn1<S, Boolean> b) {
        return a == ConstObjBool.ACCEPT ? a : (a == ConstObjBool.REJECT ? b : (b == ConstObjBool.ACCEPT ? b : (b == ConstObjBool.REJECT ? a : s -> a.apply(s) == Boolean.TRUE || b.apply(s) == Boolean.TRUE)));
    }

    @NotNull
    public static <S> Fn1<S, Boolean> and(@NotNull Fn1<S, Boolean> a, @NotNull Fn1<S, Boolean> b) {
        return a == ConstObjBool.ACCEPT ? b : (a == ConstObjBool.REJECT ? a : (b == ConstObjBool.ACCEPT ? a : (b == ConstObjBool.REJECT ? b : s -> a.apply(s) == Boolean.TRUE && b.apply(s) == Boolean.TRUE)));
    }

    @NotNull
    public static <S> Fn1<S, Boolean> negate(@NotNull Fn1<? super S, Boolean> a) {
        return a == ConstObjBool.ACCEPT ? Fn1.reject() : (a == ConstObjBool.REJECT ? Fn1.accept() : s -> a.apply((Object)s) == Boolean.TRUE ? Boolean.FALSE : Boolean.TRUE);
    }

    @NotNull
    public static <T> Fn1<T, Boolean> accept() {
        return ConstObjBool.ACCEPT;
    }

    @NotNull
    public static <T> Fn1<T, Boolean> reject() {
        return ConstObjBool.REJECT;
    }

    @NotNull
    public static <V> Fn1<V, V> compose(@Nullable @Nullable Iterable<@Nullable Fn1<V, V>> in) {
        if (in == null) {
            return Fn1.identity();
        }
        ArrayList out = new ArrayList();
        for (Fn1<V, V> f : in) {
            if (f == null || f == ConstObjObj.IDENTITY) continue;
            out.add(f);
        }
        if (out.size() < 1) {
            return Fn1.identity();
        }
        if (out.size() == 1) {
            return (Fn1)out.get(0);
        }
        return v -> {
            Object ret = v;
            for (Fn1 f : out) {
                ret = f.applyEx(ret);
            }
            return ret;
        };
    }

    @NotNull
    public static <T> Fn1<T, Boolean> and(@Nullable @Nullable Iterable<@Nullable Fn1<T, Boolean>> in) {
        if (in == null) {
            return Fn1.accept();
        }
        Xform<Fn1<Fn1, Boolean>> v = in instanceof UnmodIterable ? (Xform<Fn1<Fn1, Boolean>>)in : Xform.of(in);
        Or<Fn1, Fn1> ret = v.filter(p -> p != null && p != ConstObjBool.ACCEPT).foldUntil(Fn1.accept(), (accum, p) -> p == Fn1.reject() ? p : null, Fn1::and);
        return ret.match(g -> g, b -> b);
    }

    @NotNull
    public static <T> Fn1<T, Boolean> or(@Nullable @Nullable Iterable<@Nullable Fn1<T, Boolean>> in) {
        if (in == null) {
            return Fn1.reject();
        }
        Xform<Fn1<Fn1, Boolean>> v = in instanceof UnmodIterable ? (Xform<Fn1<Fn1, Boolean>>)in : Xform.of(in);
        Or<Fn1, Fn1> ret = v.filter(p -> p != null && p != ConstObjBool.REJECT).foldUntil(Fn1.reject(), (accum, p) -> p == ConstObjBool.ACCEPT ? p : null, Fn1::or);
        return ret.match(g -> g, b -> b);
    }

    @NotNull
    public static <A, B> Fn1<A, B> memoize(final @NotNull Fn1<A, B> f) {
        return new Fn1<A, B>(){
            private final Map<A, Option<B>> memo = new HashMap();

            @Override
            public synchronized B applyEx(A a) throws Exception {
                Option val = this.memo.get(a);
                if (val != null && val.isSome()) {
                    return val.get();
                }
                Object ret = f.applyEx(a);
                this.memo.put(a, Option.some(ret));
                return ret;
            }
        };
    }

    public U applyEx(T var1) throws Exception;

    @Override
    default public U apply(T t) {
        try {
            return this.applyEx(t);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    default public void accept(T t) {
        this.apply(t);
    }

    @Override
    @NotNull
    default public <S> Fn1<S, U> compose(@NotNull Fn1<? super S, ? extends T> f) {
        if (f == ConstObjObj.IDENTITY) {
            return this;
        }
        Fn1 parent = this;
        return s -> parent.applyEx(f.applyEx((Object)s));
    }

    public static enum BooleanCombiner {
        AND{

            @Override
            @NotNull
            public <T> Fn1<T, Boolean> combine(Iterable<Fn1<T, Boolean>> in) {
                return Fn1.and(in);
            }
        }
        ,
        OR{

            @Override
            @NotNull
            public <T> Fn1<T, Boolean> combine(Iterable<Fn1<T, Boolean>> in) {
                return Fn1.or(in);
            }
        };


        @NotNull
        public abstract <T> Fn1<T, Boolean> combine(Iterable<Fn1<T, Boolean>> var1);
    }

    public static enum ConstObjBool implements Fn1<Object, Boolean>
    {
        ACCEPT{

            @Override
            @NotNull
            public Boolean applyEx(Object ignored) throws Exception {
                return Boolean.TRUE;
            }
        }
        ,
        REJECT{

            @Override
            @NotNull
            public Boolean applyEx(Object ignored) throws Exception {
                return Boolean.FALSE;
            }
        };

    }

    public static enum ConstObjObj implements Fn1<Object, Object>
    {
        IDENTITY{

            @Override
            public Object applyEx(Object t) throws Exception {
                return t;
            }

            @Override
            @NotNull
            public <S> Fn1<S, Object> compose(@NotNull Fn1<? super S, ? extends Object> f) {
                return f;
            }
        };

    }
}

