/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.function;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.organicdesign.fp.oneOf.Option;
import org.organicdesign.fp.tuple.Tuple3;

@FunctionalInterface
public interface Fn3<A, B, C, R> {
    public R applyEx(A var1, B var2, C var3) throws Exception;

    default public R apply(A a, B b, C c) {
        try {
            return this.applyEx(a, b, c);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static <A, B, C, Z> Fn3<A, B, C, Z> memoize(final @NotNull Fn3<A, B, C, Z> f) {
        return new Fn3<A, B, C, Z>(){
            private final Map<Tuple3<A, B, C>, Option<Z>> map = new HashMap();

            @Override
            public synchronized Z applyEx(A a, B b, C c) throws Exception {
                Tuple3 t3 = Tuple3.of(a, b, c);
                Option val = this.map.get(t3);
                if (val != null) {
                    return val.get();
                }
                Object ret = f.applyEx(a, b, c);
                this.map.put(t3, Option.some(ret));
                return ret;
            }
        };
    }
}

