/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.amf.AMF;
import org.red5.io.amf3.ByteArray;
import org.red5.io.object.BaseInput;
import org.red5.io.object.Deserializer;
import org.red5.io.object.RecordSet;
import org.red5.io.object.RecordSetPage;
import org.red5.io.utils.ObjectMap;
import org.red5.io.utils.XMLUtils;
import org.red5.server.service.ConversionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Input
extends BaseInput
implements org.red5.io.object.Input {
    protected static Logger log = LoggerFactory.getLogger(Input.class);
    protected ByteBuffer buf;
    protected byte currentDataType;

    public Input(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public byte readDataType() {
        if (this.buf != null) {
            this.currentDataType = this.buf.get();
        } else {
            log.error("Why is buf null?");
        }
        return this.readDataType(this.currentDataType);
    }

    protected byte readDataType(byte dataType) {
        byte coreType;
        switch (this.currentDataType) {
            case 5: 
            case 6: {
                coreType = 1;
                break;
            }
            case 0: {
                coreType = 3;
                break;
            }
            case 1: {
                coreType = 2;
                break;
            }
            case 2: 
            case 12: {
                coreType = 4;
                break;
            }
            case 3: 
            case 16: {
                coreType = 9;
                break;
            }
            case 8: {
                coreType = 7;
                break;
            }
            case 10: {
                coreType = 6;
                break;
            }
            case 11: {
                coreType = 5;
                break;
            }
            case 15: {
                coreType = 8;
                break;
            }
            case 7: {
                coreType = 17;
                break;
            }
            case 4: 
            case 13: 
            case 14: {
                coreType = (byte)(this.currentDataType + 48);
                break;
            }
            default: {
                coreType = 0;
            }
        }
        return coreType;
    }

    @Override
    public Object readNull() {
        return null;
    }

    @Override
    public Boolean readBoolean() {
        return this.buf.get() == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Number readNumber() {
        double num = this.buf.getDouble();
        if (num == (double)Math.round(num)) {
            if (num < 2.147483647E9) {
                return (int)num;
            }
            return Math.round(num);
        }
        return num;
    }

    @Override
    public String getString() {
        return Input.getString(this.buf);
    }

    @Override
    public String readString() {
        int len = 0;
        switch (this.currentDataType) {
            case 12: {
                len = this.buf.getInt();
                break;
            }
            case 2: {
                len = this.buf.getUnsignedShort();
                break;
            }
            default: {
                log.debug("Unknown AMF type: {}", (Object)this.currentDataType);
            }
        }
        int limit = this.buf.limit();
        java.nio.ByteBuffer strBuf = this.buf.buf();
        strBuf.limit(strBuf.position() + len);
        String string = AMF.CHARSET.decode(strBuf).toString();
        this.buf.limit(limit);
        return string;
    }

    public static String getString(ByteBuffer buf) {
        int len = buf.getUnsignedShort();
        int limit = buf.limit();
        java.nio.ByteBuffer strBuf = buf.buf();
        strBuf.limit(strBuf.position() + len);
        String string = AMF.CHARSET.decode(strBuf).toString();
        buf.limit(limit);
        return string;
    }

    @Override
    public Date readDate() {
        long ms = (long)this.buf.getDouble();
        short timeZoneMins = this.buf.getShort();
        Date date = new Date(ms);
        this.storeReference(date);
        return date;
    }

    @Override
    public Object readArray(Deserializer deserializer) {
        int count = this.buf.getInt();
        ArrayList<Object> result = new ArrayList<Object>(count);
        this.storeReference(result);
        for (int i = 0; i < count; ++i) {
            result.add(deserializer.deserialize(this, Object.class));
        }
        return result;
    }

    @Override
    public Map<String, Object> readKeyValues(Deserializer deserializer) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.readKeyValues(result, deserializer);
        return result;
    }

    protected void readKeyValues(Map<String, Object> result, Deserializer deserializer) {
        while (this.hasMoreProperties()) {
            String name = this.readPropertyName();
            log.debug("property: {}", (Object)name);
            Object property = deserializer.deserialize(this, Object.class);
            log.debug("val: {}", property);
            result.put(name, property);
            if (!this.hasMoreProperties()) continue;
            this.skipPropertySeparator();
        }
        this.skipEndObject();
    }

    @Override
    public Object readMap(Deserializer deserializer) {
        Cloneable result;
        int maxNumber = this.buf.getInt();
        log.debug("Read start mixed array: {}", (Object)maxNumber);
        LinkedHashMap<Object, Object> mixedResult = new LinkedHashMap<Object, Object>(maxNumber);
        while (this.hasMoreProperties()) {
            String key = Input.getString(this.buf);
            log.debug("key: {}", (Object)key);
            Object item = deserializer.deserialize(this, Object.class);
            log.debug("item: {}", item);
            mixedResult.put(key, item);
        }
        Object length = mixedResult.get("length");
        if (mixedResult.size() <= maxNumber + 1 && length instanceof Integer && maxNumber == (Integer)length) {
            log.debug("mixed array is a regular array");
            ArrayList listResult = new ArrayList(maxNumber);
            for (int i = 0; i < maxNumber; ++i) {
                listResult.add(i, mixedResult.get(String.valueOf(i)));
            }
            result = listResult;
        } else {
            mixedResult.remove("length");
            for (int i = 0; i < maxNumber; ++i) {
                Object value = mixedResult.remove(String.valueOf(i));
                mixedResult.put(i, value);
            }
            result = mixedResult;
        }
        this.storeReference(result);
        this.skipEndObject();
        return result;
    }

    protected Object newInstance(String className) {
        log.info("Loading class: {}", (Object)className);
        Object instance = null;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            instance = clazz.newInstance();
        }
        catch (Exception ex) {
            log.error("Error loading class: {}", (Object)className, (Object)ex);
        }
        return instance;
    }

    protected Object readBean(Deserializer deserializer, Object bean) {
        log.debug("read bean");
        this.storeReference(bean);
        Class<?> theClass = bean.getClass();
        while (this.hasMoreProperties()) {
            String name = this.readPropertyName();
            Class t = this.getPropertyType(bean, name);
            log.debug("property: {}", (Object)name);
            Object property = deserializer.deserialize(this, t);
            log.debug("val: {}", property);
            try {
                if (property != null) {
                    try {
                        Field field = theClass.getField(name);
                        if (!t.isAssignableFrom(property.getClass())) {
                            property = ConversionUtils.convert(property, t);
                        }
                        field.set(bean, property);
                    }
                    catch (Exception ex2) {
                        BeanUtils.setProperty((Object)bean, (String)name, property);
                    }
                } else {
                    log.debug("Skipping null property: {}", (Object)name);
                }
            }
            catch (Exception ex) {
                log.error("Error mapping property: {} ({})", (Object)name, property);
            }
            if (!this.hasMoreProperties()) continue;
            this.skipPropertySeparator();
        }
        this.skipEndObject();
        return bean;
    }

    protected Map<String, Object> readSimpleObject(Deserializer deserializer) {
        log.debug("read map");
        ObjectMap<String, Object> result = new ObjectMap<String, Object>();
        this.readKeyValues(result, deserializer);
        this.storeReference(result);
        return result;
    }

    @Override
    public Object readObject(Deserializer deserializer) {
        String className = this.currentDataType == 16 ? Input.getString(this.buf) : null;
        log.debug("readObject: {}", (Object)className);
        Object result = null;
        if (className != null) {
            log.debug("read class object");
            if (className.equals("RecordSet")) {
                result = new RecordSet(this);
                this.storeReference(result);
            } else if (className.equals("RecordSetPage")) {
                result = new RecordSetPage(this);
                this.storeReference(result);
            } else {
                Object instance = this.newInstance(className);
                if (instance != null) {
                    result = this.readBean(deserializer, instance);
                }
            }
        } else {
            result = this.readSimpleObject(deserializer);
        }
        return result;
    }

    public boolean hasMoreProperties() {
        byte pad = 0;
        byte pad0 = this.buf.get();
        byte pad1 = this.buf.get();
        byte type = this.buf.get();
        boolean isEndOfObject = pad0 == pad && pad1 == pad && type == 9;
        log.debug("End of object: ? {}", (Object)isEndOfObject);
        this.buf.position(this.buf.position() - 3);
        return !isEndOfObject;
    }

    public String readPropertyName() {
        return Input.getString(this.buf);
    }

    public void skipPropertySeparator() {
    }

    public void skipEndObject() {
        this.buf.skip(3);
    }

    @Override
    public Document readXML() {
        String xmlString = this.readString();
        Document doc = null;
        try {
            doc = XMLUtils.stringToDoc(xmlString);
        }
        catch (IOException ioex) {
            log.error("IOException converting xml to dom", (Throwable)ioex);
        }
        this.storeReference(doc);
        return doc;
    }

    @Override
    public Object readCustom() {
        return null;
    }

    @Override
    public ByteArray readByteArray() {
        throw new RuntimeException("ByteArray objects not supported with AMF0");
    }

    @Override
    public Object readReference() {
        if (this.referenceMode == BaseInput.ReferenceMode.MODE_RTMP) {
            return this.getReference(this.buf.getUnsignedShort() - 1);
        }
        return this.getReference(this.buf.getUnsignedShort());
    }

    public void reset(BaseInput.ReferenceMode mode) {
        this.clearReferences();
        this.referenceMode = mode;
    }

    public void reset() {
        this.reset(BaseInput.ReferenceMode.MODE_RTMP);
    }

    protected Class getPropertyType(Object instance, String propertyName) {
        try {
            if (instance != null) {
                Field field = instance.getClass().getField(propertyName);
                return field.getType();
            }
        }
        catch (NoSuchFieldException e1) {
            try {
                BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
                PropertyUtilsBean propertyUtils = beanUtilsBean.getPropertyUtils();
                return propertyUtils.getPropertyType(instance, propertyName);
            }
            catch (Exception e2) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Object.class;
    }
}

