/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf3;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.amf3.DataInput;
import org.red5.io.amf3.DataOutput;
import org.red5.io.amf3.IDataInput;
import org.red5.io.amf3.IDataOutput;
import org.red5.io.amf3.Input;
import org.red5.io.amf3.Output;
import org.red5.io.object.Deserializer;
import org.red5.io.object.Serializer;

public class ByteArray
implements IDataInput,
IDataOutput {
    protected ByteBuffer data;
    protected IDataInput dataInput;
    protected IDataOutput dataOutput;

    protected ByteArray(ByteBuffer buffer, int length) {
        this.data = ByteBuffer.allocate((int)length);
        this.data.setAutoExpand(true);
        byte[] tmp = new byte[length];
        buffer.get(tmp);
        this.data.put(tmp);
        this.data.flip();
        this.prepareIO();
    }

    public ByteArray() {
        this.data = ByteBuffer.allocate((int)0);
        this.data.setAutoExpand(true);
        this.prepareIO();
    }

    protected void prepareIO() {
        this.dataInput = new DataInput(new Input(this.data), new Deserializer());
        this.dataOutput = new DataOutput(new Output(this.data), new Serializer());
    }

    protected ByteBuffer getData() {
        return this.data;
    }

    public int position() {
        return this.data.position();
    }

    public void position(int position) {
        this.data.position(position);
    }

    public int bytesAvailable() {
        return this.length() - this.position();
    }

    public int length() {
        return this.data.limit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int old = this.data.position();
        try {
            this.data.position(0);
            String string = this.data.asCharBuffer().toString();
            return string;
        }
        finally {
            this.data.position(old);
        }
    }

    public void compress() {
        ByteBuffer tmp = ByteBuffer.allocate((int)0);
        tmp.setAutoExpand(true);
        DeflaterOutputStream deflater = new DeflaterOutputStream(tmp.asOutputStream(), new Deflater(9));
        byte[] tmpData = new byte[this.data.limit()];
        this.data.position(0);
        this.data.get(tmpData);
        try {
            deflater.write(tmpData);
            deflater.finish();
        }
        catch (IOException e) {
            tmp.release();
            throw new RuntimeException("could not compress data", e);
        }
        this.data.release();
        this.data = tmp;
        this.data.flip();
        this.prepareIO();
    }

    public void uncompress() {
        this.data.position(0);
        InflaterInputStream inflater = new InflaterInputStream(this.data.asInputStream());
        byte[] buffer = new byte[8192];
        ByteBuffer tmp = ByteBuffer.allocate((int)0);
        tmp.setAutoExpand(true);
        try {
            int decompressed;
            while (inflater.available() > 0 && (decompressed = inflater.read(buffer)) > 0) {
                tmp.put(buffer, 0, decompressed);
            }
        }
        catch (IOException e) {
            tmp.release();
            throw new RuntimeException("could not uncompress data", e);
        }
        this.data.release();
        this.data = tmp;
        this.data.flip();
        this.prepareIO();
    }

    public ByteOrder getEndian() {
        return this.dataInput.getEndian();
    }

    public boolean readBoolean() {
        return this.dataInput.readBoolean();
    }

    public byte readByte() {
        return this.dataInput.readByte();
    }

    public void readBytes(byte[] bytes) {
        this.dataInput.readBytes(bytes);
    }

    public void readBytes(byte[] bytes, int offset) {
        this.dataInput.readBytes(bytes, offset);
    }

    public void readBytes(byte[] bytes, int offset, int length) {
        this.dataInput.readBytes(bytes, offset, length);
    }

    public double readDouble() {
        return this.dataInput.readDouble();
    }

    public float readFloat() {
        return this.dataInput.readFloat();
    }

    public int readInt() {
        return this.dataInput.readInt();
    }

    public String readMultiByte(int length, String charSet) {
        return this.dataInput.readMultiByte(length, charSet);
    }

    public Object readObject() {
        return this.dataInput.readObject();
    }

    public short readShort() {
        return this.dataInput.readShort();
    }

    public String readUTF() {
        return this.dataInput.readUTF();
    }

    public String readUTFBytes(int length) {
        return this.dataInput.readUTFBytes(length);
    }

    public int readUnsignedByte() {
        return this.dataInput.readUnsignedByte();
    }

    public long readUnsignedInt() {
        return this.dataInput.readUnsignedInt();
    }

    public int readUnsignedShort() {
        return this.dataInput.readUnsignedShort();
    }

    public void setEndian(ByteOrder endian) {
        this.dataInput.setEndian(endian);
        this.dataOutput.setEndian(endian);
    }

    public void writeBoolean(boolean value) {
        this.dataOutput.writeBoolean(value);
    }

    public void writeByte(byte value) {
        this.dataOutput.writeByte(value);
    }

    public void writeBytes(byte[] bytes) {
        this.dataOutput.writeBytes(bytes);
    }

    public void writeBytes(byte[] bytes, int offset) {
        this.dataOutput.writeBytes(bytes, offset);
    }

    public void writeBytes(byte[] bytes, int offset, int length) {
        this.dataOutput.writeBytes(bytes, offset, length);
    }

    public void writeDouble(double value) {
        this.dataOutput.writeDouble(value);
    }

    public void writeFloat(float value) {
        this.dataOutput.writeFloat(value);
    }

    public void writeInt(int value) {
        this.dataOutput.writeInt(value);
    }

    public void writeMultiByte(String value, String encoding) {
        this.dataOutput.writeMultiByte(value, encoding);
    }

    public void writeObject(Object value) {
        this.dataOutput.writeObject(value);
    }

    public void writeShort(short value) {
        this.dataOutput.writeShort(value);
    }

    public void writeUTF(String value) {
        this.dataOutput.writeUTF(value);
    }

    public void writeUTFBytes(String value) {
        this.dataOutput.writeUTFBytes(value);
    }

    public void writeUnsignedInt(long value) {
        this.dataOutput.writeUnsignedInt(value);
    }
}

