/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf3;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.amf3.AMF3;
import org.red5.io.amf3.ByteArray;
import org.red5.io.amf3.DataInput;
import org.red5.io.amf3.IExternalizable;
import org.red5.io.object.Deserializer;
import org.red5.io.utils.ObjectMap;
import org.red5.io.utils.XMLUtils;
import org.red5.server.service.ConversionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Input
extends org.red5.io.amf.Input
implements org.red5.io.object.Input {
    protected static Logger log = LoggerFactory.getLogger(Input.class);
    private int amf3_mode = 0;
    private List<String> stringReferences = new ArrayList<String>();
    private List<ClassReference> classReferences = new ArrayList<ClassReference>();

    public Input(ByteBuffer buf) {
        super(buf);
    }

    protected ByteBuffer getBuffer() {
        return this.buf;
    }

    public byte readDataType() {
        byte coreType;
        if (this.buf == null) {
            log.error("Why is buf null?");
        }
        this.currentDataType = this.buf.get();
        if (this.currentDataType == 17) {
            this.currentDataType = this.buf.get();
        } else if (this.amf3_mode == 0) {
            return this.readDataType(this.currentDataType);
        }
        switch (this.currentDataType) {
            case 1: {
                coreType = 1;
                break;
            }
            case 4: 
            case 5: {
                coreType = 3;
                break;
            }
            case 2: 
            case 3: {
                coreType = 2;
                break;
            }
            case 6: {
                coreType = 4;
                break;
            }
            case 7: 
            case 11: {
                coreType = 8;
                break;
            }
            case 10: {
                coreType = 9;
                break;
            }
            case 9: {
                coreType = 6;
                break;
            }
            case 8: {
                coreType = 5;
                break;
            }
            case 12: {
                coreType = 16;
                break;
            }
            default: {
                log.info("Unknown datatype: {}", (Object)this.currentDataType);
                coreType = 0;
            }
        }
        return coreType;
    }

    public Object readNull() {
        return null;
    }

    public Boolean readBoolean() {
        return this.currentDataType == 3 ? Boolean.TRUE : Boolean.FALSE;
    }

    public Number readNumber() {
        if (this.currentDataType == 5) {
            return this.buf.getDouble();
        }
        return this.readAMF3Integer();
    }

    public String readString() {
        int len = this.readAMF3Integer();
        if (len == 1) {
            return "";
        }
        if ((len & 1) == 0) {
            return this.stringReferences.get(len >> 1);
        }
        int limit = this.buf.limit();
        java.nio.ByteBuffer strBuf = this.buf.buf();
        strBuf.limit(strBuf.position() + (len >>= 1));
        String string = AMF3.CHARSET.decode(strBuf).toString();
        this.buf.limit(limit);
        this.stringReferences.add(string);
        return string;
    }

    public String getString() {
        return this.readString();
    }

    public Date readDate() {
        int ref = this.readAMF3Integer();
        if ((ref & 1) == 0) {
            return (Date)this.getReference(ref >> 1);
        }
        long ms = (long)this.buf.getDouble();
        Date date = new Date(ms);
        this.storeReference(date);
        return date;
    }

    public Object readArray(Deserializer deserializer) {
        Cloneable result;
        int count = this.readAMF3Integer();
        if ((count & 1) == 0) {
            return this.getReference(count >> 1);
        }
        count >>= 1;
        String key = this.readString();
        ++this.amf3_mode;
        if (key.equals("")) {
            ArrayList<Object> resultList = new ArrayList<Object>(count);
            this.storeReference(resultList);
            for (int i = 0; i < count; ++i) {
                Object value = deserializer.deserialize(this, Object.class);
                resultList.add(value);
            }
            result = resultList;
        } else {
            HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
            this.storeReference(resultMap);
            while (!key.equals("")) {
                Object value = deserializer.deserialize(this, Object.class);
                resultMap.put(key, value);
                key = this.readString();
            }
            for (int i = 0; i < count; ++i) {
                Object value = deserializer.deserialize(this, Object.class);
                resultMap.put(i, value);
            }
            result = resultMap;
        }
        --this.amf3_mode;
        return result;
    }

    public Object readMap(Deserializer deserializer) {
        throw new RuntimeException("AMF3 doesn't support maps.");
    }

    /*
     * WARNING - void declaration
     */
    public Object readObject(Deserializer deserializer) {
        String className;
        boolean inlineClass;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            return this.getReference(type >> 1);
        }
        List<String> attributes = null;
        Object result = null;
        boolean bl = inlineClass = ((type >>= 1) & 1) == 1;
        if (!inlineClass) {
            ClassReference info = this.classReferences.get(type >> 1);
            className = info.className;
            attributes = info.attributeNames;
            type = info.type;
            if (attributes != null) {
                type |= attributes.size() << 2;
            }
        } else {
            type >>= 1;
            className = this.readString();
        }
        ++this.amf3_mode;
        Object instance = this.newInstance(className);
        ObjectMap properties = null;
        PendingObject pending = new PendingObject();
        int tempRefId = this.storeReference(pending);
        switch (type & 3) {
            case 0: {
                void var12_17;
                int count = type >> 2;
                properties = new ObjectMap();
                if (attributes == null) {
                    void var12_15;
                    attributes = new ArrayList<String>(count);
                    boolean bl2 = false;
                    while (var12_15 < count) {
                        attributes.add(this.readString());
                        ++var12_15;
                    }
                    this.classReferences.add(new ClassReference(className, 0, attributes));
                }
                boolean bl3 = false;
                while (var12_17 < count) {
                    String name = attributes.get((int)var12_17);
                    properties.put(name, deserializer.deserialize(this, this.getPropertyType(instance, name)));
                    ++var12_17;
                }
                break;
            }
            case 1: {
                if ("".equals(className)) {
                    throw new RuntimeException("need a classname to load an externalizable object");
                }
                result = this.newInstance(className);
                if (result == null) {
                    throw new RuntimeException("could not instantiate class");
                }
                if (!(result instanceof IExternalizable)) {
                    throw new RuntimeException("the class must implement the IExternalizable interface");
                }
                this.classReferences.add(new ClassReference(className, 1, null));
                this.storeReference(tempRefId, result);
                ((IExternalizable)result).readExternal(new DataInput(this, deserializer));
                break;
            }
            case 2: {
                void var12_19;
                this.classReferences.add(new ClassReference(className, 2, null));
                properties = new ObjectMap();
                attributes = new LinkedList<String>();
                String string = this.readString();
                while (!"".equals(var12_19)) {
                    attributes.add((String)var12_19);
                    Object value = deserializer.deserialize(this, this.getPropertyType(instance, (String)var12_19));
                    properties.put(var12_19, value);
                    String string2 = this.readString();
                }
                break;
            }
            default: {
                if ("".equals(className)) {
                    throw new RuntimeException("need a classname to load an externalizable object");
                }
                result = this.newInstance(className);
                if (result == null) {
                    throw new RuntimeException("could not instantiate class");
                }
                if (!(result instanceof IExternalizable)) {
                    throw new RuntimeException("the class must implement the IExternalizable interface");
                }
                this.classReferences.add(new ClassReference(className, 3, null));
                this.storeReference(tempRefId, result);
                ((IExternalizable)result).readExternal(new DataInput(this, deserializer));
            }
        }
        --this.amf3_mode;
        if (result == null) {
            if ("".equals(className)) {
                for (Map.Entry entry : properties.entrySet()) {
                    if (entry.getValue() != pending) continue;
                    entry.setValue(properties);
                }
                this.storeReference(tempRefId, properties);
                result = properties;
            } else {
                if ("RecordSet".equals(className)) {
                    throw new RuntimeException("Objects of type RecordSet not supported yet.");
                }
                if ("RecordSetPage".equals(className)) {
                    throw new RuntimeException("Objects of type RecordSetPage not supported yet.");
                }
                result = this.newInstance(className);
                if (result != null) {
                    this.storeReference(tempRefId, result);
                    Class<?> resultClass = result.getClass();
                    pending.resolveProperties(result);
                    for (Map.Entry entry : properties.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (value == pending) {
                            value = result;
                        }
                        if (value instanceof PendingObject) {
                            ((PendingObject)value).addPendingProperty(result, resultClass, key);
                            continue;
                        }
                        try {
                            try {
                                Field field = resultClass.getField(key);
                                Class<?> fieldType = field.getType();
                                if (!fieldType.isAssignableFrom(value.getClass())) {
                                    value = ConversionUtils.convert(value, fieldType);
                                }
                                field.set(result, value);
                            }
                            catch (Exception e) {
                                BeanUtils.setProperty(result, (String)key, value);
                            }
                        }
                        catch (Exception e) {
                            log.error("Error mapping property: {} ({})", (Object)key, value);
                        }
                    }
                }
            }
        }
        return result;
    }

    public ByteArray readByteArray() {
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            return (ByteArray)this.getReference(type >> 1);
        }
        ByteArray result = new ByteArray(this.buf, type >>= 1);
        this.storeReference(result);
        return result;
    }

    public Object readCustom() {
        return null;
    }

    public Object readReference() {
        throw new RuntimeException("AMF3 doesn't support direct references.");
    }

    public void reset() {
        super.reset();
        this.stringReferences.clear();
    }

    private int readAMF3Integer() {
        int n;
        byte b = this.buf.get();
        int result = 0;
        for (n = 0; (b & 0x80) != 0 && n < 3; ++n) {
            result <<= 7;
            result |= b & 0x7F;
            b = this.buf.get();
        }
        if (n < 3) {
            result <<= 7;
            result |= b;
        } else {
            result <<= 8;
            if (((result |= b) & 0x10000000) != 0) {
                result |= 0xE0000000;
            }
        }
        return result;
    }

    protected Object newInstance(String className) {
        log.debug("newInstance {}", (Object)className);
        if (className.startsWith("flex.")) {
            className = "org.red5.compatibility." + className;
        }
        return super.newInstance(className);
    }

    public Document readXML() {
        int len = this.readAMF3Integer();
        if (len == 1) {
            return null;
        }
        if ((len & 1) == 0) {
            return (Document)this.getReference(len >> 1);
        }
        int limit = this.buf.limit();
        java.nio.ByteBuffer strBuf = this.buf.buf();
        strBuf.limit(strBuf.position() + (len >>= 1));
        String xmlString = AMF3.CHARSET.decode(strBuf).toString();
        this.buf.limit(limit);
        Document doc = null;
        try {
            doc = XMLUtils.stringToDoc(xmlString);
        }
        catch (IOException ioex) {
            log.error("IOException converting xml to dom", (Throwable)ioex);
        }
        this.storeReference(doc);
        return doc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PendingObject {
        private List<PendingProperty> properties;

        protected PendingObject() {
        }

        public void addPendingProperty(Object obj, Class<?> klass, String name) {
            if (this.properties == null) {
                this.properties = new ArrayList<PendingProperty>();
            }
            this.properties.add(new PendingProperty(obj, klass, name));
        }

        public void resolveProperties(Object result) {
            if (this.properties == null) {
                return;
            }
            for (PendingProperty prop : this.properties) {
                try {
                    try {
                        prop.klass.getField(prop.name).set(prop.obj, result);
                    }
                    catch (Exception e) {
                        BeanUtils.setProperty((Object)prop.obj, (String)prop.name, (Object)result);
                    }
                }
                catch (Exception e) {
                    log.error("Error mapping property: {} ({})", (Object)prop.name, result);
                }
            }
            this.properties.clear();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PendingProperty {
            Object obj;
            Class<?> klass;
            String name;

            PendingProperty(Object obj, Class<?> klass, String name) {
                this.obj = obj;
                this.klass = klass;
                this.name = name;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassReference {
        protected String className;
        protected int type;
        protected List<String> attributeNames;

        public ClassReference(String className, int type, List<String> attributeNames) {
            this.className = className;
            this.type = type;
            this.attributeNames = attributeNames;
        }
    }
}

