/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.flv.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.BufferType;
import org.red5.io.IKeyFrameMetaCache;
import org.red5.io.IStreamableFile;
import org.red5.io.ITag;
import org.red5.io.ITagReader;
import org.red5.io.IoConstants;
import org.red5.io.amf.Output;
import org.red5.io.flv.FLVHeader;
import org.red5.io.flv.IKeyFrameDataAnalyzer;
import org.red5.io.flv.impl.Tag;
import org.red5.io.object.Serializer;
import org.red5.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLVReader
implements IoConstants,
ITagReader,
IKeyFrameDataAnalyzer {
    private static Logger log = LoggerFactory.getLogger(FLVReader.class);
    private File file;
    private FileInputStream fis;
    private FileChannel channel;
    private long channelSize;
    private IKeyFrameDataAnalyzer.KeyFrameMeta keyframeMeta;
    private ByteBuffer in;
    private boolean generateMetadata;
    private long firstVideoTag = -1L;
    private long firstAudioTag = -1L;
    private int tagPosition;
    private long duration;
    private HashMap<Long, Long> posTimeMap;
    private HashMap<Long, Integer> posTagMap;
    private static BufferType bufferType = BufferType.AUTO;
    private static int bufferSize = 1024;
    private boolean useLoadBuf;
    private static IKeyFrameMetaCache keyframeCache;
    private FLVHeader header;

    FLVReader() {
    }

    public FLVReader(File f) throws IOException {
        this(f, false);
    }

    public FLVReader(File f, boolean generateMetadata) throws IOException {
        if (null == f) {
            log.warn("Reader was passed a null file");
            log.debug("{}", (Object)ToStringBuilder.reflectionToString((Object)this));
        }
        this.file = f;
        this.fis = new FileInputStream(f);
        this.generateMetadata = generateMetadata;
        this.channel = this.fis.getChannel();
        this.channelSize = this.channel.size();
        this.in = null;
        this.fillBuffer();
        this.postInitialize();
    }

    public FLVReader(ByteBuffer buffer, boolean generateMetadata) {
        this.generateMetadata = generateMetadata;
        this.in = buffer;
        this.postInitialize();
    }

    public void setKeyFrameCache(IKeyFrameMetaCache keyframeCache) {
        FLVReader.keyframeCache = keyframeCache;
    }

    private long getRemainingBytes() {
        if (!this.useLoadBuf) {
            return this.in.remaining();
        }
        try {
            return this.channelSize - this.channel.position() + (long)this.in.remaining();
        }
        catch (Exception e) {
            log.error("Error getRemainingBytes", (Throwable)e);
            return 0L;
        }
    }

    private long getTotalBytes() {
        if (!this.useLoadBuf) {
            return this.in.capacity();
        }
        try {
            return this.channelSize;
        }
        catch (Exception e) {
            log.error("Error getTotalBytes", (Throwable)e);
            return 0L;
        }
    }

    private long getCurrentPosition() {
        if (!this.useLoadBuf) {
            return this.in.position();
        }
        try {
            long pos = this.in != null ? this.channel.position() - (long)this.in.remaining() : this.channel.position();
            return pos;
        }
        catch (Exception e) {
            log.error("Error getCurrentPosition", (Throwable)e);
            return 0L;
        }
    }

    private void setCurrentPosition(long pos) {
        if (pos == Long.MAX_VALUE) {
            pos = this.file.length();
        }
        if (!this.useLoadBuf) {
            this.in.position((int)pos);
            return;
        }
        try {
            if (pos >= this.channel.position() - (long)this.in.limit() && pos < this.channel.position()) {
                this.in.position((int)(pos - (this.channel.position() - (long)this.in.limit())));
            } else {
                this.channel.position(pos);
                this.fillBuffer(bufferSize, true);
            }
        }
        catch (Exception e) {
            log.error("Error setCurrentPosition", (Throwable)e);
        }
    }

    private void fillBuffer() {
        this.fillBuffer(bufferSize, false);
    }

    private void fillBuffer(long amount) {
        this.fillBuffer(amount, false);
    }

    private void fillBuffer(long amount, boolean reload) {
        try {
            if (amount > (long)bufferSize) {
                amount = bufferSize;
            }
            if (this.channelSize - this.channel.position() < amount) {
                amount = this.channelSize - this.channel.position();
            }
            if (this.in == null) {
                switch (bufferType) {
                    case HEAP: {
                        this.in = ByteBuffer.allocate((int)bufferSize, (boolean)false);
                        break;
                    }
                    case DIRECT: {
                        this.in = ByteBuffer.allocate((int)bufferSize, (boolean)true);
                        break;
                    }
                    case AUTO: {
                        this.in = ByteBuffer.allocate((int)bufferSize);
                        break;
                    }
                    default: {
                        this.in = ByteBuffer.allocate((int)bufferSize);
                    }
                }
                this.channel.read(this.in.buf());
                this.in.flip();
                this.useLoadBuf = true;
            }
            if (!this.useLoadBuf) {
                return;
            }
            if (reload || (long)this.in.remaining() < amount) {
                if (!reload) {
                    this.in.compact();
                } else {
                    this.in.clear();
                }
                this.channel.read(this.in.buf());
                this.in.flip();
            }
        }
        catch (Exception e) {
            log.error("Error fillBuffer", (Throwable)e);
        }
    }

    private void postInitialize() {
        Object tag = null;
        if (log.isDebugEnabled()) {
            log.debug("FLVReader 1 - Buffer size: " + this.getTotalBytes() + " position: " + this.getCurrentPosition() + " remaining: " + this.getRemainingBytes());
        }
        if (this.getRemainingBytes() >= 9L) {
            this.decodeHeader();
        }
        this.keyframeMeta = this.analyzeKeyFrames();
        long old = this.getCurrentPosition();
    }

    public boolean hasVideo() {
        IKeyFrameDataAnalyzer.KeyFrameMeta meta = this.analyzeKeyFrames();
        if (meta == null) {
            return false;
        }
        return !meta.audioOnly && meta.positions.length > 0;
    }

    public static String getBufferType() {
        switch (bufferType) {
            case AUTO: {
                return "auto";
            }
            case DIRECT: {
                return "direct";
            }
            case HEAP: {
                return "heap";
            }
        }
        return null;
    }

    public static void setBufferType(String bufferType) {
        int bufferTypeHash = bufferType.hashCode();
        switch (bufferTypeHash) {
            case 3198444: {
                FLVReader.bufferType = BufferType.HEAP;
                break;
            }
            case -1331586071: {
                FLVReader.bufferType = BufferType.DIRECT;
                break;
            }
            default: {
                FLVReader.bufferType = BufferType.AUTO;
            }
        }
    }

    public static int getBufferSize() {
        return bufferSize;
    }

    public static void setBufferSize(int bufferSize) {
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        FLVReader.bufferSize = bufferSize;
    }

    public ByteBuffer getFileData() {
        return null;
    }

    public void decodeHeader() {
        this.fillBuffer(9L);
        this.header = new FLVHeader();
        this.in.skip(3);
        this.header.setVersion(this.in.get());
        this.header.setTypeFlags(this.in.get());
        this.header.setDataOffset(this.in.getInt());
        if (log.isDebugEnabled()) {
            log.debug("Header: " + this.header.toString());
        }
    }

    public IStreamableFile getFile() {
        return null;
    }

    public int getOffset() {
        return 0;
    }

    public long getBytesRead() {
        return this.getCurrentPosition();
    }

    public long getDuration() {
        return this.duration;
    }

    public int getVideoCodecId() {
        IKeyFrameDataAnalyzer.KeyFrameMeta meta = this.analyzeKeyFrames();
        if (meta == null) {
            return -1;
        }
        long old = this.getCurrentPosition();
        this.setCurrentPosition(this.firstVideoTag);
        this.readTagHeader();
        this.fillBuffer(1L);
        byte frametype = this.in.get();
        this.setCurrentPosition(old);
        return frametype & 0xF;
    }

    public int getAudioCodecId() {
        IKeyFrameDataAnalyzer.KeyFrameMeta meta = this.analyzeKeyFrames();
        if (meta == null) {
            return -1;
        }
        long old = this.getCurrentPosition();
        this.setCurrentPosition(this.firstAudioTag);
        this.readTagHeader();
        this.fillBuffer(1L);
        byte frametype = this.in.get();
        this.setCurrentPosition(old);
        return frametype & 0xFFFFFFF1;
    }

    public boolean hasMoreTags() {
        return this.getRemainingBytes() > 4L;
    }

    private ITag createFileMeta() {
        byte frametype;
        long old;
        ByteBuffer buf = ByteBuffer.allocate((int)1024);
        buf.setAutoExpand(true);
        Output out = new Output(buf);
        out.writeString("onMetaData");
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        props.put("duration", (double)this.duration / 1000.0);
        if (this.firstVideoTag != -1L) {
            old = this.getCurrentPosition();
            this.setCurrentPosition(this.firstVideoTag);
            this.readTagHeader();
            this.fillBuffer(1L);
            frametype = this.in.get();
            props.put("videocodecid", frametype & 0xF);
            this.setCurrentPosition(old);
        }
        if (this.firstAudioTag != -1L) {
            old = this.getCurrentPosition();
            this.setCurrentPosition(this.firstAudioTag);
            this.readTagHeader();
            this.fillBuffer(1L);
            frametype = this.in.get();
            props.put("audiocodecid", (frametype & 0xFFFFFFF1) >> 4);
            this.setCurrentPosition(old);
        }
        props.put("canSeekToEnd", true);
        out.writeMap(props, new Serializer());
        buf.flip();
        Tag result = new Tag(18, 0, buf.limit(), null, 0);
        result.setBody(buf);
        return result;
    }

    public synchronized ITag readTag() {
        long oldPos = this.getCurrentPosition();
        ITag tag = this.readTagHeader();
        if (this.tagPosition == 0 && tag.getDataType() != 18 && this.generateMetadata) {
            this.setCurrentPosition(oldPos);
            IKeyFrameDataAnalyzer.KeyFrameMeta meta = this.analyzeKeyFrames();
            ++this.tagPosition;
            if (meta != null) {
                return this.createFileMeta();
            }
        }
        ByteBuffer body = ByteBuffer.allocate((int)tag.getBodySize(), (boolean)false);
        long newPosition = this.getCurrentPosition() + (long)tag.getBodySize();
        if (newPosition <= this.getTotalBytes()) {
            while (this.getCurrentPosition() < newPosition) {
                this.fillBuffer(newPosition - this.getCurrentPosition());
                if (this.getCurrentPosition() + (long)this.in.remaining() > newPosition) {
                    int limit = this.in.limit();
                    this.in.limit((int)(newPosition - this.getCurrentPosition()) + this.in.position());
                    body.put(this.in);
                    this.in.limit(limit);
                    continue;
                }
                body.put(this.in);
            }
            body.flip();
            tag.setBody(body);
            ++this.tagPosition;
        }
        return tag;
    }

    public void close() {
        log.debug("Reader close");
        if (this.in != null) {
            this.in.release();
            this.in = null;
        }
        if (this.channel != null) {
            try {
                this.channel.close();
                this.fis.close();
            }
            catch (IOException e) {
                log.error("FLVReader :: close ::>\n", (Throwable)e);
            }
        }
    }

    public synchronized IKeyFrameDataAnalyzer.KeyFrameMeta analyzeKeyFrames() {
        if (this.keyframeMeta != null) {
            return this.keyframeMeta;
        }
        if (keyframeCache != null) {
            this.keyframeMeta = keyframeCache.loadKeyFrameMeta(this.file);
            if (this.keyframeMeta != null) {
                this.duration = this.keyframeMeta.duration;
                this.posTimeMap = new HashMap();
                for (int i = 0; i < this.keyframeMeta.positions.length; ++i) {
                    this.posTimeMap.put(this.keyframeMeta.positions[i], Long.valueOf(this.keyframeMeta.timestamps[i]));
                }
                this.posTagMap = new HashMap();
                this.posTagMap.put(0L, 0);
                return this.keyframeMeta;
            }
        }
        ArrayList<Long> positionList = new ArrayList<Long>();
        ArrayList<Integer> timestampList = new ArrayList<Integer>();
        ArrayList<Long> audioPositionList = new ArrayList<Long>();
        ArrayList<Integer> audioTimestampList = new ArrayList<Integer>();
        long origPos = this.getCurrentPosition();
        this.setCurrentPosition(9L);
        this.posTagMap = new HashMap();
        int idx = 0;
        boolean audioOnly = true;
        while (this.hasMoreTags()) {
            long pos = this.getCurrentPosition();
            this.posTagMap.put(pos, idx++);
            ITag tmpTag = this.readTagHeader();
            this.duration = tmpTag.getTimestamp();
            if (tmpTag.getDataType() == 9) {
                if (audioOnly) {
                    audioOnly = false;
                    audioPositionList.clear();
                    audioTimestampList.clear();
                }
                if (this.firstVideoTag == -1L) {
                    this.firstVideoTag = pos;
                }
                this.fillBuffer(1L);
                byte frametype = this.in.get();
                if ((frametype & 0xFFFFFFF1) >> 4 == 1) {
                    positionList.add(pos);
                    timestampList.add(tmpTag.getTimestamp());
                }
            } else if (tmpTag.getDataType() == 8) {
                if (this.firstAudioTag == -1L) {
                    this.firstAudioTag = pos;
                }
                if (audioOnly) {
                    audioPositionList.add(pos);
                    audioTimestampList.add(tmpTag.getTimestamp());
                }
            }
            long newPosition = pos + (long)tmpTag.getBodySize() + 15L;
            if (newPosition >= this.getTotalBytes()) {
                log.info("New position exceeds limit");
                if (!log.isDebugEnabled()) break;
                log.debug("-----");
                log.debug("Keyframe analysis");
                log.debug(" data type=" + tmpTag.getDataType() + " bodysize=" + tmpTag.getBodySize());
                log.debug(" remaining=" + this.getRemainingBytes() + " limit=" + this.getTotalBytes() + " new pos=" + newPosition);
                log.debug(" pos=" + pos);
                log.debug("-----");
                break;
            }
            this.setCurrentPosition(newPosition);
        }
        this.setCurrentPosition(origPos);
        this.keyframeMeta = new IKeyFrameDataAnalyzer.KeyFrameMeta();
        this.keyframeMeta.duration = this.duration;
        this.posTimeMap = new HashMap();
        if (audioOnly) {
            positionList = audioPositionList;
            timestampList = audioTimestampList;
        }
        this.keyframeMeta.audioOnly = audioOnly;
        this.keyframeMeta.positions = new long[positionList.size()];
        this.keyframeMeta.timestamps = new int[timestampList.size()];
        for (int i = 0; i < this.keyframeMeta.positions.length; ++i) {
            this.keyframeMeta.positions[i] = (Long)positionList.get(i);
            this.keyframeMeta.timestamps[i] = (Integer)timestampList.get(i);
            this.posTimeMap.put((long)((Long)positionList.get(i)), (long)((Integer)timestampList.get(i)));
        }
        if (keyframeCache != null) {
            keyframeCache.saveKeyFrameMeta(this.file, this.keyframeMeta);
        }
        return this.keyframeMeta;
    }

    public void position(long pos) {
        this.setCurrentPosition(pos);
        if (pos == Long.MAX_VALUE) {
            this.tagPosition = this.posTagMap.size() + 1;
            return;
        }
        this.analyzeKeyFrames();
        Integer tag = this.posTagMap.get(pos);
        if (tag == null) {
            return;
        }
        this.tagPosition = tag;
    }

    private ITag readTagHeader() {
        this.fillBuffer(15L);
        int previousTagSize = this.in.getInt();
        byte dataType = this.in.get();
        int bodySize = IOUtils.readUnsignedMediumInt(this.in);
        int timestamp = IOUtils.readUnsignedMediumInt(this.in);
        this.in.getInt();
        return new Tag(dataType, timestamp, bodySize, null, previousTagSize);
    }
}

