/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.flv.impl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.IStreamableFile;
import org.red5.io.ITag;
import org.red5.io.ITagWriter;
import org.red5.io.amf.Output;
import org.red5.io.flv.IFLV;
import org.red5.io.flv.impl.Tag;
import org.red5.io.object.Serializer;
import org.red5.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLVWriter
implements ITagWriter {
    private static Logger log = LoggerFactory.getLogger(FLVWriter.class);
    private FileOutputStream fos;
    private FileChannel channel;
    private ByteBuffer out;
    private IFLV flv;
    private long bytesWritten;
    private int offset;
    private int fileMetaSize = 0;
    private int videoCodecId = -1;
    private int audioCodecId = -1;
    private boolean append;
    private int duration;
    private long metaPosition;

    public FLVWriter(FileOutputStream fos, boolean append) {
        this.fos = fos;
        this.channel = this.fos.getChannel();
        this.out = ByteBuffer.allocate((int)1024);
        this.out.setAutoExpand(true);
        this.append = append;
    }

    public void writeHeader() throws IOException {
        this.out.put((byte)70);
        this.out.put((byte)76);
        this.out.put((byte)86);
        this.out.put((byte)1);
        this.out.put((byte)5);
        this.out.putInt(9);
        this.out.putInt(0);
        this.out.flip();
        this.channel.write(this.out.buf());
    }

    public IStreamableFile getFile() {
        return this.flv;
    }

    public void setFLV(IFLV flv) {
        this.flv = flv;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public boolean writeTag(ITag tag) throws IOException {
        if (!this.append && this.bytesWritten == 0L && tag.getDataType() != 18) {
            this.writeMetadataTag(0.0, -1, -1);
        }
        this.out.clear();
        this.out.put(tag.getDataType());
        IOUtils.writeMediumInt(this.out, tag.getBodySize());
        IOUtils.writeMediumInt(this.out, tag.getTimestamp() + this.offset);
        this.out.putInt(0);
        this.out.flip();
        this.bytesWritten += (long)this.channel.write(this.out.buf());
        ByteBuffer bodyBuf = tag.getBody();
        this.bytesWritten += (long)this.channel.write(bodyBuf.buf());
        if (this.audioCodecId == -1 && tag.getDataType() == 8) {
            bodyBuf.flip();
            byte id = bodyBuf.get();
            this.audioCodecId = (id & 0xFFFFFFF1) >> 4;
        } else if (this.videoCodecId == -1 && tag.getDataType() == 9) {
            bodyBuf.flip();
            byte id = bodyBuf.get();
            this.videoCodecId = id & 0xF;
        }
        this.duration = Math.max(this.duration, tag.getTimestamp() + this.offset);
        this.out.clear();
        this.out.putInt(tag.getBodySize() + 11);
        this.out.flip();
        this.bytesWritten += (long)this.channel.write(this.out.buf());
        return false;
    }

    public boolean writeTag(byte type, ByteBuffer data) throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.metaPosition > 0L) {
                long oldPos = this.channel.position();
                try {
                    this.channel.position(this.metaPosition);
                    this.writeMetadataTag((double)this.duration * 0.001, this.videoCodecId, this.audioCodecId);
                }
                finally {
                    this.channel.position(oldPos);
                }
            }
            this.channel.close();
            this.fos.close();
        }
        catch (IOException e) {
            log.error("FLVWriter :: close ::>\n", (Throwable)e);
        }
    }

    public boolean writeStream(byte[] b) {
        return false;
    }

    private void writeMetadataTag(double duration, Integer videoCodecId, Integer audioCodecId) throws IOException {
        this.metaPosition = this.channel.position();
        ByteBuffer buf = ByteBuffer.allocate((int)1024);
        buf.setAutoExpand(true);
        Output out = new Output(buf);
        out.writeString("onMetaData");
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("duration", duration);
        if (videoCodecId != null) {
            params.put("videocodecid", videoCodecId);
        }
        if (audioCodecId != null) {
            params.put("audiocodecid", audioCodecId);
        }
        params.put("canSeekToEnd", true);
        out.writeMap(params, new Serializer());
        buf.flip();
        if (this.fileMetaSize == 0) {
            this.fileMetaSize = buf.limit();
        }
        Tag onMetaData = new Tag(18, 0, this.fileMetaSize, buf, 0);
        this.writeTag(onMetaData);
    }
}

