/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.flv.meta;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.ITag;
import org.red5.io.amf.Input;
import org.red5.io.amf.Output;
import org.red5.io.flv.impl.FLVReader;
import org.red5.io.flv.impl.FLVWriter;
import org.red5.io.flv.impl.Tag;
import org.red5.io.flv.meta.IMeta;
import org.red5.io.flv.meta.IMetaCue;
import org.red5.io.flv.meta.IMetaData;
import org.red5.io.flv.meta.IMetaService;
import org.red5.io.flv.meta.MetaCue;
import org.red5.io.flv.meta.MetaData;
import org.red5.io.flv.meta.Resolver;
import org.red5.io.object.Deserializer;
import org.red5.io.object.Serializer;

public class MetaService
implements IMetaService {
    File file;
    private FileInputStream fis;
    private FileOutputStream fos;
    private Serializer serializer;
    private Deserializer deserializer;
    private Resolver resolver;

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public Deserializer getDeserializer() {
        return this.deserializer;
    }

    public void setDeserializer(Deserializer deserializer) {
        this.deserializer = deserializer;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public MetaService() {
    }

    public MetaService(File poFil) {
        this();
        this.file = poFil;
    }

    public void write(IMetaData meta) throws IOException {
        Object[] metaArr = meta.getMetaCue();
        FLVReader reader = new FLVReader(this.file, false);
        FLVWriter writer = new FLVWriter(this.fos, false);
        ITag tag = null;
        if (reader.hasMoreTags() && (tag = reader.readTag()).getDataType() == 18 && !reader.hasMoreTags()) {
            throw new IOException("File we're writing is metadata only?");
        }
        meta.setDuration((double)reader.getDuration() / 1000.0);
        meta.setVideoCodecId(reader.getVideoCodecId());
        meta.setAudioCodecId(reader.getAudioCodecId());
        ITag injectedTag = this.injectMetaData(meta, tag);
        injectedTag.setPreviousTagSize(0);
        tag.setPreviousTagSize(injectedTag.getBodySize());
        writer.writeHeader();
        writer.writeTag(injectedTag);
        writer.writeTag(tag);
        int cuePointTimeStamp = 0;
        int counter = 0;
        if (metaArr != null) {
            Arrays.sort(metaArr);
            cuePointTimeStamp = this.getTimeInMilliseconds((IMetaCue)metaArr[0]);
        }
        while (reader.hasMoreTags()) {
            tag = reader.readTag();
            if (counter < metaArr.length) {
                while (tag.getTimestamp() > cuePointTimeStamp) {
                    injectedTag = this.injectMetaCue((IMetaCue)metaArr[counter], tag);
                    writer.writeTag(injectedTag);
                    tag.setPreviousTagSize(injectedTag.getBodySize());
                    if (++counter > metaArr.length - 1) break;
                    cuePointTimeStamp = this.getTimeInMilliseconds((IMetaCue)metaArr[counter]);
                }
            }
            if (tag.getDataType() == 18) continue;
            writer.writeTag(tag);
        }
        writer.close();
    }

    private IMeta mergeMeta(IMetaData metaData, IMetaData md) {
        return new Resolver().resolve(metaData, md);
    }

    private ITag injectMetaData(IMetaData meta, ITag tag) {
        ByteBuffer bb = ByteBuffer.allocate((int)1000);
        bb.setAutoExpand(true);
        Output out = new Output(bb);
        Serializer ser = new Serializer();
        ser.serialize(out, "onMetaData");
        ser.serialize(out, meta);
        ByteBuffer tmpBody = out.buf().flip();
        int tmpBodySize = out.buf().limit();
        int tmpPreviousTagSize = tag.getPreviousTagSize();
        byte tmpDataType = 18;
        int tmpTimestamp = 0;
        return new Tag(tmpDataType, tmpTimestamp, tmpBodySize, tmpBody, tmpPreviousTagSize);
    }

    private ITag injectMetaCue(IMetaCue meta, ITag tag) {
        Output out = new Output(ByteBuffer.allocate((int)1000));
        Serializer ser = new Serializer();
        ser.serialize(out, "onCuePoint");
        ser.serialize(out, meta);
        ByteBuffer tmpBody = out.buf().flip();
        int tmpBodySize = out.buf().limit();
        int tmpPreviousTagSize = tag.getPreviousTagSize();
        byte tmpDataType = 18;
        int tmpTimestamp = this.getTimeInMilliseconds(meta);
        return new Tag(tmpDataType, tmpTimestamp, tmpBodySize, tmpBody, tmpPreviousTagSize);
    }

    private int getTimeInMilliseconds(IMetaCue metaCue) {
        return (int)(metaCue.getTime() * 1000.0);
    }

    public void writeMetaData(IMetaData metaData) {
        MetaCue meta = (MetaCue)((Object)metaData);
        Output out = new Output(ByteBuffer.allocate((int)1000));
        this.serializer.serialize(out, "onCuePoint");
        this.serializer.serialize(out, meta);
    }

    public void writeMetaCue() {
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setInStream(FileInputStream fis) {
        this.fis = fis;
    }

    public void setOutStream(FileOutputStream fos) {
        this.fos = fos;
    }

    public MetaData readMetaData(ByteBuffer buffer) {
        MetaData retMeta = new MetaData();
        Input input = new Input(buffer);
        if (this.deserializer == null) {
            this.deserializer = new Deserializer();
        }
        String metaType = this.deserializer.deserialize(input, String.class);
        Map m = this.deserializer.deserialize(input, Map.class);
        retMeta.putAll(m);
        return retMeta;
    }

    public IMetaCue[] readMetaCue() {
        return null;
    }
}

