/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.object;

import org.red5.io.object.DataTypes;
import org.red5.io.object.Input;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deserializer {
    protected static Logger log = LoggerFactory.getLogger(Deserializer.class);

    public <T> T deserialize(Input in, Class<T> target) {
        Object result;
        byte type = in.readDataType();
        while (type == 0) {
            type = in.readDataType();
        }
        if (log.isDebugEnabled()) {
            log.debug("Datatype: " + DataTypes.toStringValue(type));
        }
        switch (type) {
            case 1: {
                result = in.readNull();
                break;
            }
            case 2: {
                result = in.readBoolean();
                break;
            }
            case 3: {
                result = in.readNumber();
                break;
            }
            case 4: {
                result = in.readString();
                break;
            }
            case 5: {
                result = in.readDate();
                break;
            }
            case 6: {
                result = in.readArray(this);
                break;
            }
            case 7: {
                result = in.readMap(this);
                break;
            }
            case 8: {
                result = in.readXML();
                break;
            }
            case 9: {
                result = in.readObject(this);
                break;
            }
            case 16: {
                result = in.readByteArray();
                break;
            }
            case 17: {
                result = in.readReference();
                break;
            }
            default: {
                result = in.readCustom();
            }
        }
        return (T)this.postProcessExtension(result, target);
    }

    protected Object postProcessExtension(Object result, Class target) {
        return result;
    }
}

