/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.object;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.BeanMap;
import org.red5.io.amf3.ByteArray;
import org.red5.io.amf3.IExternalizable;
import org.red5.io.object.Output;
import org.red5.io.object.RecordSet;
import org.red5.io.utils.ObjectMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Serializer {
    protected static Logger log = LoggerFactory.getLogger(Serializer.class);

    public void serialize(Output out, Object any) {
        if (log.isDebugEnabled()) {
            log.debug("serialize");
        }
        if (any instanceof IExternalizable) {
            out.writeObject(any, this);
            return;
        }
        if (any instanceof ByteArray) {
            out.writeByteArray((ByteArray)any);
            return;
        }
        if (this.writeBasic(out, any)) {
            if (log.isDebugEnabled()) {
                log.debug("write basic");
            }
            return;
        }
        if (!this.writeComplex(out, any) && log.isDebugEnabled()) {
            log.debug("Unable to serialize: " + any);
        }
    }

    protected boolean writeBasic(Output out, Object basic) {
        if (basic == null) {
            out.writeNull();
        } else if (basic instanceof Boolean) {
            out.writeBoolean((Boolean)basic);
        } else if (basic instanceof Number) {
            out.writeNumber((Number)basic);
        } else if (basic instanceof String) {
            out.writeString((String)basic);
        } else if (basic instanceof Date) {
            out.writeDate((Date)basic);
        } else {
            return false;
        }
        return true;
    }

    public boolean writeComplex(Output out, Object complex) {
        if (log.isDebugEnabled()) {
            log.debug("writeComplex");
        }
        if (this.writeListType(out, complex)) {
            return true;
        }
        if (this.writeArrayType(out, complex)) {
            return true;
        }
        if (this.writeXMLType(out, complex)) {
            return true;
        }
        if (this.writeCustomType(out, complex)) {
            return true;
        }
        return this.writeObjectType(out, complex);
    }

    protected boolean writeListType(Output out, Object listType) {
        if (log.isDebugEnabled()) {
            log.debug("writeListType");
        }
        if (!(listType instanceof List)) {
            return false;
        }
        this.writeList(out, (List)listType);
        return true;
    }

    protected void writeList(Output out, List<?> list) {
        if (list.size() < 100) {
            out.writeArray(list, this);
            return;
        }
        int size = list.size();
        int nullCount = 0;
        for (int i = 0; i < size; ++i) {
            if (list.get(i) != null) continue;
            ++nullCount;
        }
        if ((double)nullCount > (double)size * 0.8) {
            out.writeMap(list, this);
        } else {
            out.writeArray(list, this);
        }
    }

    protected boolean writeArrayType(Output out, Object arrType) {
        if (log.isDebugEnabled()) {
            log.debug("writeArrayType");
        }
        if (arrType instanceof Collection) {
            out.writeArray((Collection)arrType, this);
        } else if (arrType instanceof Iterator) {
            this.writeIterator(out, (Iterator)arrType);
        } else if (arrType.getClass().isArray() && arrType.getClass().getComponentType().isPrimitive()) {
            out.writeArray(arrType, this);
        } else if (arrType instanceof Object[]) {
            out.writeArray((Object[])arrType, this);
        } else {
            return false;
        }
        return true;
    }

    protected void writeIterator(Output out, Iterator<Object> it) {
        if (log.isDebugEnabled()) {
            log.debug("writeIterator");
        }
        LinkedList<Object> list = new LinkedList<Object>();
        while (it.hasNext()) {
            list.addLast(it.next());
        }
        out.writeArray(list, this);
    }

    protected boolean writeXMLType(Output out, Object xml) {
        if (log.isDebugEnabled()) {
            log.debug("writeXMLType");
        }
        if (!(xml instanceof Document)) {
            return false;
        }
        this.writeDocument(out, (Document)xml);
        return true;
    }

    protected void writeDocument(Output out, Document doc) {
        out.writeXML(doc);
    }

    protected boolean writeObjectType(Output out, Object obj) {
        if (obj instanceof ObjectMap || obj instanceof BeanMap) {
            out.writeObject((Map)obj, this);
        } else if (obj instanceof Map) {
            out.writeMap((Map)obj, this);
        } else if (obj instanceof RecordSet) {
            out.writeRecordSet((RecordSet)obj, this);
        } else {
            out.writeObject(obj, this);
        }
        return true;
    }

    public Object preProcessExtension(Object any) {
        return any;
    }

    protected boolean writeCustomType(Output out, Object obj) {
        if (out.isCustom(obj)) {
            out.writeCustom(obj);
            return true;
        }
        return false;
    }
}

