/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import org.red5.io.utils.HexCharset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexDump {
    private static final Logger logger = LoggerFactory.getLogger(HexDump.class);
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static char[] BIT_DIGIT = new char[]{'0', '1'};
    private static final byte[] COMPARE_BITS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static char BYTE_SEPARATOR = (char)32;
    private static boolean WITH_BYTE_SEPARATOR = true;

    public static String prettyPrintHex(ByteBuffer bbToConvert) {
        return HexDump.prettyPrintHex(bbToConvert.array());
    }

    public static String prettyPrintHex(byte[] baToConvert) {
        HexCharset hde = (HexCharset)HexCharset.forName("HEX");
        return new String(hde.encode(new String(baToConvert)).array());
    }

    public static String prettyPrintHex(String sToConvert) {
        HexCharset hde = (HexCharset)HexCharset.forName("HEX");
        return new String(hde.encode(sToConvert).array());
    }

    public static void setWithByteSeparator(boolean bs) {
        WITH_BYTE_SEPARATOR = bs;
    }

    public static void setByteSeparator(char bs) {
        BYTE_SEPARATOR = bs;
    }

    public static void setBitDigits(char[] bd) throws Exception {
        if (bd.length != 2) {
            throw new Exception("wrong number of characters!");
        }
        BIT_DIGIT = bd;
    }

    public static void setBitDigits(char zeroBit, char oneBit) {
        HexDump.BIT_DIGIT[0] = zeroBit;
        HexDump.BIT_DIGIT[1] = oneBit;
    }

    public static String byteArrayToBinaryString(byte[] block) {
        StringBuffer strBuf = new StringBuffer();
        int iLen = block.length;
        for (int i = 0; i < iLen; ++i) {
            HexDump.byte2bin(block[i], strBuf);
            if (!(i < iLen - 1 & WITH_BYTE_SEPARATOR)) continue;
            strBuf.append(BYTE_SEPARATOR);
        }
        return strBuf.toString();
    }

    public static String toBinaryString(byte[] ba) {
        return HexDump.byteArrayToBinaryString(ba);
    }

    public static String toBinaryString(byte b) {
        byte[] ba = new byte[]{b};
        return HexDump.byteArrayToBinaryString(ba);
    }

    public static String toBinaryString(short s) {
        return HexDump.toBinaryString(HexDump.toByteArray(s));
    }

    public static String toBinaryString(int i) {
        return HexDump.toBinaryString(HexDump.toByteArray(i));
    }

    public static String toBinaryString(long l) {
        return HexDump.toBinaryString(HexDump.toByteArray(l));
    }

    public static final byte[] toByteArray(short s) {
        byte[] baTemp = new byte[2];
        baTemp[1] = (byte)s;
        baTemp[0] = (byte)(s >> 8);
        return baTemp;
    }

    public static final byte[] toByteArray(int i) {
        byte[] baTemp = new byte[4];
        baTemp[3] = (byte)i;
        baTemp[2] = (byte)(i >> 8);
        baTemp[1] = (byte)(i >> 16);
        baTemp[0] = (byte)(i >> 24);
        return baTemp;
    }

    public static final byte[] toByteArray(long l) {
        byte[] baTemp = new byte[8];
        baTemp[7] = (byte)l;
        baTemp[6] = (byte)(l >> 8);
        baTemp[5] = (byte)(l >> 16);
        baTemp[4] = (byte)(l >> 24);
        baTemp[3] = (byte)(l >> 32);
        baTemp[2] = (byte)(l >> 40);
        baTemp[1] = (byte)(l >> 48);
        baTemp[0] = (byte)(l >> 56);
        return baTemp;
    }

    public static String byteArrayToHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            HexDump.byte2hex(block[i], buf);
            if (!(i < len - 1 & WITH_BYTE_SEPARATOR)) continue;
            buf.append(BYTE_SEPARATOR);
        }
        return buf.toString();
    }

    public static String stringToHexString(String in) {
        byte[] ba = in.getBytes();
        return HexDump.toHexString(ba);
    }

    public static String byteArrayToHexString(byte[] block, int offset, int length) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        if (len < (length += offset)) {
            length = len;
        }
        for (int i = 0 + offset; i < length; ++i) {
            HexDump.byte2hex(block[i], buf);
            if (i >= length - 1) continue;
            buf.append(':');
        }
        return buf.toString();
    }

    public static String toHexString(byte[] ba) {
        return HexDump.toHexString(ba, 0, ba.length);
    }

    public static String toHexString(byte b) {
        byte[] ba = new byte[]{b};
        return HexDump.toHexString(ba, 0, ba.length);
    }

    public static String toHexString(short s) {
        return HexDump.toHexString(HexDump.toByteArray(s));
    }

    public static String toHexString(int i) {
        return HexDump.toHexString(HexDump.toByteArray(i));
    }

    public static String toHexString(long l) {
        return HexDump.toHexString(HexDump.toByteArray(l));
    }

    public static String toString(byte[] ba) {
        return new String(ba);
    }

    public static String toString(byte b) {
        byte[] ba = new byte[]{b};
        return new String(ba);
    }

    public static String toHexString(byte[] ba, int offset, int length) {
        char[] buf = WITH_BYTE_SEPARATOR ? new char[length * 3] : new char[length * 2];
        int i = offset;
        int j = 0;
        while (i < offset + length) {
            byte k = ba[i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
            if (!WITH_BYTE_SEPARATOR) continue;
            buf[j++] = BYTE_SEPARATOR;
        }
        return new String(buf);
    }

    public static byte[] hexStringToByteArray(String strA) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        int sum = 0;
        boolean nextCharIsUpper = true;
        block18: for (int i = 0; i < strA.length(); ++i) {
            char c = strA.charAt(i);
            switch (Character.toUpperCase(c)) {
                case '0': {
                    if (nextCharIsUpper) {
                        sum = 0;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 0);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case '1': {
                    if (nextCharIsUpper) {
                        sum = 16;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 1);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case '2': {
                    if (nextCharIsUpper) {
                        sum = 32;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 2);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case '3': {
                    if (nextCharIsUpper) {
                        sum = 48;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 3);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case '4': {
                    if (nextCharIsUpper) {
                        sum = 64;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 4);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case '5': {
                    if (nextCharIsUpper) {
                        sum = 80;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 5);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case '6': {
                    if (nextCharIsUpper) {
                        sum = 96;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 6);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case '7': {
                    if (nextCharIsUpper) {
                        sum = 112;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 7);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case '8': {
                    if (nextCharIsUpper) {
                        sum = -128;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 8);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case '9': {
                    if (nextCharIsUpper) {
                        sum = -112;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 9);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case 'A': {
                    if (nextCharIsUpper) {
                        sum = -96;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 0xA);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case 'B': {
                    if (nextCharIsUpper) {
                        sum = -80;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 0xB);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case 'C': {
                    if (nextCharIsUpper) {
                        sum = -64;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 0xC);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case 'D': {
                    if (nextCharIsUpper) {
                        sum = -48;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 0xD);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case 'E': {
                    if (nextCharIsUpper) {
                        sum = -32;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 0xE);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
                case 'F': {
                    if (nextCharIsUpper) {
                        sum = -16;
                        nextCharIsUpper = false;
                        continue block18;
                    }
                    sum = (byte)(sum | 0xF);
                    result.write(sum);
                    nextCharIsUpper = true;
                    continue block18;
                }
            }
        }
        if (!nextCharIsUpper) {
            throw new RuntimeException("The String did not contain an equal number of hex digits");
        }
        return result.toByteArray();
    }

    private static void byte2hex(byte b, StringBuffer buf) {
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(HEX_DIGITS[high]);
        buf.append(HEX_DIGITS[low]);
    }

    private static void byte2bin(byte b, StringBuffer buf) {
        for (int i = 0; i < 8; ++i) {
            if ((b & COMPARE_BITS[i]) != 0) {
                buf.append(BIT_DIGIT[1]);
                continue;
            }
            buf.append(BIT_DIGIT[0]);
        }
    }

    private static String intToHexString(int n) {
        char[] buf = new char[8];
        for (int i = 7; i >= 0; --i) {
            buf[i] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
        }
        return new String(buf);
    }

    public static void main(String[] args) {
        logger.info("-test and demo of the converter ");
        String str = "Niko";
        byte[] ba = str.getBytes();
        logger.info("to convert: " + str);
        logger.info("converted1: " + HexDump.byteArrayToHexString(ba));
        logger.info("converted1: " + HexDump.byteArrayToHexString(ba, 0, ba.length));
        logger.info("converted3: " + HexDump.stringToHexString(str));
        logger.info("----Convert integer to hexString...");
        int i = -2;
        logger.info("to convert: " + i + " -> " + HexDump.intToHexString(i));
        logger.info("----Convert byte[] to binary String...");
        byte[] baToConvert = new byte[]{-1, 0, 51, 17, -1, 95, 95, 79, 31, -1};
        logger.info("to convert: " + HexDump.toHexString(baToConvert) + " -> " + HexDump.byteArrayToBinaryString(baToConvert));
        HexDump.setByteSeparator('-');
        logger.info("to convert: " + HexDump.toHexString(baToConvert) + " -> " + HexDump.byteArrayToBinaryString(baToConvert));
        HexDump.setByteSeparator('*');
        HexDump.setWithByteSeparator(true);
        logger.info("to convert: " + HexDump.toHexString(baToConvert) + " -> " + HexDump.byteArrayToBinaryString(baToConvert));
        char[] bd = new char[]{'a', 'b'};
        try {
            HexDump.setBitDigits(bd);
        }
        catch (Exception ex) {
            logger.debug("", (Throwable)ex);
        }
        logger.info("to convert: " + HexDump.toHexString(baToConvert) + " -> " + HexDump.byteArrayToBinaryString(baToConvert));
        HexDump.setBitDigits('0', '1');
        logger.info("---- Convert.toByteArray(int) ");
        for (int iToConvert = -10; iToConvert < 10; ++iToConvert) {
            logger.info("to convert = " + iToConvert + " = " + HexDump.toBinaryString(iToConvert));
            byte[] baConvInt = new byte[4];
            baConvInt = HexDump.toByteArray(iToConvert);
            logger.info("convertet byteArray = " + HexDump.toBinaryString(baConvInt));
        }
        logger.info("---- toHexString(int) ");
        i = -1;
        logger.info(i + " = 0x" + HexDump.toHexString(i) + " = " + HexDump.toBinaryString(i));
        logger.info(++i + " = 0x" + HexDump.toHexString(i) + " = " + HexDump.toBinaryString(i));
        logger.info("---- toHexString(long) ");
        long l = 100L;
        logger.info(l + " = 0x" + HexDump.toHexString(l) + " = " + HexDump.toBinaryString(l));
        Random rnd = new Random();
        l = rnd.nextLong();
        logger.info(l + " = 0x" + HexDump.toHexString(l) + " = " + HexDump.toBinaryString(l));
        logger.info("---- toHexString(short) ");
        short s = 100;
        logger.info(s + " = 0x" + HexDump.toHexString(s) + " = " + HexDump.toBinaryString(s));
        rnd = new Random();
        s = (short)rnd.nextInt();
        logger.info(s + " = 0x" + HexDump.toHexString(s) + " = " + HexDump.toBinaryString(s));
        logger.info("---- read file in Hex-Format ");
        String strToConvert = "12345654321";
        logger.info(strToConvert + " = " + HexDump.stringToHexString(strToConvert));
        logger.info("Das ist die Hex-Darstellung des obigen Strings");
        logger.info("ba = " + HexDump.toHexString(ba));
    }

    public static String formatHexDump(String in) {
        int chunk = 60;
        StringBuffer out = new StringBuffer();
        int from = 0;
        int to = 0;
        int size = in.length();
        while (from < size) {
            to = size < from + chunk ? size : from + chunk;
            out.append(in.substring(from, to));
            out.append("\n");
            from = to;
        }
        return out.toString();
    }
}

