/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.ICastingAttributeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeStore
implements ICastingAttributeStore {
    protected ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    protected Map<String, Object> filterNull(Map<String, Object> values) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (key == null || (value = entry.getValue()) == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public AttributeStore() {
    }

    public AttributeStore(Map<String, Object> values) {
        this.setAttributes(values);
    }

    public AttributeStore(IAttributeStore values) {
        this.setAttributes(values);
    }

    @Override
    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Object getAttribute(String name) {
        if (name == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public Object getAttribute(String name, Object defaultValue) {
        if (name == null) {
            return null;
        }
        if (defaultValue == null) {
            throw new NullPointerException("the default value may not be null");
        }
        Object result = this.attributes.putIfAbsent(name, defaultValue);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public boolean hasAttribute(String name) {
        if (name == null) {
            return false;
        }
        return this.attributes.containsKey(name);
    }

    @Override
    public boolean setAttribute(String name, Object value) {
        if (name == null) {
            return false;
        }
        if (value == null) {
            return this.attributes.remove(name) != null;
        }
        Object previous = this.attributes.put(name, value);
        return previous == null || value == previous || !value.equals(previous);
    }

    @Override
    public void setAttributes(Map<String, Object> values) {
        this.attributes.putAll(this.filterNull(values));
    }

    @Override
    public void setAttributes(IAttributeStore values) {
        this.setAttributes(values.getAttributes());
    }

    @Override
    public boolean removeAttribute(String name) {
        if (name == null) {
            return false;
        }
        return this.attributes.remove(name) != null;
    }

    @Override
    public void removeAttributes() {
        this.attributes.clear();
    }

    @Override
    public Boolean getBoolAttribute(String name) {
        return (Boolean)this.getAttribute(name);
    }

    @Override
    public Byte getByteAttribute(String name) {
        return (Byte)this.getAttribute(name);
    }

    @Override
    public Double getDoubleAttribute(String name) {
        return (Double)this.getAttribute(name);
    }

    @Override
    public Integer getIntAttribute(String name) {
        return (Integer)this.getAttribute(name);
    }

    @Override
    public List getListAttribute(String name) {
        return (List)this.getAttribute(name);
    }

    @Override
    public Long getLongAttribute(String name) {
        return (Long)this.getAttribute(name);
    }

    @Override
    public Map getMapAttribute(String name) {
        return (Map)this.getAttribute(name);
    }

    @Override
    public Set getSetAttribute(String name) {
        return (Set)this.getAttribute(name);
    }

    @Override
    public Short getShortAttribute(String name) {
        return (Short)this.getAttribute(name);
    }

    @Override
    public String getStringAttribute(String name) {
        return (String)this.getAttribute(name);
    }
}

