/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.red5.server.AttributeStore;
import org.red5.server.Client;
import org.red5.server.Scope;
import org.red5.server.api.IBasicScope;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.IScope;
import org.red5.server.api.event.IEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConnection
extends AttributeStore
implements IConnection {
    protected static Logger log = LoggerFactory.getLogger(BaseConnection.class);
    protected String type;
    protected String host;
    protected String remoteAddress;
    protected List<String> remoteAddresses;
    protected int remotePort;
    protected String path;
    protected String sessionId;
    protected long readMessages;
    protected long writtenMessages;
    protected long droppedMessages;
    protected Map<String, Object> params = null;
    protected IClient client;
    protected Scope scope;
    protected Set<IBasicScope> basicScopes = new CopyOnWriteArraySet<IBasicScope>();
    protected boolean closed;

    public BaseConnection(String type, String host, String remoteAddress, int remotePort, String path, String sessionId, Map<String, Object> params) {
        this.type = type;
        this.host = host;
        this.remoteAddress = remoteAddress;
        this.remoteAddresses = new ArrayList<String>();
        this.remoteAddresses.add(remoteAddress);
        this.remoteAddresses = Collections.unmodifiableList(this.remoteAddresses);
        this.remotePort = remotePort;
        this.path = path;
        this.sessionId = sessionId;
        this.params = params;
    }

    @Override
    public void initialize(IClient client) {
        if (this.client != null && this.client instanceof Client) {
            ((Client)this.client).unregister(this);
        }
        this.client = client;
        if (this.client instanceof Client) {
            ((Client)this.client).register(this);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public List<String> getRemoteAddresses() {
        return this.remoteAddresses;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public Map<String, Object> getConnectParams() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public IClient getClient() {
        return this.client;
    }

    @Override
    public boolean isConnected() {
        return this.scope != null;
    }

    @Override
    public boolean connect(IScope newScope) {
        return this.connect(newScope, null);
    }

    @Override
    public boolean connect(IScope newScope, Object[] params) {
        Scope oldScope = this.scope;
        this.scope = (Scope)newScope;
        if (this.scope.connect(this, params)) {
            if (oldScope != null) {
                oldScope.disconnect(this);
            }
            return true;
        }
        this.scope = oldScope;
        return false;
    }

    @Override
    public IScope getScope() {
        return this.scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            if (this.closed || this.scope == null) {
                log.debug("Close, not connected nothing to do.");
                return;
            }
            this.closed = true;
        }
        log.debug("Close, disconnect from scope, and children");
        try {
            for (IBasicScope basicScope : this.basicScopes) {
                this.unregisterBasicScope(basicScope);
            }
        }
        catch (Exception err) {
            log.error("Error while unregistering basic scopes.", (Throwable)err);
        }
        try {
            this.scope.disconnect(this);
        }
        catch (Exception err) {
            log.error("Error while disconnecting from scope " + this.scope, (Throwable)err);
        }
        if (this.client != null && this.client instanceof Client) {
            ((Client)this.client).unregister(this);
            this.client = null;
        }
        this.scope = null;
    }

    @Override
    public void notifyEvent(IEvent event) {
    }

    @Override
    public void dispatchEvent(IEvent event) {
    }

    @Override
    public boolean handleEvent(IEvent event) {
        return this.getScope().handleEvent(event);
    }

    @Override
    public Iterator<IBasicScope> getBasicScopes() {
        return this.basicScopes.iterator();
    }

    public void registerBasicScope(IBasicScope basicScope) {
        this.basicScopes.add(basicScope);
        basicScope.addEventListener(this);
    }

    public void unregisterBasicScope(IBasicScope basicScope) {
        this.basicScopes.remove(basicScope);
        basicScope.removeEventListener(this);
    }

    @Override
    public abstract long getReadBytes();

    @Override
    public abstract long getWrittenBytes();

    @Override
    public long getReadMessages() {
        return this.readMessages;
    }

    @Override
    public long getWrittenMessages() {
        return this.writtenMessages;
    }

    @Override
    public long getDroppedMessages() {
        return this.droppedMessages;
    }

    @Override
    public long getPendingMessages() {
        return 0L;
    }

    public long getPendingVideoMessages(int streamId) {
        return 0L;
    }

    @Override
    public long getClientBytesRead() {
        return 0L;
    }
}

