/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.ObjectName;
import org.red5.server.AttributeStore;
import org.red5.server.ClientMBean;
import org.red5.server.ClientRegistry;
import org.red5.server.api.IBWControllable;
import org.red5.server.api.IBandwidthConfigure;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.IScope;
import org.red5.server.jmx.JMXAgent;
import org.red5.server.jmx.JMXFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
extends AttributeStore
implements IClient,
ClientMBean {
    protected static Logger log = LoggerFactory.getLogger(Client.class);
    protected static final String PERMISSIONS = "_transient_red5_permissions";
    protected ConcurrentMap<IConnection, IScope> connToScope = new ConcurrentHashMap<IConnection, IScope>();
    protected long creationTime;
    protected String id;
    private ObjectName oName;
    protected ClientRegistry registry;

    public Client() {
        log.debug("Default ctor called");
    }

    public Client(String id, ClientRegistry registry) {
        this.id = id;
        this.registry = registry;
        this.creationTime = System.currentTimeMillis();
        this.oName = JMXFactory.createObjectName("type", "Client", "id", id);
        JMXAgent.registerMBean((Object)this, this.getClass().getName(), ClientMBean.class, this.oName);
    }

    @Override
    public void disconnect() {
        log.debug("Disconnect - id: {}, closing {} connections", (Object)this.id, (Object)this.getConnections().size());
        for (IConnection con : this.getConnections()) {
            con.close();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Client)) {
            return false;
        }
        return ((Client)obj).getId().equals(this.id);
    }

    @Override
    public IBandwidthConfigure getBandwidthConfigure() {
        return null;
    }

    @Override
    public Set<IConnection> getConnections() {
        return this.connToScope.keySet();
    }

    @Override
    public Set<IConnection> getConnections(IScope scope) {
        if (scope == null) {
            return this.getConnections();
        }
        HashSet<IConnection> result = new HashSet<IConnection>();
        for (Map.Entry entry : this.connToScope.entrySet()) {
            if (!scope.equals(entry.getValue())) continue;
            result.add((IConnection)entry.getKey());
        }
        return result;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IBWControllable getParentBWControllable() {
        return null;
    }

    @Override
    public Collection<IScope> getScopes() {
        return this.connToScope.values();
    }

    public int hashCode() {
        return Integer.valueOf(this.id);
    }

    @Override
    public List<String> iterateScopeNameList() {
        log.debug("iterateScopeNameList called");
        ArrayList<String> scopeNames = new ArrayList<String>();
        log.debug("Scopes: {}", (Object)this.connToScope.values().size());
        for (IScope scope : this.connToScope.values()) {
            log.debug("Client scope: {}", (Object)scope);
            for (Map.Entry<String, Object> entry : scope.getAttributes().entrySet()) {
                log.debug("Client scope attr: {} = {}", (Object)entry.getKey(), entry.getValue());
            }
        }
        return scopeNames;
    }

    protected void register(IConnection conn) {
        log.debug("Registering connection for this client {}", (Object)this.id);
        if (conn != null) {
            if (conn.getScope() != null) {
                this.connToScope.put(conn, conn.getScope());
            } else {
                log.warn("Clients scope is null. Id: {}", (Object)this.id);
            }
        } else {
            log.warn("Clients connection is null. Id: {}", (Object)this.id);
        }
    }

    @Override
    public void setBandwidthConfigure(IBandwidthConfigure config) {
    }

    public String toString() {
        return "Client: " + this.id;
    }

    protected void unregister(IConnection conn) {
        this.connToScope.remove(conn);
        if (this.connToScope.isEmpty()) {
            if (this.registry != null) {
                this.registry.removeClient(this);
            }
            JMXAgent.unregisterMBean(this.oName);
        }
    }

    @Override
    public Collection<String> getPermissions(IConnection conn) {
        Collection result = (Collection)conn.getAttribute(PERMISSIONS);
        if (result == null) {
            result = Collections.EMPTY_SET;
        }
        return result;
    }

    @Override
    public boolean hasPermission(IConnection conn, String permissionName) {
        Collection<String> permissions = this.getPermissions(conn);
        return permissions.contains(permissionName);
    }

    @Override
    public void setPermissions(IConnection conn, Collection<String> permissions) {
        if (permissions == null) {
            conn.removeAttribute(PERMISSIONS);
        } else {
            conn.setAttribute(PERMISSIONS, permissions);
        }
    }
}

